/*
 * Decompiled with CFR 0.152.
 */
package nextflow.util;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.EqualsAndHashCode;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberPlus;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.util.HashCodeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EqualsAndHashCode(includes={"durationInMillis"})
public class Duration
implements Comparable<Duration>,
Serializable,
GroovyObject {
    private static final Object FORMAT;
    private static final Object LEGACY;
    private static final List<String> MILLIS;
    private static final List<String> SECONDS;
    private static final List<String> MINUTES;
    private static final List<String> HOURS;
    private static final List<String> DAYS;
    private final long durationInMillis;
    private static final Map<Integer, ThrottleObj> throttleMap;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1428745933565;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    public Duration(long l) {
        void duration;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            void v0 = duration;
            valueRecorder.record((Object)((long)v0), 8);
            boolean bl = v0 >= (long)0;
            valueRecorder.record((Object)bl, 16);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert duration>=0", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        void var5_4 = duration;
        this.durationInMillis = var5_4;
    }

    private Duration() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        int n = 0;
        this.durationInMillis = n;
    }

    /*
     * WARNING - void declaration
     */
    public Duration(String string) {
        void str;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        try {
            try {
                long l = this.parseSimple((String)str);
                this.durationInMillis = l;
            }
            catch (IllegalArgumentException e) {
                long l = this.parseLegacy((String)str);
                this.durationInMillis = l;
            }
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{str}, new String[]{"Not a valid duration value: ", ""})), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Duration(long l, TimeUnit timeUnit) {
        void value0;
        void unit;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            void v0 = unit;
            valueRecorder.record((Object)v0, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)v0)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert unit", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        long l2 = unit.toMillis((long)value0);
        this.durationInMillis = l2;
    }

    private long parseLegacy(String str) {
        Matcher matcher = (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)str, (Object)LEGACY), Matcher.class);
        if (!matcher.matches()) {
            new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{str}, new String[]{"Not a valid duration value: ", ""})));
        }
        List groups = (List)ScriptBytecodeAdapter.castToType((Object)StringGroovyMethods.getAt((Matcher)matcher, (int)0), List.class);
        Integer hh = StringGroovyMethods.toInteger((String)ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)groups, (int)1)));
        Integer mm = StringGroovyMethods.toInteger((String)ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)groups, (int)2)));
        Integer ss = StringGroovyMethods.toInteger((String)ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)groups, (int)3)));
        return TimeUnit.HOURS.toMillis(DefaultTypeTransformation.longUnbox((Object)hh)) + TimeUnit.MINUTES.toMillis(DefaultTypeTransformation.longUnbox((Object)mm)) + TimeUnit.SECONDS.toMillis(DefaultTypeTransformation.longUnbox((Object)ss));
    }

    private long parseSimple(String str) {
        long result = 0;
        int i = 0;
        while (true) {
            String string;
            Matcher matcher = (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)str, (Object)FORMAT), Matcher.class);
            if (!matcher.find()) {
                if (!(i == 0)) break;
                throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{str}, new String[]{"Not a valid duration value: ", ""})));
            }
            List groups = (List)ScriptBytecodeAdapter.castToType((Object)StringGroovyMethods.getAt((Matcher)matcher, (int)0), List.class);
            String all = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)groups, (int)0));
            String digit = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)groups, (int)1));
            String unit = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)groups, (int)2));
            long cfr_ignored_0 = result + this.convert(StringGroovyMethods.toInteger((String)digit), unit);
            str = string = str.substring(all.length()).trim();
            int n = i;
            int cfr_ignored_1 = n + 1;
        }
        return result;
    }

    private long convert(int digit, String unit) {
        if (DefaultTypeTransformation.booleanUnbox((Object)(MILLIS == null ? Boolean.valueOf(unit == null) : Boolean.valueOf(DefaultGroovyMethods.isCase(MILLIS, (Object)unit))))) {
            return digit;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)(SECONDS == null ? Boolean.valueOf(unit == null) : Boolean.valueOf(DefaultGroovyMethods.isCase(SECONDS, (Object)unit))))) {
            return TimeUnit.SECONDS.toMillis(digit);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)(MINUTES == null ? Boolean.valueOf(unit == null) : Boolean.valueOf(DefaultGroovyMethods.isCase(MINUTES, (Object)unit))))) {
            return TimeUnit.MINUTES.toMillis(digit);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)(HOURS == null ? Boolean.valueOf(unit == null) : Boolean.valueOf(DefaultGroovyMethods.isCase(HOURS, (Object)unit))))) {
            return TimeUnit.HOURS.toMillis(digit);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)(DAYS == null ? Boolean.valueOf(unit == null) : Boolean.valueOf(DefaultGroovyMethods.isCase(DAYS, (Object)unit))))) {
            return TimeUnit.DAYS.toMillis(digit);
        }
        throw (Throwable)new IllegalStateException();
    }

    public static Duration of(long value) {
        return new Duration(value);
    }

    public static Duration of(String str) {
        return new Duration(str);
    }

    public static Duration of(String str, Duration fallback) {
        Duration duration = new Duration(str);
        try {
            return duration;
        }
        catch (IllegalArgumentException e) {
            Object v0;
            if (DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.invokeMethod0(Duration.class, (Object)log, (String)"isDebugEnabled"))) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{str, fallback}, new String[]{"Not a valid duration value: ", " -- Fallback on default value: ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            Duration duration2 = fallback;
            return duration2;
        }
    }

    public long toMillis() {
        return this.durationInMillis;
    }

    public long toSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this.durationInMillis);
    }

    public long toMinutes() {
        return TimeUnit.MILLISECONDS.toMinutes(this.durationInMillis);
    }

    public long toHours() {
        return TimeUnit.MILLISECONDS.toHours(this.durationInMillis);
    }

    public long toDays() {
        return TimeUnit.MILLISECONDS.toDays(this.durationInMillis);
    }

    public String format(String fmt) {
        return DurationFormatUtils.formatDuration((long)this.durationInMillis, (String)fmt);
    }

    public String toString() {
        if (this.durationInMillis < (long)1000) {
            return StringGroovyMethods.plus((Number)this.durationInMillis, (String)ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt(MILLIS, (int)0)));
        }
        List value = DefaultGroovyMethods.collect((Object)this.format("d:H:m:s").split(":"), (Closure)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(String it) {
                return Integer.parseInt(it);
            }

            public Object call(String it) {
                return this.doCall(it);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _toString_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _toString_closure1.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_toString_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _toString_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        List result = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)DefaultGroovyMethods.getAt((List)value, (int)0), (Object)1)) {
            DefaultGroovyMethods.leftShift((Collection)result, (Object)StringGroovyMethods.plus((Number)((Number)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)value, (int)0), Number.class)), (String)ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt(DAYS, (int)0))));
        }
        if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)DefaultGroovyMethods.getAt((List)value, (int)1), (Object)1)) {
            DefaultGroovyMethods.leftShift((Collection)result, (Object)StringGroovyMethods.plus((Number)((Number)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)value, (int)1), Number.class)), (String)ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt(HOURS, (int)0))));
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)DefaultGroovyMethods.getAt((List)value, (int)2), (Object)0)) {
            DefaultGroovyMethods.leftShift((Collection)result, (Object)StringGroovyMethods.plus((Number)((Number)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)value, (int)2), Number.class)), (String)ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt(MINUTES, (int)0))));
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)DefaultGroovyMethods.getAt((List)value, (int)3), (Object)0)) {
            DefaultGroovyMethods.leftShift((Collection)result, (Object)StringGroovyMethods.plus((Number)((Number)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((List)value, (int)3), Number.class)), (String)ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt(SECONDS, (int)0))));
        }
        return DefaultGroovyMethods.join((Iterable)result, (String)" ");
    }

    @Override
    public int compareTo(Duration that) {
        return ScriptBytecodeAdapter.compareTo((Object)this.durationInMillis, (Object)that.getDurationInMillis());
    }

    public Object throttle(Closure closure) {
        return Duration.throttle0(this.durationInMillis, null, closure);
    }

    public Object throttle(Object seed, Closure closure) {
        ThrottleObj initialValue = new ThrottleObj(seed, System.currentTimeMillis());
        return Duration.throttle0(this.durationInMillis, initialValue, closure);
    }

    private static Object throttle0(long delayMillis, ThrottleObj initialValue, Closure closure) {
        int n;
        int n2;
        int n3;
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Closure closure2 = closure;
            valueRecorder.record((Object)closure2, 8);
            if (closure2 != null) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert closure != null", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        int key = 17;
        key = n3 = 31 * key + closure.getClass().hashCode();
        key = n2 = 31 * key + closure.getOwner().hashCode();
        Object object = closure.getDelegate();
        Number number = NumberNumberPlus.plus((Number)(31 * key), object != null ? Integer.valueOf(object.hashCode()) : null);
        Integer n4 = (Integer)ScriptBytecodeAdapter.castToType((Object)number, Integer.class);
        key = n = DefaultTypeTransformation.booleanUnbox((Object)number) ? n4 : 0;
        ThrottleObj obj = (ThrottleObj)ScriptBytecodeAdapter.castToType((Object)throttleMap.get(key), ThrottleObj.class);
        if (obj == null) {
            ThrottleObj throttleObj;
            ThrottleObj throttleObj2 = initialValue;
            obj = throttleObj = DefaultTypeTransformation.booleanUnbox((Object)throttleObj2) ? throttleObj2 : new ThrottleObj();
            throttleMap.put(key, obj);
        }
        if (System.currentTimeMillis() - obj.getTimestamp() > delayMillis) {
            obj.setTimestamp(System.currentTimeMillis());
            obj.setResult(closure.call());
        }
        return obj.getResult();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Duration.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public int hashCode() {
        int _result = HashCodeHelper.initHash();
        if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"durationInMillis"), (Object)this)) {
            int n;
            _result = n = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"durationInMillis"));
        }
        return _result;
    }

    public boolean canEqual(Object other) {
        return other instanceof Duration;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
        }
        if (DefaultGroovyMethods.is((Object)this, (Object)other)) {
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
        }
        if (!(other instanceof Duration)) {
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
        }
        Duration otherTyped = (Duration)ScriptBytecodeAdapter.castToType((Object)other, Duration.class);
        if (!otherTyped.canEqual(this)) {
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
        }
        if (!DefaultGroovyMethods.is((Object)this.getDurationInMillis(), (Object)otherTyped.getDurationInMillis())) {
            if (DefaultGroovyMethods.is((Object)this.getDurationInMillis(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getDurationInMillis(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getDurationInMillis(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getDurationInMillis(), (Object)otherTyped)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (!(DefaultGroovyMethods.is((Object)this.getDurationInMillis(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getDurationInMillis(), (Object)otherTyped)) && !(this.getDurationInMillis() == otherTyped.getDurationInMillis())) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(Duration.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Duration.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(Duration.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
    }

    static {
        Logger logger;
        List list;
        List list2;
        List list3;
        List list4;
        List list5;
        Object object;
        Object object2;
        Duration.__$swapInit();
        Long l = 0L;
        __timeStamp__239_neverHappen1428745933565 = l;
        Long l2 = 1428745933565L;
        __timeStamp = l2;
        FORMAT = object2 = ScriptBytecodeAdapter.bitwiseNegate((Object)"(\\d+)\\s*([a-zA-Z]+)");
        LEGACY = object = ScriptBytecodeAdapter.bitwiseNegate((Object)"(\\d{1,2}):(\\d{1,2}):(\\d{1,2})");
        MILLIS = list5 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"ms", "milli", "millis"});
        SECONDS = list4 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"s", "sec", "second", "seconds"});
        MINUTES = list3 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"m", "min", "minute", "minutes"});
        HOURS = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[]{"h", "hour", "hours"});
        DAYS = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"d", "day", "days"});
        ConcurrentHashMap<Integer, ThrottleObj> concurrentHashMap = new ConcurrentHashMap<Integer, ThrottleObj>();
        throttleMap = concurrentHashMap;
        log = logger = LoggerFactory.getLogger((String)"nextflow.util.Duration");
    }

    public final long getDurationInMillis() {
        return this.durationInMillis;
    }

    public static final Map<Integer, ThrottleObj> getThrottleMap() {
        return throttleMap;
    }

    public /* synthetic */ long this$2$parseLegacy(String string) {
        return this.parseLegacy(string);
    }

    public /* synthetic */ long this$2$parseSimple(String string) {
        return this.parseSimple(string);
    }

    public /* synthetic */ long this$2$convert(int n, String string) {
        return this.convert(n, string);
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(Duration.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = Duration.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @EqualsAndHashCode
    public static class ThrottleObj
    implements GroovyObject {
        private Object result;
        private long timestamp;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ThrottleObj() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        /*
         * WARNING - void declaration
         */
        public ThrottleObj(Object object, long l) {
            void timestamp;
            void value;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            void var5_4 = value;
            this.result = var5_4;
            void var6_5 = timestamp;
            this.timestamp = var6_5;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ThrottleObj.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public int hashCode() {
            int _result = HashCodeHelper.initHash();
            if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"result"), (Object)this)) {
                int n;
                _result = n = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"result"));
            }
            if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"timestamp"), (Object)this)) {
                int n;
                _result = n = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"timestamp"));
            }
            return _result;
        }

        public boolean canEqual(Object other) {
            return other instanceof ThrottleObj;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (DefaultGroovyMethods.is((Object)this, (Object)other)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
            }
            if (!(other instanceof ThrottleObj)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            ThrottleObj otherTyped = (ThrottleObj)ScriptBytecodeAdapter.castToType((Object)other, ThrottleObj.class);
            if (!otherTyped.canEqual(this)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (!DefaultGroovyMethods.is((Object)this.getResult(), (Object)otherTyped.getResult())) {
                if (DefaultGroovyMethods.is((Object)this.getResult(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getResult(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getResult(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getResult(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getResult(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getResult(), (Object)otherTyped)) && !ScriptBytecodeAdapter.compareEqual((Object)this.getResult(), (Object)otherTyped.getResult())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            if (!DefaultGroovyMethods.is((Object)this.getTimestamp(), (Object)otherTyped.getTimestamp())) {
                if (DefaultGroovyMethods.is((Object)this.getTimestamp(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getTimestamp(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getTimestamp(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getTimestamp(), (Object)otherTyped)) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
                if (!(DefaultGroovyMethods.is((Object)this.getTimestamp(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getTimestamp(), (Object)otherTyped)) && !(this.getTimestamp() == otherTyped.getTimestamp())) {
                    return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
                }
            }
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ThrottleObj.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ThrottleObj.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectProperty(ThrottleObj.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ThrottleObj.class, Duration.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Duration.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ThrottleObj.class, Duration.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            ThrottleObj.__$swapInit();
        }

        public Object getResult() {
            return this.result;
        }

        public void setResult(Object object) {
            this.result = object;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long l) {
            this.timestamp = l;
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(ThrottleObj.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ThrottleObj.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

