/*
 * Decompiled with CFR 0.152.
 */
package nextflow.file;

import com.google.common.hash.HashCode;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nextflow.Global;
import nextflow.ISession;
import nextflow.extension.Bolts;
import nextflow.extension.FilesEx;
import nextflow.file.Globs;
import nextflow.util.CacheHelper;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHelper
implements GroovyObject {
    private static final Path localTempBasePath;
    private static final Pattern GLOB_CURLY_BRACKETS;
    private static final Pattern GLOB_SQUARE_BRACKETS;
    private static Random rndGen;
    private static final char[] ALPHA;
    static final Map<String, FileSystemProvider> providersMap;
    private static Lock _fs_lock;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static final Closure memoizedMethodClosure$envForString;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1428745933459;
    private static /* synthetic */ SoftReference $callSiteArray;

    public FileHelper() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    static {
        Closure closure;
        Logger logger;
        Map map;
        Random random;
        Pattern pattern;
        Pattern pattern2;
        FileHelper.__$swapInit();
        Long l = 0L;
        __timeStamp__239_neverHappen1428745933459 = l;
        Long l2 = 1428745933459L;
        __timeStamp = l2;
        GLOB_CURLY_BRACKETS = pattern2 = Pattern.compile("(.*)(\\{.+,.+\\})(.*)");
        GLOB_SQUARE_BRACKETS = pattern = Pattern.compile("(.*)(\\[.+\\])(.*)");
        rndGen = random = new Random();
        char[] cArray = (char[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createRange((Object)"a", (Object)"z", (boolean)true), char[].class);
        ALPHA = cArray;
        providersMap = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        ReentrantLock reentrantLock = new ReentrantLock();
        _fs_lock = reentrantLock;
        log = logger = LoggerFactory.getLogger((String)"nextflow.file.FileHelper");
        memoizedMethodClosure$envForString = closure = new GeneratedClosure(FileHelper.class, FileHelper.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(String scheme) {
                return FileHelper.memoizedMethodPriv$envForString(scheme);
            }

            public Object call(String scheme) {
                return this.doCall(scheme);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                __clinit__closure1.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(__clinit__closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = __clinit__closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }.memoize();
        String temp = System.getenv("NXF_TEMP");
        if (DefaultTypeTransformation.booleanUnbox((Object)temp)) {
            Object v0;
            Path path;
            localTempBasePath = path = Paths.get(temp, new String[0]);
            if (DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.invokeMethod0(FileHelper.class, (Object)log, (String)"isDebugEnabled"))) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{localTempBasePath}, new String[]{"Using NXF_TEMP=", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            if (!Files.exists(localTempBasePath, new LinkOption[0])) {
                Files.createDirectories(localTempBasePath, new FileAttribute[0]);
            }
        }
    }

    public static String normalizePath(String path) {
        if (ScriptBytecodeAdapter.compareEqual((Object)path, (Object)"~")) {
            Object object = DefaultGroovyMethods.getAt((Map)System.getProperties(), (Object)"user.home");
            path = ShortTypeHandling.castToString((Object)object);
        } else if (path.startsWith("~/")) {
            String string;
            path = string = StringGroovyMethods.plus((String)DefaultGroovyMethods.toString((Object)DefaultGroovyMethods.getAt((Map)System.getProperties(), (Object)"user.home")), (CharSequence)StringGroovyMethods.getAt((String)path, (IntRange)new IntRange(true, 1, Integer.valueOf(-1).intValue())));
        }
        return path;
    }

    public static String randomString(int len, char ... alphabet) {
        Reference alphabet2 = new Reference((Object)alphabet);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            char[] cArray = (char[])alphabet2.get();
            valueRecorder.record((Object)cArray, 8);
            int n = DefaultGroovyMethods.size((char[])cArray);
            valueRecorder.record((Object)n, 17);
            boolean bl = n > 0;
            valueRecorder.record((Object)bl, 24);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert alphabet.size() > 0", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        Reference result = new Reference((Object)new StringBuilder());
        Reference max = new Reference((Object)DefaultGroovyMethods.size((char[])((char[])alphabet2.get())));
        DefaultGroovyMethods.times((Number)len, (Closure)new GeneratedClosure(FileHelper.class, FileHelper.class, result, max, alphabet2){
            private /* synthetic */ Reference result;
            private /* synthetic */ Reference max;
            private /* synthetic */ Reference alphabet;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.result = reference3 = result;
                this.max = reference2 = max;
                this.alphabet = reference = alphabet;
            }

            public Object doCall(Object it) {
                int index = ((Random)this.getProperty("rndGen")).nextInt(DefaultTypeTransformation.intUnbox((Object)this.max.get()));
                return ((StringBuilder)this.result.get()).append(BytecodeInterface8.cArrayGet((char[])((char[])ScriptBytecodeAdapter.castToType((Object)this.alphabet.get(), char[].class)), (int)index));
            }

            public StringBuilder getResult() {
                return (StringBuilder)ScriptBytecodeAdapter.castToType((Object)this.result.get(), StringBuilder.class);
            }

            public Object getMax() {
                return this.max.get();
            }

            public char[] getAlphabet() {
                return (char[])ScriptBytecodeAdapter.castToType((Object)this.alphabet.get(), char[].class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _randomString_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _randomString_closure2.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_randomString_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _randomString_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        return ((StringBuilder)result.get()).toString();
    }

    public static String randomString(int len) {
        return FileHelper.randomString(len, ALPHA);
    }

    public static List nameParts(String name) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = name;
            valueRecorder.record((Object)string, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)string)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert name", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        if (StringGroovyMethods.isLong((String)name)) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[]{"", StringGroovyMethods.toLong((String)name)});
        }
        Matcher matcher = (Matcher)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.findRegex((Object)name, (Object)"^(\\S*)?(\\D)(\\d+)$"), Matcher.class);
        if (matcher.matches()) {
            Object[] entries = (String[])ScriptBytecodeAdapter.castToType((Object)StringGroovyMethods.getAt((Matcher)matcher, (int)0), String[].class);
            return ScriptBytecodeAdapter.createList((Object[])new Object[]{StringGroovyMethods.plus((String)ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])entries, (int)1)), (CharSequence)((CharSequence)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])entries, (int)2), CharSequence.class))), StringGroovyMethods.toInteger((String)((String)BytecodeInterface8.objectArrayGet((Object[])entries, (int)3)).toString())});
        }
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{name, 0});
    }

    public static boolean empty(File file) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            File file2 = file;
            valueRecorder.record((Object)file2, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)file2)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert file", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        return FileHelper.empty(file.toPath());
    }

    public static boolean empty(Path path) {
        BasicFileAttributes attrs;
        block9: {
            attrs = null;
            try {
                BasicFileAttributes basicFileAttributes;
                attrs = basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException e) {
                boolean bl = true;
                return bl;
            }
            if (!attrs.isDirectory()) break block9;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                Iterator<Path> itr = stream.iterator();
                boolean bl = !itr.hasNext();
                return bl;
            }
        }
        return attrs.size() == (long)0;
    }

    public static final Path getWorkFolder(Path bashPath, HashCode hash) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Path path = bashPath;
            valueRecorder.record((Object)path, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)path)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert bashPath", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            HashCode hashCode = hash;
            valueRecorder2.record((Object)hashCode, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)hashCode)) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert hash", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        String str = hash.toString();
        String bucket = str.substring(0, 2);
        Path folder = bashPath.resolve(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{bucket, str.substring(2)}, new String[]{"", "/", ""})));
        return folder.toAbsolutePath();
    }

    public static final Path createTempFolder(Path basePath) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Path path = basePath;
            valueRecorder.record((Object)path, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)path)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert basePath", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        int count = 0;
        while (true) {
            String hash = CacheHelper.hasher(rndGen.nextLong()).hash().toString();
            String bucket = hash.substring(0, 2);
            Path result = basePath.resolve(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{bucket, hash.substring(2)}, new String[]{"tmp/", "/", ""})));
            if (FilesEx.exists(result, new LinkOption[0])) {
                if (!(++count > 100)) continue;
                throw (Throwable)new IOException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{result}, new String[]{"Unable to create a unique temporary path: ", ""})));
            }
            if (!FilesEx.mkdirs(result, new FileAttribute[0])) {
                throw (Throwable)new IOException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{result}, new String[]{"Unable to create temporary parth: ", " -- Verify file system access permission"})));
            }
            return result.toAbsolutePath();
        }
        return (Path)ScriptBytecodeAdapter.castToType(null, Path.class);
    }

    public static final Path createLocalDir(String prefix) {
        if (DefaultTypeTransformation.booleanUnbox((Object)localTempBasePath)) {
            return Files.createTempDirectory(localTempBasePath, prefix, new FileAttribute[0]);
        }
        return Files.createTempDirectory(prefix, new FileAttribute[0]);
    }

    public static Path asPath(String str) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = str;
            valueRecorder.record((Object)string, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)string)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert str", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        int p = str.indexOf("://");
        if (ScriptBytecodeAdapter.compareEqual((Object)p, (Object)-1)) {
            return FileSystems.getDefault().getPath(str, new String[0]);
        }
        if (str.startsWith("s3://") && ScriptBytecodeAdapter.compareNotEqual((Object)StringGroovyMethods.getAt((String)str, (int)5), (Object)"/")) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{str.substring(5)}, new String[]{"s3:///", ""});
            str = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        URI uri = URI.create(str);
        if (ScriptBytecodeAdapter.compareEqual((Object)uri.getScheme(), (Object)"file")) {
            return FileSystems.getDefault().getPath(uri.getPath(), new String[0]);
        }
        return FileHelper.getOrCreateFileSystemFor(uri).provider().getPath(uri);
    }

    public static FileSystem getWorkFileSystem() {
        ISession iSession = Global.getSession();
        Path path = iSession != null ? iSession.getWorkDir() : null;
        FileSystem result = path != null ? path.getFileSystem() : null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)result)) {
            FileSystem fileSystem;
            log.warn("Session working file system not defined -- fallback on JVM default file system");
            result = fileSystem = FileSystems.getDefault();
        }
        return result;
    }

    protected static Map envFor(String scheme) {
        return (Map)ScriptBytecodeAdapter.castToType((Object)memoizedMethodClosure$envForString.call((Object)scheme), Map.class);
    }

    static Map envFor0(String scheme, Map env) {
        LinkedHashMap result = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
        String string = scheme;
        if (ScriptBytecodeAdapter.compareEqual((Object)(string != null ? string.toLowerCase() : null), (Object)"s3")) {
            List<String> credentials = Global.getAwsCredentials(env);
            if (DefaultTypeTransformation.booleanUnbox(credentials)) {
                Object object = DefaultGroovyMethods.getAt(credentials, (int)0);
                ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)result, (String)"access_key");
                Object object2 = DefaultGroovyMethods.getAt(credentials, (int)1);
                ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)result, (String)"secret_key");
            }
            Map<String, ?> config = Global.getAwsClientConfig();
            if (DefaultTypeTransformation.booleanUnbox(config)) {
                result.putAll(config);
            }
        } else {
            if (!DefaultTypeTransformation.booleanUnbox((Object)Global.getSession())) {
                ScriptBytecodeAdapter.assertFailed((Object)"nextflow.Global.session", (Object)"Session is not available -- make sure to call this after Session object has been created");
            }
            ISession iSession = Global.getSession();
            ScriptBytecodeAdapter.setProperty((Object)iSession, null, (Object)result, (String)"session");
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FileSystemProvider getProviderFor(String scheme) {
        if (providersMap.containsKey(scheme)) {
            return (FileSystemProvider)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(providersMap, (Object)scheme), FileSystemProvider.class);
        }
        Map<String, FileSystemProvider> map = providersMap;
        synchronized (map) {
            if (providersMap.containsKey(scheme)) {
                return (FileSystemProvider)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(providersMap, (Object)scheme), FileSystemProvider.class);
            }
            {
                FileSystemProvider provider = null;
                Iterator<FileSystemProvider> iterator = FileSystemProvider.installedProviders().iterator();
                do {
                    if (!iterator.hasNext()) return (FileSystemProvider)ScriptBytecodeAdapter.castToType(null, FileSystemProvider.class);
                } while (!ScriptBytecodeAdapter.compareEqual((Object)scheme, (Object)(provider = (FileSystemProvider)ScriptBytecodeAdapter.castToType((Object)iterator.next(), FileSystemProvider.class)).getScheme()));
                FileSystemProvider fileSystemProvider = provider;
                DefaultGroovyMethods.putAt(providersMap, (Object)scheme, (Object)fileSystemProvider);
                return fileSystemProvider;
            }
        }
    }

    @Deprecated
    public static synchronized <T extends FileSystemProvider> T getOrInstallProvider(Class<T> clazz) {
        Object v0;
        FileSystemProvider fileSystemProvider;
        Reference clazz2 = new Reference(clazz);
        FileSystemProvider result = (FileSystemProvider)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.find(FileSystemProvider.installedProviders(), (Closure)new GeneratedClosure(FileHelper.class, FileHelper.class, clazz2){
            private /* synthetic */ Reference clazz;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                this.clazz = reference = clazz;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual(it.getClass(), (Object)this.clazz.get());
            }

            public Class getClazz() {
                return ShortTypeHandling.castToClass((Object)this.clazz.get());
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getOrInstallProvider_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _getOrInstallProvider_closure3.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_getOrInstallProvider_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getOrInstallProvider_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }), FileSystemProvider.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)result)) {
            return (T)result;
        }
        result = fileSystemProvider = (FileSystemProvider)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.newInstance((Class)((Class)clazz2.get())), FileSystemProvider.class);
        Field field = FileSystemProvider.class.getDeclaredField("installedProviders");
        ((AccessibleObject)field).setAccessible(true);
        ArrayList<FileSystemProvider> installedProviders = new ArrayList<FileSystemProvider>((List)ScriptBytecodeAdapter.castToType((Object)field.get(null), List.class));
        installedProviders.add(result);
        field.set(FileHelper.class, Collections.unmodifiableList(installedProviders));
        if (DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.invokeMethod0(FileHelper.class, (Object)log, (String)"isDebugEnabled"))) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((Class)clazz2.get()).getSimpleName(), result.getScheme()}, new String[]{"> Added '", "' to list of installed providers [", "]"})));
            v0 = null;
        } else {
            v0 = null;
        }
        return (T)result;
    }

    /*
     * WARNING - void declaration
     */
    public static FileSystem getOrCreateFileSystemFor(URI uri, Map env) {
        void var1_1;
        Reference uri2 = new Reference((Object)uri);
        Reference env2 = new Reference((Object)var1_1);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            URI uRI = (URI)uri2.get();
            valueRecorder.record((Object)uRI, 8);
            if (uRI != null) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert uri", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        Reference provider = new Reference((Object)FileHelper.getProviderFor(((URI)uri2.get()).getScheme()));
        if (!DefaultTypeTransformation.booleanUnbox((Object)((FileSystemProvider)provider.get()))) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((URI)uri2.get()).getScheme()}, new String[]{"Cannot a find a file system provider for scheme: ", ""})));
        }
        Reference fs = new Reference(null);
        FileSystem cfr_ignored_0 = (FileSystem)fs.get();
        try {
            FileSystem fileSystem = ((FileSystemProvider)provider.get()).getFileSystem((URI)uri2.get());
            fs.set((Object)fileSystem);
        }
        catch (FileSystemNotFoundException e) {
            Object var9_9 = null;
            fs.set((Object)((FileSystem)ScriptBytecodeAdapter.castToType(var9_9, FileSystem.class)));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)((FileSystem)fs.get()))) {
            return (FileSystem)fs.get();
        }
        Bolts.withLock(_fs_lock, new GeneratedClosure(FileHelper.class, FileHelper.class, fs, provider, env2, uri2){
            private /* synthetic */ Reference fs;
            private /* synthetic */ Reference provider;
            private /* synthetic */ Reference env;
            private /* synthetic */ Reference uri;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.fs = reference4 = fs;
                this.provider = reference3 = provider;
                this.env = reference2 = env;
                this.uri = reference = uri;
            }

            public Object doCall(Object it) {
                try {
                    FileSystem fileSystem = ((FileSystemProvider)this.provider.get()).getFileSystem((URI)ScriptBytecodeAdapter.castToType((Object)this.uri.get(), URI.class));
                    this.fs.set((Object)fileSystem);
                }
                catch (FileSystemNotFoundException e) {
                    Object var4_4 = null;
                    this.fs.set((Object)((FileSystem)ScriptBytecodeAdapter.castToType(var4_4, FileSystem.class)));
                }
                if (!DefaultTypeTransformation.booleanUnbox((Object)this.fs.get())) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.provider.get().getClass().getSimpleName()}, new String[]{"Creating a file system instance for provider: ", ""})));
                    Object object = this.env.get();
                    Map map = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
                    FileSystem fileSystem = ((FileSystemProvider)this.provider.get()).newFileSystem((URI)ScriptBytecodeAdapter.castToType((Object)this.uri.get(), URI.class), DefaultTypeTransformation.booleanUnbox((Object)object) ? map : (Map)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeStaticMethod(FileHelper.class, (String)"envFor", (Object)new Object[]{((URI)this.uri.get()).getScheme()}), Map.class));
                    this.fs.set((Object)fileSystem);
                }
                return this.fs.get();
            }

            public FileSystem getFs() {
                return (FileSystem)ScriptBytecodeAdapter.castToType((Object)this.fs.get(), FileSystem.class);
            }

            public Object getProvider() {
                return this.provider.get();
            }

            public Map getEnv() {
                return (Map)ScriptBytecodeAdapter.castToType((Object)this.env.get(), Map.class);
            }

            public URI getUri() {
                return (URI)ScriptBytecodeAdapter.castToType((Object)this.uri.get(), URI.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getOrCreateFileSystemFor_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _getOrCreateFileSystemFor_closure4.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_getOrCreateFileSystemFor_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getOrCreateFileSystemFor_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        return (FileSystem)fs.get();
    }

    public static FileSystem getOrCreateFileSystemFor(String scheme, Map env) {
        return FileHelper.getOrCreateFileSystemFor(URI.create(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{scheme}, new String[]{"", ":///"}))), env);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Path getLocalCachePath(Path sourcePath, Path cacheDir, UUID sessionId) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Path path = sourcePath;
            valueRecorder.record((Object)path, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)path)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert sourcePath", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            Path path = cacheDir;
            valueRecorder2.record((Object)path, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)path)) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert cacheDir", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        Path key = sessionId != null ? ScriptBytecodeAdapter.createList((Object[])new Object[]{sessionId, sourcePath}) : sourcePath;
        HashCode hash = CacheHelper.hasher(key).hash();
        Path cached = FileHelper.getWorkFolder(cacheDir, hash).resolve(sourcePath.getFileName().toString());
        if (Files.exists(cached, new LinkOption[0])) {
            return cached;
        }
        Path path = cacheDir;
        synchronized (path) {
            if (!Files.exists(cached, new LinkOption[0])) return FilesEx.copyTo(sourcePath, cached);
            return cached;
        }
    }

    public static Object isGlobPattern(String filePattern) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = filePattern;
            valueRecorder.record((Object)string, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)string)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert filePattern", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        boolean glob = false;
        Boolean bl = DefaultGroovyMethods.or((Boolean)glob, (Boolean)StringGroovyMethods.contains((String)filePattern, (String)"*"));
        glob = DefaultTypeTransformation.booleanUnbox((Object)bl);
        Boolean bl2 = DefaultGroovyMethods.or((Boolean)glob, (Boolean)StringGroovyMethods.contains((String)filePattern, (String)"?"));
        glob = DefaultTypeTransformation.booleanUnbox((Object)bl2);
        Boolean bl3 = DefaultGroovyMethods.or((Boolean)glob, (Boolean)GLOB_SQUARE_BRACKETS.matcher(filePattern).matches());
        glob = DefaultTypeTransformation.booleanUnbox((Object)bl3);
        return glob || GLOB_CURLY_BRACKETS.matcher(filePattern).matches();
    }

    public static PathMatcher getDefaultPathMatcher(String syntaxAndInput) {
        int pos = syntaxAndInput.indexOf(":");
        if (pos <= 0 || pos == syntaxAndInput.length()) {
            throw (Throwable)new IllegalArgumentException();
        }
        String syntax = syntaxAndInput.substring(0, pos);
        String input = syntaxAndInput.substring(pos + 1);
        String expr = null;
        if (ScriptBytecodeAdapter.compareEqual((Object)syntax, (Object)"glob")) {
            String string;
            expr = string = Globs.toUnixRegexPattern(input);
        } else if (ScriptBytecodeAdapter.compareEqual((Object)syntax, (Object)"regex")) {
            String string;
            expr = string = input;
        } else {
            throw (Throwable)new UnsupportedOperationException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{syntax}, new String[]{"Syntax '", "' not recognized"})));
        }
        Reference pattern = new Reference((Object)Pattern.compile(expr));
        return new PathMatcher(FileHelper.class, pattern){
            public /* synthetic */ Reference pattern;
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                Reference reference;
                Class clazz;
                this.this$0 = clazz = p0;
                this.pattern = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public boolean matches(Path path) {
                return ((Pattern)this.pattern.get()).matcher(path.toString()).matches();
            }

            public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(1.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$1(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, 1.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object this$dist$get$1(String name) {
                return ScriptBytecodeAdapter.getGroovyObjectProperty(1.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                1.__$swapInit();
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        };
    }

    public static PathMatcher getPathMatcherFor(String syntaxAndPattern, FileSystem fileSystem) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            FileSystem fileSystem2 = fileSystem;
            valueRecorder.record((Object)fileSystem2, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)fileSystem2)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert fileSystem", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            String string = syntaxAndPattern;
            valueRecorder2.record((Object)string, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)string)) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert syntaxAndPattern", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        PathMatcher matcher = null;
        try {
            PathMatcher pathMatcher;
            matcher = pathMatcher = fileSystem.getPathMatcher(syntaxAndPattern);
        }
        catch (UnsupportedOperationException e) {
            Object var7_7 = null;
            matcher = (PathMatcher)ScriptBytecodeAdapter.castToType(var7_7, PathMatcher.class);
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)matcher)) {
            PathMatcher pathMatcher;
            Object v4;
            if (DefaultTypeTransformation.booleanUnbox((Object)ScriptBytecodeAdapter.invokeMethod0(FileHelper.class, (Object)log, (String)"isDebugEnabled"))) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{fileSystem.getClass().getSimpleName()}, new String[]{"Path matcher not defined by '", "' file system -- using default default strategy"})));
                v4 = null;
            } else {
                v4 = null;
            }
            matcher = pathMatcher = FileHelper.getDefaultPathMatcher(syntaxAndPattern);
        }
        return matcher;
    }

    /*
     * WARNING - void declaration
     */
    public static void visitFiles(Map options, Path folder, String filePattern, Closure action) {
        void var3_3;
        Reference folder2 = new Reference((Object)folder);
        Reference action2 = new Reference((Object)var3_3);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Path path = (Path)folder2.get();
            valueRecorder.record((Object)path, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)path)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert folder", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            String string = filePattern;
            valueRecorder2.record((Object)string, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)string)) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert filePattern", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder3 = new ValueRecorder();
        try {
            Closure closure = (Closure)action2.get();
            valueRecorder3.record((Object)closure, 8);
            if (DefaultTypeTransformation.booleanUnbox((Object)closure)) {
                valueRecorder3.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert action", (ValueRecorder)valueRecorder3), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder3.clear();
            throw throwable;
        }
        String string = options == null ? null : (String)options.get("type");
        String type = DefaultTypeTransformation.booleanUnbox(string) ? string : "any";
        EnumSet<FileVisitOption> walkOptions = ScriptBytecodeAdapter.compareEqual(options == null ? null : options.get("followLinks"), (Object)false) ? EnumSet.noneOf(FileVisitOption.class) : EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Reference maxDepth = new Reference((Object)FileHelper.getMaxDepth(options == null ? null : options.get("maxDepth"), filePattern));
        Boolean bl = (Boolean)ScriptBytecodeAdapter.asType(options == null ? null : options.get("hidden"), Boolean.class);
        Reference includeHidden = new Reference((Object)(DefaultTypeTransformation.booleanUnbox((Object)bl) ? bl : Boolean.valueOf(filePattern.startsWith("."))));
        Reference includeDir = new Reference((Object)((Boolean)ScriptBytecodeAdapter.castToType((Object)(ScriptBytecodeAdapter.createList((Object[])new Object[]{"dir", "any"}) == null ? Boolean.valueOf(type == null) : Boolean.valueOf(DefaultGroovyMethods.isCase((Collection)ScriptBytecodeAdapter.createList((Object[])new Object[]{"dir", "any"}), (Object)type))), Boolean.class)));
        Reference includeFile = new Reference((Object)((Boolean)ScriptBytecodeAdapter.castToType((Object)(ScriptBytecodeAdapter.createList((Object[])new Object[]{"file", "any"}) == null ? Boolean.valueOf(type == null) : Boolean.valueOf(DefaultGroovyMethods.isCase((Collection)ScriptBytecodeAdapter.createList((Object[])new Object[]{"file", "any"}), (Object)type))), Boolean.class)));
        String string2 = options == null ? null : (String)options.get("syntax");
        String syntax = DefaultTypeTransformation.booleanUnbox(string2) ? string2 : "glob";
        Reference relative = new Reference((Object)ScriptBytecodeAdapter.compareEqual(options == null ? null : options.get("relative"), (Object)true));
        Reference matcher = new Reference((Object)FileHelper.getPathMatcherFor(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{syntax, ((Path)folder2.get()).resolve(filePattern)}, new String[]{"", ":", ""})), ((Path)folder2.get()).getFileSystem()));
        Reference singleParam = new Reference((Object)(((Closure)action2.get()).getMaximumNumberOfParameters() == 1 ? 1 : 0));
        Files.walkFileTree((Path)folder2.get(), walkOptions, Integer.MAX_VALUE, (FileVisitor<? super Path>)new GroovyObject(FileHelper.class, folder2, maxDepth, matcher, includeHidden, action2, includeDir, relative, includeFile, singleParam){
            public /* synthetic */ Reference singleParam;
            public /* synthetic */ Reference includeFile;
            public /* synthetic */ Reference relative;
            public /* synthetic */ Reference includeDir;
            public /* synthetic */ Reference action;
            public /* synthetic */ Reference includeHidden;
            public /* synthetic */ Reference matcher;
            public /* synthetic */ Reference maxDepth;
            public /* synthetic */ Reference folder;
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                Reference reference7;
                Reference reference8;
                Reference reference9;
                Class clazz;
                this.this$0 = clazz = p0;
                this.singleParam = reference9 = p9;
                this.includeFile = reference8 = p8;
                this.relative = reference7 = p7;
                this.includeDir = reference6 = p6;
                this.action = reference5 = p5;
                this.includeHidden = reference4 = p4;
                this.matcher = reference3 = p3;
                this.maxDepth = reference2 = p2;
                this.folder = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                int depth = path.getNameCount() - ((Path)this.folder.get()).getNameCount();
                if (log.isTraceEnabled()) {
                    log.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{depth, path, this.includeDir.get(), ((PathMatcher)this.matcher.get()).matches(path), attrs.isDirectory()}, new String[]{"visit dir (", ") > ", "; includeDir: ", "; matches: ", "; isDir: ", ""})));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)this.includeDir.get()) && ((PathMatcher)this.matcher.get()).matches(path) && attrs.isDirectory() && (DefaultTypeTransformation.booleanUnbox((Object)this.includeHidden.get()) || !FileHelper.isHidden(path))) {
                    Object object = this.relative.get();
                    Path result = (object == null ? false : (Boolean)object) ? ((Path)this.folder.get()).relativize(path) : path;
                    Object object2 = this.singleParam.get();
                    Object object3 = (object2 == null ? false : (Boolean)object2) ? ((Closure)this.action.get()).call((Object)result) : ((Closure)ScriptBytecodeAdapter.castToType((Object)this.action.get(), Closure.class)).call(new Object[]{result, attrs});
                }
                return ScriptBytecodeAdapter.compareGreaterThan((Object)depth, (Object)this.maxDepth.get()) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                if (log.isTraceEnabled()) {
                    log.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{path, this.includeFile.get(), ((PathMatcher)this.matcher.get()).matches(path), attrs.isRegularFile()}, new String[]{"visit file > ", "; includeFile: ", "; matches: ", "; isRegularFile: ", ""})));
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)this.includeFile.get()) && ((PathMatcher)this.matcher.get()).matches(path) && attrs.isRegularFile() && (DefaultTypeTransformation.booleanUnbox((Object)this.includeHidden.get()) || !FileHelper.isHidden(path))) {
                    Object object = this.relative.get();
                    Path result = (object == null ? false : (Boolean)object) ? ((Path)this.folder.get()).relativize(path) : path;
                    Object object2 = this.singleParam.get();
                    Object object3 = (object2 == null ? false : (Boolean)object2) ? ((Closure)this.action.get()).call((Object)result) : ((Closure)ScriptBytecodeAdapter.castToType((Object)this.action.get(), Closure.class)).call(new Object[]{result, attrs});
                }
                return FileVisitResult.CONTINUE;
            }

            public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(2.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void this$dist$set$2(String name, Object value) {
                Object object = value;
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, 2.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object this$dist$get$2(String name) {
                return ScriptBytecodeAdapter.getGroovyObjectProperty(2.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(2.class, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(2.class, FileHelper.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                2.__$swapInit();
            }

            public /* synthetic */ void super$1$wait() {
                super.wait();
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            public /* synthetic */ FileVisitResult super$2$postVisitDirectory(Object object, IOException iOException) {
                return super.postVisitDirectory(object, iOException);
            }

            public /* synthetic */ void super$1$wait(long l, int n) {
                super.wait(l, n);
            }

            public /* synthetic */ FileVisitResult super$2$preVisitDirectory(Object object, BasicFileAttributes basicFileAttributes) {
                return super.preVisitDirectory(object, basicFileAttributes);
            }

            public /* synthetic */ void super$1$notify() {
                super.notify();
            }

            public /* synthetic */ Class super$1$getClass() {
                return super.getClass();
            }

            public /* synthetic */ void super$1$notifyAll() {
                super.notifyAll();
            }

            public /* synthetic */ void super$1$finalize() {
                super.finalize();
            }

            public /* synthetic */ void super$1$wait(long l) {
                super.wait(l);
            }

            public /* synthetic */ FileVisitResult super$2$visitFileFailed(Object object, IOException iOException) {
                return super.visitFileFailed(object, iOException);
            }

            public /* synthetic */ boolean super$1$equals(Object object) {
                return super.equals(object);
            }

            public /* synthetic */ Object super$1$clone() {
                return super.clone();
            }

            public /* synthetic */ FileVisitResult super$2$visitFile(Object object, BasicFileAttributes basicFileAttributes) {
                return super.visitFile(object, basicFileAttributes);
            }

            public /* synthetic */ int super$1$hashCode() {
                return super.hashCode();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    private static boolean isHidden(Path path) {
        String string;
        Path fileName = path.getFileName();
        return DefaultTypeTransformation.booleanUnbox(DefaultTypeTransformation.booleanUnbox((Object)fileName) ? ((string = fileName.toString()) != null ? Boolean.valueOf(string.startsWith(".")) : null) : null);
    }

    static int getMaxDepth(Object value, String filePattern) {
        if (value != null) {
            return DefaultTypeTransformation.intUnbox((Object)ScriptBytecodeAdapter.asType((Object)value, Integer.TYPE));
        }
        String string = filePattern;
        Boolean bl = string != null ? Boolean.valueOf(StringGroovyMethods.contains((String)string, (String)"**")) : null;
        if (bl == null ? false : bl) {
            return Integer.MAX_VALUE;
        }
        String string2 = filePattern;
        Boolean bl2 = string2 != null ? Boolean.valueOf(StringGroovyMethods.contains((String)string2, (String)"/")) : null;
        if (bl2 == null ? false : bl2) {
            return DefaultGroovyMethods.findAll((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)filePattern.split("/"), Object[].class)), (Closure)new GeneratedClosure(FileHelper.class, FileHelper.class){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public Object doCall(Object it) {
                    return it;
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getMaxDepth_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _getMaxDepth_closure5.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_getMaxDepth_closure5.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getMaxDepth_closure5.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            }).size() - 1;
        }
        return 0;
    }

    public static List<String> getFolderAndPattern(String filePattern) {
        String scheme = null;
        int i = filePattern.indexOf("://");
        if (ScriptBytecodeAdapter.compareNotEqual((Object)i, (Object)-1)) {
            String string;
            String string2;
            scheme = string2 = filePattern.substring(0, i);
            filePattern = string = filePattern.substring(i + 3);
        }
        String folder = null;
        String pattern = null;
        Matcher matcher = null;
        int p = filePattern.indexOf("*");
        if (ScriptBytecodeAdapter.compareNotEqual((Object)p, (Object)-1)) {
            int n;
            i = n = filePattern.substring(0, p).lastIndexOf("/");
        } else {
            Matcher matcher2;
            matcher = matcher2 = FileHelper.getGLOB_CURLY_BRACKETS().matcher(filePattern);
            if (matcher2.matches()) {
                String prefix = matcher.group(1);
                if (DefaultTypeTransformation.booleanUnbox((Object)prefix)) {
                    Integer n = StringGroovyMethods.contains((String)prefix, (String)"/") ? Integer.valueOf(prefix.lastIndexOf("/")) : Integer.valueOf(-1);
                    i = n;
                } else {
                    int n;
                    i = n = matcher.start(2) - 1;
                }
            } else {
                int n;
                i = n = filePattern.lastIndexOf("/");
            }
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)i, (Object)-1)) {
            String string;
            String string3;
            folder = string3 = filePattern.substring(0, i + 1);
            pattern = string = filePattern.substring(i + 1);
        } else {
            String string;
            String string4;
            folder = string4 = "./";
            pattern = string = filePattern;
        }
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{folder, pattern, scheme});
    }

    public static FileSystem fileSystemForScheme(String scheme) {
        return !DefaultTypeTransformation.booleanUnbox((Object)scheme) ? FileSystems.getDefault() : FileHelper.getOrCreateFileSystemFor(scheme);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FileHelper.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    private static Map memoizedMethodPriv$envForString(String scheme) {
        return FileHelper.envFor0(scheme, System.getenv());
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(FileHelper.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, FileHelper.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(FileHelper.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ Random pfaccess$0(FileHelper $that) {
        return rndGen;
    }

    public static final Path createLocalDir() {
        return FileHelper.createLocalDir("nxf");
    }

    public static FileSystem getOrCreateFileSystemFor(URI uri) {
        Reference uri2 = new Reference((Object)uri);
        return FileHelper.getOrCreateFileSystemFor((URI)uri2.get(), null);
    }

    public static FileSystem getOrCreateFileSystemFor(String scheme) {
        return FileHelper.getOrCreateFileSystemFor(scheme, null);
    }

    public static Path getLocalCachePath(Path sourcePath, Path cacheDir) {
        return FileHelper.getLocalCachePath(sourcePath, cacheDir, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void visitFiles(Path folder, String filePattern, Closure action) {
        void var2_2;
        Reference folder2 = new Reference((Object)folder);
        Reference action2 = new Reference((Object)var2_2);
        FileHelper.visitFiles(null, (Path)folder2.get(), filePattern, (Closure)action2.get());
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
    }

    public static final Path getLocalTempBasePath() {
        return localTempBasePath;
    }

    public static final Pattern getGLOB_CURLY_BRACKETS() {
        return GLOB_CURLY_BRACKETS;
    }

    public static final Pattern getGLOB_SQUARE_BRACKETS() {
        return GLOB_SQUARE_BRACKETS;
    }

    public static final char[] getALPHA() {
        return ALPHA;
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(FileHelper.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = FileHelper.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

