/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelId;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.OpenSslSessionContext;
import io.netty.handler.ssl.OpenSslSessionTicketKey;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.ssl.SslCompletionEvent;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslHandshakeTimeoutException;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.ImmediateExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;

public class SslHandlerTest {
    private static final Executor DIRECT_EXECUTOR = new Executor(){

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testNonApplicationDataFailureFailsQueuedWrites() throws NoSuchAlgorithmException, InterruptedException {
        final CountDownLatch writeLatch = new CountDownLatch(1);
        final ConcurrentLinkedQueue writesToFail = new ConcurrentLinkedQueue();
        SSLEngine engine = SslHandlerTest.newClientModeSSLEngine();
        SslHandler handler = new SslHandler(engine){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                super.write(ctx, msg, promise);
                writeLatch.countDown();
            }
        };
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChannelDuplexHandler(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                if (msg instanceof ByteBuf) {
                    if (((ByteBuf)msg).isReadable()) {
                        writesToFail.add(promise);
                    } else {
                        promise.setSuccess();
                    }
                }
                ReferenceCountUtil.release((Object)msg);
            }
        }, handler});
        try {
            ChannelPromise promiseToFail;
            final CountDownLatch writeCauseLatch = new CountDownLatch(1);
            final AtomicReference failureRef = new AtomicReference();
            ch.write((Object)Unpooled.wrappedBuffer((byte[])new byte[]{1})).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    failureRef.compareAndSet(null, future.cause());
                    writeCauseLatch.countDown();
                }
            });
            writeLatch.await();
            while ((promiseToFail = (ChannelPromise)writesToFail.poll()) != null) {
                promiseToFail.setFailure((Throwable)new RuntimeException("fake exception"));
            }
            writeCauseLatch.await();
            Throwable writeCause = (Throwable)failureRef.get();
            Assertions.assertNotNull((Object)writeCause);
            MatcherAssert.assertThat((Object)writeCause, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SSLException.class)));
            Throwable cause = handler.handshakeFuture().cause();
            Assertions.assertNotNull((Object)cause);
            MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SSLException.class)));
        }
        finally {
            Assertions.assertFalse((boolean)ch.finishAndReleaseAll());
        }
    }

    @Test
    public void testNoSslHandshakeEventWhenNoHandshake() throws Exception {
        final AtomicBoolean inActive = new AtomicBoolean(false);
        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
        EmbeddedChannel ch = new EmbeddedChannel((ChannelId)DefaultChannelId.newInstance(), false, false, new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                ctx.close();
            }
        }, new SslHandler(engine){

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                inActive.set(true);
                super.handlerAdded(ctx);
                inActive.set(false);
            }
        }, new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                if (evt instanceof SslHandshakeCompletionEvent) {
                    throw (Exception)((SslHandshakeCompletionEvent)evt).cause();
                }
            }
        }}){

            public boolean isActive() {
                return !inActive.get() && super.isActive();
            }
        };
        ch.register();
        Assertions.assertFalse((boolean)ch.finishAndReleaseAll());
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testClientHandshakeTimeout() throws Exception {
        Assertions.assertThrows(SslHandshakeTimeoutException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslHandlerTest.testHandshakeTimeout(true);
            }
        });
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testServerHandshakeTimeout() throws Exception {
        Assertions.assertThrows(SslHandshakeTimeoutException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                SslHandlerTest.testHandshakeTimeout(false);
            }
        });
    }

    private static SSLEngine newServerModeSSLEngine() throws NoSuchAlgorithmException {
        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
        engine.setUseClientMode(false);
        return engine;
    }

    private static SSLEngine newClientModeSSLEngine() throws NoSuchAlgorithmException {
        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
        engine.setUseClientMode(true);
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testHandshakeTimeout(boolean client) throws Exception {
        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
        engine.setUseClientMode(client);
        SslHandler handler = new SslHandler(engine);
        handler.setHandshakeTimeoutMillis(1L);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{handler});
        try {
            while (!handler.handshakeFuture().isDone()) {
                Thread.sleep(10L);
                ch.runPendingTasks();
            }
            handler.handshakeFuture().syncUninterruptibly();
        }
        finally {
            ch.finishAndReleaseAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testHandshakeAndClosePromiseFailedOnRemoval() throws Exception {
        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
        engine.setUseClientMode(true);
        SslHandler handler = new SslHandler(engine);
        final AtomicReference handshakeRef = new AtomicReference();
        final AtomicReference closeRef = new AtomicReference();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{handler, new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                if (evt instanceof SslHandshakeCompletionEvent) {
                    handshakeRef.set(((SslHandshakeCompletionEvent)evt).cause());
                } else if (evt instanceof SslCloseCompletionEvent) {
                    closeRef.set(((SslCloseCompletionEvent)evt).cause());
                }
            }
        }});
        Assertions.assertFalse((boolean)handler.handshakeFuture().isDone());
        Assertions.assertFalse((boolean)handler.sslCloseFuture().isDone());
        ch.pipeline().remove((ChannelHandler)handler);
        try {
            while (!handler.handshakeFuture().isDone() || handshakeRef.get() == null || !handler.sslCloseFuture().isDone() || closeRef.get() == null) {
                Thread.sleep(10L);
                ch.runPendingTasks();
            }
            Assertions.assertSame((Object)handler.handshakeFuture().cause(), handshakeRef.get());
            Assertions.assertSame((Object)handler.sslCloseFuture().cause(), closeRef.get());
        }
        finally {
            ch.finishAndReleaseAll();
        }
    }

    @Test
    public void testTruncatedPacket() throws Exception {
        SSLEngine engine = SslHandlerTest.newServerModeSSLEngine();
        final EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new SslHandler(engine)});
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{22, 3, 1, 0, 5})});
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        DecoderException e = (DecoderException)Assertions.assertThrows(DecoderException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{2, 0, 0, 1, 0})});
            }
        });
        ch.finishAndReleaseAll();
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SSLProtocolException.class)));
    }

    @Test
    public void testNonByteBufWriteIsReleased() throws Exception {
        SSLEngine engine = SslHandlerTest.newServerModeSSLEngine();
        final EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new SslHandler(engine)});
        final AbstractReferenceCounted referenceCounted = new AbstractReferenceCounted(){

            public ReferenceCounted touch(Object hint) {
                return this;
            }

            protected void deallocate() {
            }
        };
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                ch.write((Object)referenceCounted).get();
            }
        });
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(UnsupportedMessageTypeException.class)));
        Assertions.assertEquals((int)0, (int)referenceCounted.refCnt());
        Assertions.assertTrue((boolean)ch.finishAndReleaseAll());
    }

    @Test
    public void testNonByteBufNotPassThrough() throws Exception {
        SSLEngine engine = SslHandlerTest.newServerModeSSLEngine();
        final EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new SslHandler(engine)});
        Assertions.assertThrows(UnsupportedMessageTypeException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                ch.writeOutbound(new Object[]{new Object()});
            }
        });
        ch.finishAndReleaseAll();
    }

    @Test
    public void testIncompleteWriteDoesNotCompletePromisePrematurely() throws NoSuchAlgorithmException {
        SSLEngine engine = SslHandlerTest.newServerModeSSLEngine();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new SslHandler(engine)});
        ChannelPromise promise = ch.newPromise();
        ByteBuf buf = Unpooled.buffer((int)10).writeZero(10);
        ch.writeAndFlush((Object)buf, promise);
        Assertions.assertFalse((boolean)promise.isDone());
        Assertions.assertTrue((boolean)ch.finishAndReleaseAll());
        Assertions.assertTrue((boolean)promise.isDone());
        MatcherAssert.assertThat((Object)promise.cause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SSLException.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReleaseSslEngine() throws Exception {
        OpenSsl.ensureAvailability();
        SelfSignedCertificate cert = new SelfSignedCertificate();
        try {
            SslContext sslContext = SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(SslProvider.OPENSSL).build();
            try {
                Assertions.assertEquals((int)1, (int)((ReferenceCounted)sslContext).refCnt());
                SSLEngine sslEngine = sslContext.newEngine(ByteBufAllocator.DEFAULT);
                EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new SslHandler(sslEngine)});
                Assertions.assertEquals((int)2, (int)((ReferenceCounted)sslContext).refCnt());
                Assertions.assertEquals((int)1, (int)((ReferenceCounted)sslEngine).refCnt());
                Assertions.assertTrue((boolean)ch.finishAndReleaseAll());
                ch.close().syncUninterruptibly();
                Assertions.assertEquals((int)1, (int)((ReferenceCounted)sslContext).refCnt());
                Assertions.assertEquals((int)0, (int)((ReferenceCounted)sslEngine).refCnt());
            }
            finally {
                ReferenceCountUtil.release((Object)sslContext);
            }
        }
        finally {
            cert.delete();
        }
    }

    @Test
    public void testIssueReadAfterActiveWriteFlush() throws Exception {
        new TlsReadTest().test(false);
    }

    @Test
    public void testIssueReadAfterWriteFlushActive() throws Exception {
        new TlsReadTest().test(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testRemoval() throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        try {
            Promise clientPromise = group.next().newPromise();
            Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler(SslHandlerTest.newHandler(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build(), (Promise<Void>)clientPromise));
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            Promise serverPromise = group.next().newPromise();
            ServerBootstrap serverBootstrap = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group, (EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler(SslHandlerTest.newHandler(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build(), (Promise<Void>)serverPromise));
            sc = serverBootstrap.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            cc = bootstrap.connect(sc.localAddress()).syncUninterruptibly().channel();
            serverPromise.syncUninterruptibly();
            clientPromise.syncUninterruptibly();
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
        }
    }

    private static ChannelHandler newHandler(final SslContext sslCtx, final Promise<Void> promise) {
        return new ChannelInitializer(){

            protected void initChannel(final Channel ch) {
                final SslHandler sslHandler = sslCtx.newHandler(ch.alloc());
                sslHandler.setHandshakeTimeoutMillis(1000L);
                ch.pipeline().addFirst(new ChannelHandler[]{sslHandler});
                sslHandler.handshakeFuture().addListener((GenericFutureListener)new FutureListener<Channel>(){

                    public void operationComplete(Future<Channel> future) {
                        ch.pipeline().remove((ChannelHandler)sslHandler);
                        ch.eventLoop().execute(new Runnable(){

                            @Override
                            public void run() {
                                ch.close();
                            }
                        });
                    }
                });
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                        if (cause instanceof CodecException) {
                            cause = cause.getCause();
                        }
                        if (cause instanceof IllegalReferenceCountException) {
                            promise.setFailure(cause);
                        }
                    }

                    public void channelInactive(ChannelHandlerContext ctx) {
                        promise.trySuccess(null);
                    }
                }});
            }
        };
    }

    @Test
    public void testCloseFutureNotified() throws Exception {
        SSLEngine engine = SslHandlerTest.newServerModeSSLEngine();
        SslHandler handler = new SslHandler(engine);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{handler});
        ch.close();
        ByteBuf buf = (ByteBuf)ch.readOutbound();
        Assertions.assertFalse((boolean)buf.isReadable());
        buf.release();
        Assertions.assertFalse((boolean)ch.finishAndReleaseAll());
        MatcherAssert.assertThat((Object)handler.handshakeFuture().cause(), (Matcher)CoreMatchers.instanceOf(ClosedChannelException.class));
        MatcherAssert.assertThat((Object)handler.sslCloseFuture().cause(), (Matcher)CoreMatchers.instanceOf(ClosedChannelException.class));
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testEventsFired() throws Exception {
        SSLEngine engine = SslHandlerTest.newServerModeSSLEngine();
        final LinkedBlockingQueue events = new LinkedBlockingQueue();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new SslHandler(engine), new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                if (evt instanceof SslCompletionEvent) {
                    events.add((SslCompletionEvent)evt);
                }
            }
        }});
        Assertions.assertTrue((boolean)events.isEmpty());
        Assertions.assertTrue((boolean)channel.finishAndReleaseAll());
        SslCompletionEvent evt = (SslCompletionEvent)events.take();
        Assertions.assertTrue((boolean)(evt instanceof SslHandshakeCompletionEvent));
        MatcherAssert.assertThat((Object)evt.cause(), (Matcher)CoreMatchers.instanceOf(ClosedChannelException.class));
        evt = (SslCompletionEvent)events.take();
        Assertions.assertTrue((boolean)(evt instanceof SslCloseCompletionEvent));
        MatcherAssert.assertThat((Object)evt.cause(), (Matcher)CoreMatchers.instanceOf(ClosedChannelException.class));
        Assertions.assertTrue((boolean)events.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testHandshakeFailBeforeWritePromise() throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        final SslContext sslServerCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
        final CountDownLatch latch = new CountDownLatch(2);
        final CountDownLatch latch2 = new CountDownLatch(2);
        final LinkedBlockingQueue events = new LinkedBlockingQueue();
        Channel serverChannel = null;
        Channel clientChannel = null;
        DefaultEventLoopGroup group = new DefaultEventLoopGroup();
        try {
            ServerBootstrap sb = new ServerBootstrap();
            ((ServerBootstrap)sb.group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{sslServerCtx.newHandler(ch.alloc())});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void channelActive(ChannelHandlerContext ctx) {
                            ByteBuf buf = ctx.alloc().buffer(10);
                            buf.writeZero(buf.capacity());
                            ctx.writeAndFlush((Object)buf).addListener((GenericFutureListener)new ChannelFutureListener(){

                                public void operationComplete(ChannelFuture future) {
                                    events.add(future);
                                    latch.countDown();
                                }
                            });
                        }

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                            if (evt instanceof SslCompletionEvent) {
                                events.add(evt);
                                latch.countDown();
                                latch2.countDown();
                            }
                        }
                    }});
                }
            });
            Bootstrap cb = new Bootstrap();
            ((Bootstrap)((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void channelActive(ChannelHandlerContext ctx) {
                            ByteBuf buf = ctx.alloc().buffer(1000);
                            buf.writeZero(buf.capacity());
                            ctx.writeAndFlush((Object)buf);
                        }
                    }});
                }
            });
            serverChannel = sb.bind((SocketAddress)new LocalAddress("SslHandlerTest")).sync().channel();
            clientChannel = cb.connect(serverChannel.localAddress()).sync().channel();
            latch.await();
            SslCompletionEvent evt = (SslCompletionEvent)events.take();
            Assertions.assertTrue((boolean)(evt instanceof SslHandshakeCompletionEvent));
            MatcherAssert.assertThat((Object)evt.cause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SSLException.class)));
            ChannelFuture future = (ChannelFuture)events.take();
            MatcherAssert.assertThat((Object)future.cause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SSLException.class)));
            serverChannel.close().sync();
            serverChannel = null;
            clientChannel.close().sync();
            clientChannel = null;
            latch2.await();
            evt = (SslCompletionEvent)events.take();
            Assertions.assertTrue((boolean)(evt instanceof SslCloseCompletionEvent));
            MatcherAssert.assertThat((Object)evt.cause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ClosedChannelException.class)));
            Assertions.assertTrue((boolean)events.isEmpty());
        }
        finally {
            if (serverChannel != null) {
                serverChannel.close();
            }
            if (clientChannel != null) {
                clientChannel.close();
            }
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void writingReadOnlyBufferDoesNotBreakAggregation() throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        final SslContext sslServerCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
        final SslContext sslClientCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        final CountDownLatch serverReceiveLatch = new CountDownLatch(1);
        try {
            int expectedBytes = 11;
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{sslServerCtx.newHandler(ch.alloc())});
                    ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<ByteBuf>(){
                        private int readBytes;

                        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
                            this.readBytes += msg.readableBytes();
                            if (this.readBytes >= 11) {
                                serverReceiveLatch.countDown();
                            }
                        }
                    }});
                }
            }).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            cc = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{sslClientCtx.newHandler(ch.alloc())});
                }
            })).connect(sc.localAddress()).syncUninterruptibly().channel();
            ByteBuf firstBuffer = Unpooled.buffer((int)10);
            firstBuffer.writeByte(0);
            firstBuffer = firstBuffer.asReadOnly();
            ByteBuf secondBuffer = Unpooled.buffer((int)10);
            secondBuffer.writeZero(secondBuffer.capacity());
            cc.write((Object)firstBuffer);
            cc.writeAndFlush((Object)secondBuffer).syncUninterruptibly();
            serverReceiveLatch.countDown();
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslServerCtx);
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testCloseOnHandshakeFailure() throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        final SslContext sslServerCtx = SslContextBuilder.forServer((PrivateKey)ssc.key(), (X509Certificate[])new X509Certificate[]{ssc.cert()}).build();
        final SslContext sslClientCtx = SslContextBuilder.forClient().trustManager(new X509Certificate[]{new SelfSignedCertificate().cert()}).build();
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        Channel sc = null;
        Channel cc = null;
        try {
            LocalAddress address = new LocalAddress(this.getClass().getSimpleName() + ".testCloseOnHandshakeFailure");
            ServerBootstrap sb = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{sslServerCtx.newHandler(ch.alloc())});
                }
            });
            sc = sb.bind((SocketAddress)address).syncUninterruptibly().channel();
            final AtomicReference sslHandlerRef = new AtomicReference();
            Bootstrap b = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(LocalChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    SslHandler handler = sslClientCtx.newHandler(ch.alloc());
                    sslHandlerRef.set(handler);
                    ch.pipeline().addLast(new ChannelHandler[]{handler});
                }
            });
            cc = b.connect(sc.localAddress()).syncUninterruptibly().channel();
            SslHandler handler = (SslHandler)sslHandlerRef.get();
            handler.handshakeFuture().awaitUninterruptibly();
            Assertions.assertFalse((boolean)handler.handshakeFuture().isSuccess());
            cc.closeFuture().syncUninterruptibly();
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslServerCtx);
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }

    @Test
    public void testOutboundClosedAfterChannelInactive() throws Exception {
        SslContext context = SslContextBuilder.forClient().build();
        SSLEngine engine = context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        EmbeddedChannel channel = new EmbeddedChannel();
        Assertions.assertFalse((boolean)channel.finish());
        channel.pipeline().addLast(new ChannelHandler[]{new SslHandler(engine)});
        Assertions.assertFalse((boolean)engine.isOutboundDone());
        channel.close().syncUninterruptibly();
        Assertions.assertTrue((boolean)engine.isOutboundDone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testHandshakeFailedByWriteBeforeChannelActive() throws Exception {
        SslContext sslClientCtx = SslContextBuilder.forClient().protocols(new String[]{"SSLv3"}).trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(SslProvider.JDK).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        final CountDownLatch activeLatch = new CountDownLatch(1);
        final AtomicReference errorRef = new AtomicReference();
        final SslHandler sslHandler = sslClientCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        try {
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter()).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            cc = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{sslHandler});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                            if (cause instanceof AssertionError) {
                                errorRef.set((AssertionError)((Object)cause));
                            }
                        }

                        public void channelActive(ChannelHandlerContext ctx) throws Exception {
                            activeLatch.countDown();
                        }
                    }});
                }
            })).connect(sc.localAddress()).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    future.channel().writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4}));
                }
            }).syncUninterruptibly().channel();
            activeLatch.await(5L, TimeUnit.SECONDS);
            AssertionError error = (AssertionError)errorRef.get();
            if (error != null) {
                throw error;
            }
            MatcherAssert.assertThat((Object)sslHandler.handshakeFuture().await().cause(), (Matcher)CoreMatchers.instanceOf(SSLException.class));
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testHandshakeTimeoutFlushStartsHandshake() throws Exception {
        SslHandlerTest.testHandshakeTimeout0(false);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testHandshakeTimeoutStartTLS() throws Exception {
        SslHandlerTest.testHandshakeTimeout0(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testHandshakeTimeout0(final boolean startTls) throws Exception {
        SslContext sslClientCtx = SslContextBuilder.forClient().startTls(true).trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(SslProvider.JDK).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        final SslHandler sslHandler = sslClientCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        sslHandler.setHandshakeTimeout(500L, TimeUnit.MILLISECONDS);
        try {
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter()).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            ChannelFuture future = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{sslHandler});
                    if (startTls) {
                        ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                                ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4}));
                            }
                        }});
                    }
                }
            })).connect(sc.localAddress());
            if (!startTls) {
                future.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        future.channel().writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4}));
                    }
                });
            }
            cc = future.syncUninterruptibly().channel();
            Throwable cause = sslHandler.handshakeFuture().await().cause();
            MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.instanceOf(SSLException.class));
            MatcherAssert.assertThat((Object)cause.getMessage(), (Matcher)CoreMatchers.containsString((String)"timed out"));
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }

    @Test
    public void testHandshakeWithExecutorThatExecuteDirectlyJDK() throws Throwable {
        SslHandlerTest.testHandshakeWithExecutor(DIRECT_EXECUTOR, SslProvider.JDK, false);
    }

    @Test
    public void testHandshakeWithImmediateExecutorJDK() throws Throwable {
        SslHandlerTest.testHandshakeWithExecutor((Executor)ImmediateExecutor.INSTANCE, SslProvider.JDK, false);
    }

    @Test
    public void testHandshakeWithImmediateEventExecutorJDK() throws Throwable {
        SslHandlerTest.testHandshakeWithExecutor((Executor)ImmediateEventExecutor.INSTANCE, SslProvider.JDK, false);
    }

    @Test
    public void testHandshakeWithExecutorJDK() throws Throwable {
        ExecutorService executorService = Executors.newCachedThreadPool();
        try {
            SslHandlerTest.testHandshakeWithExecutor(executorService, SslProvider.JDK, false);
        }
        finally {
            executorService.shutdown();
        }
    }

    @Test
    public void testHandshakeWithExecutorThatExecuteDirectlyOpenSsl() throws Throwable {
        OpenSsl.ensureAvailability();
        SslHandlerTest.testHandshakeWithExecutor(DIRECT_EXECUTOR, SslProvider.OPENSSL, false);
    }

    @Test
    public void testHandshakeWithImmediateExecutorOpenSsl() throws Throwable {
        OpenSsl.ensureAvailability();
        SslHandlerTest.testHandshakeWithExecutor((Executor)ImmediateExecutor.INSTANCE, SslProvider.OPENSSL, false);
    }

    @Test
    public void testHandshakeWithImmediateEventExecutorOpenSsl() throws Throwable {
        OpenSsl.ensureAvailability();
        SslHandlerTest.testHandshakeWithExecutor((Executor)ImmediateEventExecutor.INSTANCE, SslProvider.OPENSSL, false);
    }

    @Test
    public void testHandshakeWithExecutorOpenSsl() throws Throwable {
        OpenSsl.ensureAvailability();
        ExecutorService executorService = Executors.newCachedThreadPool();
        try {
            SslHandlerTest.testHandshakeWithExecutor(executorService, SslProvider.OPENSSL, false);
        }
        finally {
            executorService.shutdown();
        }
    }

    @Test
    public void testHandshakeMTLSWithExecutorThatExecuteDirectlyJDK() throws Throwable {
        SslHandlerTest.testHandshakeWithExecutor(DIRECT_EXECUTOR, SslProvider.JDK, true);
    }

    @Test
    public void testHandshakeMTLSWithImmediateExecutorJDK() throws Throwable {
        SslHandlerTest.testHandshakeWithExecutor((Executor)ImmediateExecutor.INSTANCE, SslProvider.JDK, true);
    }

    @Test
    public void testHandshakeMTLSWithImmediateEventExecutorJDK() throws Throwable {
        SslHandlerTest.testHandshakeWithExecutor((Executor)ImmediateEventExecutor.INSTANCE, SslProvider.JDK, true);
    }

    @Test
    public void testHandshakeMTLSWithExecutorJDK() throws Throwable {
        ExecutorService executorService = Executors.newCachedThreadPool();
        try {
            SslHandlerTest.testHandshakeWithExecutor(executorService, SslProvider.JDK, true);
        }
        finally {
            executorService.shutdown();
        }
    }

    @Test
    public void testHandshakeMTLSWithExecutorThatExecuteDirectlyOpenSsl() throws Throwable {
        OpenSsl.ensureAvailability();
        SslHandlerTest.testHandshakeWithExecutor(DIRECT_EXECUTOR, SslProvider.OPENSSL, true);
    }

    @Test
    public void testHandshakeMTLSWithImmediateExecutorOpenSsl() throws Throwable {
        OpenSsl.ensureAvailability();
        SslHandlerTest.testHandshakeWithExecutor((Executor)ImmediateExecutor.INSTANCE, SslProvider.OPENSSL, true);
    }

    @Test
    public void testHandshakeMTLSWithImmediateEventExecutorOpenSsl() throws Throwable {
        OpenSsl.ensureAvailability();
        SslHandlerTest.testHandshakeWithExecutor((Executor)ImmediateEventExecutor.INSTANCE, SslProvider.OPENSSL, true);
    }

    @Test
    public void testHandshakeMTLSWithExecutorOpenSsl() throws Throwable {
        OpenSsl.ensureAvailability();
        ExecutorService executorService = Executors.newCachedThreadPool();
        try {
            SslHandlerTest.testHandshakeWithExecutor(executorService, SslProvider.OPENSSL, true);
        }
        finally {
            executorService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testHandshakeWithExecutor(Executor executor, SslProvider provider, boolean mtls) throws Throwable {
        SslContext sslServerCtx;
        SslContext sslClientCtx;
        SelfSignedCertificate cert = new SelfSignedCertificate();
        if (mtls) {
            sslClientCtx = SslContextBuilder.forClient().protocols(new String[]{"TLSv1.2"}).trustManager(InsecureTrustManagerFactory.INSTANCE).keyManager(cert.key(), new X509Certificate[]{cert.cert()}).sslProvider(provider).build();
            sslServerCtx = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).protocols(new String[]{"TLSv1.2"}).trustManager(InsecureTrustManagerFactory.INSTANCE).clientAuth(ClientAuth.REQUIRE).sslProvider(provider).build();
        } else {
            sslClientCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(provider).build();
            sslServerCtx = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslProvider(provider).build();
        }
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        final SslHandler clientSslHandler = new SslHandler(sslClientCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT), executor);
        final SslHandler serverSslHandler = new SslHandler(sslServerCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT), executor);
        final AtomicReference causeRef = new AtomicReference();
        try {
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{serverSslHandler});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            causeRef.compareAndSet(null, cause);
                        }
                    }});
                }
            }).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            ChannelFuture future = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{clientSslHandler});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            causeRef.compareAndSet(null, cause);
                        }
                    }});
                }
            })).connect(sc.localAddress());
            cc = future.syncUninterruptibly().channel();
            Assertions.assertTrue((boolean)clientSslHandler.handshakeFuture().await().isSuccess());
            Assertions.assertTrue((boolean)serverSslHandler.handshakeFuture().await().isSuccess());
            Throwable cause = (Throwable)causeRef.get();
            if (cause != null) {
                throw cause;
            }
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }

    @Test
    public void testClientHandshakeTimeoutBecauseExecutorNotExecute() throws Exception {
        SslHandlerTest.testHandshakeTimeoutBecauseExecutorNotExecute(true);
    }

    @Test
    public void testServerHandshakeTimeoutBecauseExecutorNotExecute() throws Exception {
        SslHandlerTest.testHandshakeTimeoutBecauseExecutorNotExecute(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testHandshakeTimeoutBecauseExecutorNotExecute(final boolean client) throws Exception {
        SslContext sslClientCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(SslProvider.JDK).build();
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContext sslServerCtx = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslProvider(SslProvider.JDK).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        final SslHandler clientSslHandler = sslClientCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, new Executor(){

            @Override
            public void execute(Runnable command) {
                if (!client) {
                    command.run();
                }
            }
        });
        if (client) {
            clientSslHandler.setHandshakeTimeout(100L, TimeUnit.MILLISECONDS);
        }
        SslHandler serverSslHandler = sslServerCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, new Executor(){

            @Override
            public void execute(Runnable command) {
                if (client) {
                    command.run();
                }
            }
        });
        if (!client) {
            serverSslHandler.setHandshakeTimeout(100L, TimeUnit.MILLISECONDS);
        }
        try {
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)serverSslHandler).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            ChannelFuture future = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{clientSslHandler});
                }
            })).connect(sc.localAddress());
            cc = future.syncUninterruptibly().channel();
            if (client) {
                Throwable cause = clientSslHandler.handshakeFuture().await().cause();
                MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.instanceOf(SslHandshakeTimeoutException.class));
                Assertions.assertFalse((boolean)serverSslHandler.handshakeFuture().await().isSuccess());
            } else {
                Throwable cause = serverSslHandler.handshakeFuture().await().cause();
                MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.instanceOf(SslHandshakeTimeoutException.class));
                Assertions.assertFalse((boolean)clientSslHandler.handshakeFuture().await().isSuccess());
            }
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testSessionTicketsWithTLSv12() throws Throwable {
        SslHandlerTest.testSessionTickets(SslProvider.OPENSSL, "TLSv1.2", true);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testSessionTicketsWithTLSv13() throws Throwable {
        Assumptions.assumeTrue((boolean)SslProvider.isTlsv13Supported((SslProvider)SslProvider.OPENSSL));
        SslHandlerTest.testSessionTickets(SslProvider.OPENSSL, "TLSv1.3", true);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testSessionTicketsWithTLSv12AndNoKey() throws Throwable {
        SslHandlerTest.testSessionTickets(SslProvider.OPENSSL, "TLSv1.2", false);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testSessionTicketsWithTLSv13AndNoKey() throws Throwable {
        Assumptions.assumeTrue((boolean)OpenSsl.isTlsv13Supported());
        SslHandlerTest.testSessionTickets(SslProvider.OPENSSL, "TLSv1.3", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testSessionTickets(SslProvider provider, String protocol, boolean withKey) throws Throwable {
        OpenSsl.ensureAvailability();
        SslContext sslClientCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(provider).protocols(new String[]{protocol}).build();
        ((OpenSslContext)sslClientCtx).sessionContext().setSessionCacheEnabled(true);
        SelfSignedCertificate cert = new SelfSignedCertificate();
        final SslContext sslServerCtx = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslProvider(provider).protocols(new String[]{protocol}).build();
        if (withKey) {
            OpenSslSessionTicketKey key = new OpenSslSessionTicketKey(new byte[16], new byte[16], new byte[16]);
            ((OpenSslSessionContext)sslClientCtx.sessionContext()).setTicketKeys(new OpenSslSessionTicketKey[]{key});
            ((OpenSslSessionContext)sslServerCtx.sessionContext()).setTicketKeys(new OpenSslSessionTicketKey[]{key});
        } else {
            ((OpenSslSessionContext)sslClientCtx.sessionContext()).setTicketKeys(new OpenSslSessionTicketKey[0]);
            ((OpenSslSessionContext)sslServerCtx.sessionContext()).setTicketKeys(new OpenSslSessionTicketKey[0]);
        }
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        final byte[] bytes = new byte[96];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        try {
            final AtomicReference assertErrorRef = new AtomicReference();
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    final SslHandler sslHandler = sslServerCtx.newHandler(ch.alloc());
                    ch.pipeline().addLast(new ChannelHandler[]{sslServerCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT)});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
                        private int handshakeCount;

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                            if (evt instanceof SslHandshakeCompletionEvent) {
                                ++this.handshakeCount;
                                ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)sslHandler.engine();
                                if (!"TLSv1.3".equals(engine.getSession().getProtocol())) {
                                    try {
                                        Assertions.assertEquals((Object)(this.handshakeCount > 1 ? 1 : 0), (Object)engine.isSessionReused());
                                    }
                                    catch (AssertionError error) {
                                        assertErrorRef.set(error);
                                        return;
                                    }
                                }
                                ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])bytes));
                            }
                        }
                    }});
                }
            }).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            InetSocketAddress serverAddr = (InetSocketAddress)sc.localAddress();
            SslHandlerTest.testSessionTickets(serverAddr, (EventLoopGroup)group, sslClientCtx, bytes, false);
            SslHandlerTest.testSessionTickets(serverAddr, (EventLoopGroup)group, sslClientCtx, bytes, true);
            AssertionError error = (AssertionError)assertErrorRef.get();
            if (error != null) {
                throw error;
            }
        }
        finally {
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testSessionTickets(InetSocketAddress serverAddress, EventLoopGroup group, SslContext sslClientCtx, final byte[] bytes, boolean isReused) throws Throwable {
        block9: {
            Channel cc = null;
            final LinkedBlockingQueue queue = new LinkedBlockingQueue();
            try {
                Object obj;
                final SslHandler clientSslHandler = sslClientCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, serverAddress.getAddress().getHostAddress(), serverAddress.getPort());
                ChannelFuture future = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) {
                        ch.pipeline().addLast(new ChannelHandler[]{clientSslHandler});
                        ch.pipeline().addLast(new ChannelHandler[]{new ByteToMessageDecoder(){

                            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
                                if (in.readableBytes() == bytes.length) {
                                    queue.add(in.readBytes(bytes.length));
                                }
                            }

                            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                                queue.add(cause);
                            }
                        }});
                    }
                })).connect((SocketAddress)serverAddress);
                cc = future.syncUninterruptibly().channel();
                Assertions.assertTrue((boolean)clientSslHandler.handshakeFuture().sync().isSuccess());
                ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)clientSslHandler.engine();
                if (!"TLSv1.3".equals(engine.getSession().getProtocol())) {
                    Assertions.assertEquals((Object)isReused, (Object)engine.isSessionReused());
                }
                if ((obj = queue.take()) instanceof ByteBuf) {
                    ByteBuf buffer = (ByteBuf)obj;
                    ByteBuf expected = Unpooled.wrappedBuffer((byte[])bytes);
                    try {
                        Assertions.assertEquals((Object)expected, (Object)buffer);
                        break block9;
                    }
                    finally {
                        expected.release();
                        buffer.release();
                    }
                }
                throw (Throwable)obj;
            }
            finally {
                if (cc != null) {
                    cc.close().syncUninterruptibly();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testHandshakeFailureOnlyFireExceptionOnce() throws Exception {
        SslContext sslClientCtx = SslContextBuilder.forClient().trustManager((TrustManager)new X509ExtendedTrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
                this.failVerification();
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
                this.failVerification();
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                this.failVerification();
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                this.failVerification();
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                this.failVerification();
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                this.failVerification();
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return EmptyArrays.EMPTY_X509_CERTIFICATES;
            }

            private void failVerification() throws CertificateException {
                throw new CertificateException();
            }
        }).sslProvider(SslProvider.JDK).build();
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContext sslServerCtx = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslProvider(SslProvider.JDK).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        final SslHandler clientSslHandler = sslClientCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        final SslHandler serverSslHandler = sslServerCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        try {
            final Object terminalEvent = new Object();
            final LinkedBlockingQueue errorQueue = new LinkedBlockingQueue();
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{serverSslHandler});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            errorQueue.add(cause);
                        }

                        public void channelInactive(ChannelHandlerContext ctx) {
                            errorQueue.add(terminalEvent);
                        }
                    }});
                }
            }).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            final ChannelFuture future = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{clientSslHandler});
                }
            })).connect(sc.localAddress());
            future.syncUninterruptibly();
            clientSslHandler.handshakeFuture().addListener((GenericFutureListener)new FutureListener<Channel>(){

                public void operationComplete(Future<Channel> f) {
                    future.channel().close();
                }
            });
            Assertions.assertFalse((boolean)clientSslHandler.handshakeFuture().await().isSuccess());
            Assertions.assertFalse((boolean)serverSslHandler.handshakeFuture().await().isSuccess());
            Object error = errorQueue.take();
            MatcherAssert.assertThat(error, (Matcher)Matchers.instanceOf(DecoderException.class));
            MatcherAssert.assertThat((Object)((Throwable)error).getCause(), (Matcher)Matchers.instanceOf(SSLException.class));
            Object terminal = errorQueue.take();
            Assertions.assertSame((Object)terminalEvent, terminal);
            Assertions.assertNull(errorQueue.poll(1L, TimeUnit.MILLISECONDS));
        }
        finally {
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
        }
    }

    @Test
    public void testHandshakeFailureCipherMissmatchTLSv12Jdk() throws Exception {
        SslHandlerTest.testHandshakeFailureCipherMissmatch(SslProvider.JDK, false);
    }

    @Test
    public void testHandshakeFailureCipherMissmatchTLSv13Jdk() throws Exception {
        Assumptions.assumeTrue((boolean)SslProvider.isTlsv13Supported((SslProvider)SslProvider.JDK));
        SslHandlerTest.testHandshakeFailureCipherMissmatch(SslProvider.JDK, true);
    }

    @Test
    public void testHandshakeFailureCipherMissmatchTLSv12OpenSsl() throws Exception {
        OpenSsl.ensureAvailability();
        SslHandlerTest.testHandshakeFailureCipherMissmatch(SslProvider.OPENSSL, false);
    }

    @Test
    public void testHandshakeFailureCipherMissmatchTLSv13OpenSsl() throws Exception {
        OpenSsl.ensureAvailability();
        Assumptions.assumeTrue((boolean)SslProvider.isTlsv13Supported((SslProvider)SslProvider.OPENSSL));
        Assumptions.assumeFalse((boolean)OpenSsl.isBoringSSL(), (String)"BoringSSL does not support setting ciphers for TLSv1.3 explicit");
        SslHandlerTest.testHandshakeFailureCipherMissmatch(SslProvider.OPENSSL, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testHandshakeFailureCipherMissmatch(SslProvider provider, boolean tls13) throws Exception {
        String protocol;
        String serverCipher;
        String clientCipher;
        if (tls13) {
            clientCipher = "TLS_AES_128_GCM_SHA256";
            serverCipher = "TLS_AES_256_GCM_SHA384";
            protocol = "TLSv1.3";
        } else {
            clientCipher = "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256";
            serverCipher = "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384";
            protocol = "TLSv1.2";
        }
        SslContext sslClientCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).protocols(new String[]{protocol}).ciphers(Collections.singleton(clientCipher)).sslProvider(provider).build();
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContext sslServerCtx = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).protocols(new String[]{protocol}).ciphers(Collections.singleton(serverCipher)).sslProvider(provider).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        final SslHandler clientSslHandler = sslClientCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        final SslHandler serverSslHandler = sslServerCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        final AtomicReference clientEvent = new AtomicReference();
        final AtomicReference serverEvent = new AtomicReference();
        try {
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{serverSslHandler});
                    class SslEventHandler
                    extends ChannelInboundHandlerAdapter {
                        private final AtomicReference<SslHandshakeCompletionEvent> ref;

                        SslEventHandler(AtomicReference<SslHandshakeCompletionEvent> ref) {
                            this.ref = ref;
                        }

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                            if (evt instanceof SslHandshakeCompletionEvent) {
                                this.ref.set((SslHandshakeCompletionEvent)evt);
                            }
                            super.userEventTriggered(ctx, evt);
                        }
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new SslEventHandler(serverEvent)});
                }
            }).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            ChannelFuture future = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{clientSslHandler});
                    ch.pipeline().addLast(new ChannelHandler[]{new SslEventHandler(clientEvent)});
                }
            })).connect(sc.localAddress());
            cc = future.syncUninterruptibly().channel();
            Throwable clientCause = clientSslHandler.handshakeFuture().await().cause();
            MatcherAssert.assertThat((Object)clientCause, (Matcher)CoreMatchers.instanceOf(SSLException.class));
            MatcherAssert.assertThat((Object)clientCause.getCause(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(ClosedChannelException.class)));
            Throwable serverCause = serverSslHandler.handshakeFuture().await().cause();
            MatcherAssert.assertThat((Object)serverCause, (Matcher)CoreMatchers.instanceOf(SSLException.class));
            MatcherAssert.assertThat((Object)serverCause.getCause(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(ClosedChannelException.class)));
            cc.close().syncUninterruptibly();
            sc.close().syncUninterruptibly();
            Throwable eventClientCause = ((SslHandshakeCompletionEvent)clientEvent.get()).cause();
            MatcherAssert.assertThat((Object)eventClientCause, (Matcher)CoreMatchers.instanceOf(SSLException.class));
            MatcherAssert.assertThat((Object)eventClientCause.getCause(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(ClosedChannelException.class)));
            Throwable serverEventCause = ((SslHandshakeCompletionEvent)serverEvent.get()).cause();
            MatcherAssert.assertThat((Object)serverEventCause, (Matcher)CoreMatchers.instanceOf(SSLException.class));
            MatcherAssert.assertThat((Object)serverEventCause.getCause(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(ClosedChannelException.class)));
        }
        finally {
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }

    @Test
    public void testSslCompletionEventsTls12JDK() throws Exception {
        this.testSslCompletionEvents(SslProvider.JDK, "TLSv1.2", true);
        this.testSslCompletionEvents(SslProvider.JDK, "TLSv1.2", false);
    }

    @Test
    public void testSslCompletionEventsTls12Openssl() throws Exception {
        OpenSsl.ensureAvailability();
        this.testSslCompletionEvents(SslProvider.OPENSSL, "TLSv1.2", true);
        this.testSslCompletionEvents(SslProvider.OPENSSL, "TLSv1.2", false);
    }

    @Test
    public void testSslCompletionEventsTls13JDK() throws Exception {
        Assumptions.assumeTrue((boolean)SslProvider.isTlsv13Supported((SslProvider)SslProvider.JDK));
        this.testSslCompletionEvents(SslProvider.JDK, "TLSv1.3", true);
        this.testSslCompletionEvents(SslProvider.JDK, "TLSv1.3", false);
    }

    @Test
    public void testSslCompletionEventsTls13Openssl() throws Exception {
        OpenSsl.ensureAvailability();
        Assumptions.assumeTrue((boolean)SslProvider.isTlsv13Supported((SslProvider)SslProvider.OPENSSL));
        this.testSslCompletionEvents(SslProvider.OPENSSL, "TLSv1.3", true);
        this.testSslCompletionEvents(SslProvider.OPENSSL, "TLSv1.3", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSslCompletionEvents(SslProvider provider, final String protocol, boolean clientClose) throws Exception {
        final SslContext sslClientCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).protocols(new String[]{protocol}).sslProvider(provider).build();
        SelfSignedCertificate cert = new SelfSignedCertificate();
        final SslContext sslServerCtx = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).protocols(new String[]{protocol}).sslProvider(provider).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        final LinkedBlockingQueue acceptedChannels = new LinkedBlockingQueue();
        final LinkedBlockingQueue serverHandshakeCompletionEvents = new LinkedBlockingQueue();
        final LinkedBlockingQueue clientHandshakeCompletionEvents = new LinkedBlockingQueue();
        final LinkedBlockingQueue serverCloseCompletionEvents = new LinkedBlockingQueue();
        final LinkedBlockingQueue clientCloseCompletionEvents = new LinkedBlockingQueue();
        try {
            SslHandshakeCompletionEvent event;
            int i;
            Channel sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    acceptedChannels.add(ch);
                    SslHandler handler = sslServerCtx.newHandler(ch.alloc());
                    if (!"TLSv1.3".equals(protocol)) {
                        handler.setCloseNotifyReadTimeout(5L, TimeUnit.SECONDS);
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{handler});
                    ch.pipeline().addLast(new ChannelHandler[]{new SslCompletionEventHandler(serverHandshakeCompletionEvents, serverCloseCompletionEvents)});
                }
            }).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            Bootstrap bs = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    SslHandler handler = sslClientCtx.newHandler(ch.alloc(), "netty.io", 9999);
                    if (!"TLSv1.3".equals(protocol)) {
                        handler.setCloseNotifyReadTimeout(5L, TimeUnit.SECONDS);
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{handler});
                    ch.pipeline().addLast(new ChannelHandler[]{new SslCompletionEventHandler(clientHandshakeCompletionEvents, clientCloseCompletionEvents)});
                }
            })).remoteAddress(sc.localAddress());
            Channel cc1 = bs.connect().sync().channel();
            Channel cc2 = bs.connect().sync().channel();
            for (i = 0; i < 2; ++i) {
                event = (SslHandshakeCompletionEvent)clientHandshakeCompletionEvents.take();
                Assertions.assertTrue((boolean)event.isSuccess());
            }
            for (i = 0; i < 2; ++i) {
                event = (SslHandshakeCompletionEvent)serverHandshakeCompletionEvents.take();
                Assertions.assertTrue((boolean)event.isSuccess());
            }
            Assertions.assertEquals((int)0, (int)clientCloseCompletionEvents.size());
            Assertions.assertEquals((int)0, (int)serverCloseCompletionEvents.size());
            if (clientClose) {
                cc1.close().sync();
                cc2.close().sync();
                ((Channel)acceptedChannels.take()).closeFuture().sync();
                ((Channel)acceptedChannels.take()).closeFuture().sync();
            } else {
                ((Channel)acceptedChannels.take()).close().sync();
                ((Channel)acceptedChannels.take()).close().sync();
                cc1.closeFuture().sync();
                cc2.closeFuture().sync();
            }
            for (i = 0; i < 2; ++i) {
                event = (SslCloseCompletionEvent)clientCloseCompletionEvents.take();
                if (clientClose) {
                    if ("TLSv1.3".equals(protocol)) {
                        Assertions.assertNotNull((Object)event);
                        continue;
                    }
                    Assertions.assertTrue((boolean)event.isSuccess());
                    continue;
                }
                Assertions.assertTrue((boolean)event.isSuccess());
            }
            for (i = 0; i < 2; ++i) {
                event = (SslCloseCompletionEvent)serverCloseCompletionEvents.take();
                if (clientClose) {
                    Assertions.assertTrue((boolean)event.isSuccess());
                    continue;
                }
                if ("TLSv1.3".equals(protocol)) {
                    Assertions.assertNotNull((Object)event);
                    continue;
                }
                Assertions.assertTrue((boolean)event.isSuccess());
            }
            sc.close().sync();
            Assertions.assertEquals((int)0, (int)clientHandshakeCompletionEvents.size());
            Assertions.assertEquals((int)0, (int)serverHandshakeCompletionEvents.size());
            Assertions.assertEquals((int)0, (int)clientCloseCompletionEvents.size());
            Assertions.assertEquals((int)0, (int)serverCloseCompletionEvents.size());
        }
        finally {
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslClientCtx);
            ReferenceCountUtil.release((Object)sslServerCtx);
        }
    }

    private static class SslCompletionEventHandler
    extends ChannelInboundHandlerAdapter {
        private final Queue<SslHandshakeCompletionEvent> handshakeCompletionEvents;
        private final Queue<SslCloseCompletionEvent> closeCompletionEvents;

        SslCompletionEventHandler(Queue<SslHandshakeCompletionEvent> handshakeCompletionEvents, Queue<SslCloseCompletionEvent> closeCompletionEvents) {
            this.handshakeCompletionEvents = handshakeCompletionEvents;
            this.closeCompletionEvents = closeCompletionEvents;
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            if (evt instanceof SslHandshakeCompletionEvent) {
                this.handshakeCompletionEvents.add((SslHandshakeCompletionEvent)evt);
            } else if (evt instanceof SslCloseCompletionEvent) {
                this.closeCompletionEvents.add((SslCloseCompletionEvent)evt);
            }
        }

        public boolean isSharable() {
            return true;
        }
    }

    private static final class TlsReadTest
    extends ChannelOutboundHandlerAdapter {
        private volatile boolean readIssued;

        private TlsReadTest() {
        }

        public void read(ChannelHandlerContext ctx) throws Exception {
            this.readIssued = true;
            super.read(ctx);
        }

        public void test(final boolean dropChannelActive) throws Exception {
            SSLEngine engine = SSLContext.getDefault().createSSLEngine();
            engine.setUseClientMode(true);
            EmbeddedChannel ch = new EmbeddedChannel(false, false, new ChannelHandler[]{this, new SslHandler(engine), new ChannelInboundHandlerAdapter(){

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    if (!dropChannelActive) {
                        ctx.fireChannelActive();
                    }
                }
            }});
            ch.config().setAutoRead(false);
            Assertions.assertFalse((boolean)ch.config().isAutoRead());
            ch.register();
            Assertions.assertTrue((boolean)this.readIssued);
            this.readIssued = false;
            Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{Unpooled.EMPTY_BUFFER}));
            Assertions.assertTrue((boolean)this.readIssued);
            Assertions.assertTrue((boolean)ch.finishAndReleaseAll());
        }
    }
}

