/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.SelfTestStatus;
import io.netty.handler.ssl.SSLEngineTest;
import io.netty.handler.ssl.SslProvider;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@DisabledIf(value="checkIfAccpIsDisabled")
public class AmazonCorrettoSslEngineTest
extends SSLEngineTest {
    static boolean checkIfAccpIsDisabled() {
        return AmazonCorrettoCryptoProvider.INSTANCE.getLoadingError() != null || !AmazonCorrettoCryptoProvider.INSTANCE.runSelfTests().equals((Object)SelfTestStatus.PASSED);
    }

    public AmazonCorrettoSslEngineTest() {
        super(SslProvider.isTlsv13Supported((SslProvider)SslProvider.JDK));
    }

    @Override
    protected SslProvider sslClientProvider() {
        return SslProvider.JDK;
    }

    @Override
    protected SslProvider sslServerProvider() {
        return SslProvider.JDK;
    }

    @Override
    @BeforeEach
    public void setup() {
        Security.insertProviderAt((Provider)AmazonCorrettoCryptoProvider.INSTANCE, 1);
        try {
            AmazonCorrettoCryptoProvider.INSTANCE.assertHealthy();
            String providerName = Cipher.getInstance("AES/GCM/NoPadding").getProvider().getName();
            Assertions.assertEquals((Object)"AmazonCorrettoCryptoProvider", (Object)providerName);
        }
        catch (Throwable e) {
            Security.removeProvider("AmazonCorrettoCryptoProvider");
            throw new AssertionError((Object)e);
        }
        super.setup();
    }

    @Override
    @AfterEach
    public void tearDown() throws InterruptedException {
        super.tearDown();
        Security.removeProvider("AmazonCorrettoCryptoProvider");
        Assertions.assertNull((Object)Security.getProvider("AmazonCorrettoCryptoProvider"));
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled
    public void testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth(SSLEngineTest.SSLEngineTestParam param) {
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled
    public void testMutualAuthValidClientCertChainTooLongFailRequireClientAuth(SSLEngineTest.SSLEngineTestParam param) {
    }

    @Override
    protected boolean mySetupMutualAuthServerIsValidException(Throwable cause) {
        return super.mySetupMutualAuthServerIsValidException(cause) || AmazonCorrettoSslEngineTest.causedBySSLException(cause);
    }
}

