/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ipfilter;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.ipfilter.UniqueIpFilter;
import io.netty.util.internal.SocketUtils;
import java.net.SocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UniqueIpFilterTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUniqueIpFilterHandler() throws ExecutionException, InterruptedException {
        CyclicBarrier barrier = new CyclicBarrier(2);
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        try {
            for (int round = 0; round < 10000; ++round) {
                UniqueIpFilter ipFilter = new UniqueIpFilter();
                Future<EmbeddedChannel> future1 = UniqueIpFilterTest.newChannelAsync(barrier, executorService, new ChannelHandler[]{ipFilter});
                Future<EmbeddedChannel> future2 = UniqueIpFilterTest.newChannelAsync(barrier, executorService, new ChannelHandler[]{ipFilter});
                EmbeddedChannel ch1 = future1.get();
                EmbeddedChannel ch2 = future2.get();
                Assertions.assertTrue((ch1.isActive() || ch2.isActive() ? 1 : 0) != 0);
                Assertions.assertFalse((ch1.isActive() && ch2.isActive() ? 1 : 0) != 0);
                barrier.reset();
                ch1.close().await();
                ch2.close().await();
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    private static Future<EmbeddedChannel> newChannelAsync(final CyclicBarrier barrier, ExecutorService executorService, final ChannelHandler ... handler) {
        return executorService.submit(new Callable<EmbeddedChannel>(){

            @Override
            public EmbeddedChannel call() throws Exception {
                barrier.await();
                return new EmbeddedChannel(handler){

                    protected SocketAddress remoteAddress0() {
                        return this.isActive() ? SocketUtils.socketAddress((String)"91.92.93.1", (int)5421) : null;
                    }
                };
            }
        });
    }
}

