/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.traffic;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import io.netty.handler.traffic.TrafficCounter;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class FileRegionThrottleTest {
    private static final byte[] BYTES = new byte[262144];
    private static final long WRITE_LIMIT = 65536L;
    private static File tmp;
    private EventLoopGroup group;

    @BeforeAll
    public static void beforeClass() throws IOException {
        Random r = new Random();
        for (int i = 0; i < BYTES.length; ++i) {
            FileRegionThrottleTest.BYTES[i] = (byte)r.nextInt(255);
        }
        tmp = PlatformDependent.createTempFile((String)"netty-traffic", (String)".tmp", null);
        tmp.deleteOnExit();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(tmp);
            out.write(BYTES);
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @BeforeEach
    public void setUp() {
        this.group = new NioEventLoopGroup();
    }

    @AfterEach
    public void tearDown() {
        this.group.shutdownGracefully();
    }

    @Disabled(value="This test is flaky, need more investigation")
    @Test
    public void testGlobalWriteThrottle() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        final GlobalTrafficShapingHandler gtsh = new GlobalTrafficShapingHandler((ScheduledExecutorService)this.group, 65536L, 0L);
        ServerBootstrap bs = new ServerBootstrap();
        ((ServerBootstrap)bs.group(this.group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new LineBasedFrameDecoder(Integer.MAX_VALUE)});
                ch.pipeline().addLast(new ChannelHandler[]{new MessageDecoder()});
                ch.pipeline().addLast(new ChannelHandler[]{gtsh});
            }
        });
        Channel sc = bs.bind(0).sync().channel();
        Channel cc = this.clientConnect(sc.localAddress(), new ReadHandler(latch)).channel();
        long start = TrafficCounter.milliSecondFromNano();
        cc.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)"send-file\n", (Charset)CharsetUtil.US_ASCII)).sync();
        latch.await();
        long timeTaken = TrafficCounter.milliSecondFromNano() - start;
        Assertions.assertTrue((timeTaken > 3000L ? 1 : 0) != 0, (String)"Data streamed faster than expected");
        sc.close().sync();
        cc.close().sync();
    }

    private ChannelFuture clientConnect(SocketAddress server, final ReadHandler readHandler) throws Exception {
        Bootstrap bc = new Bootstrap();
        ((Bootstrap)((Bootstrap)bc.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{readHandler});
            }
        });
        return bc.connect(server).sync();
    }

    private static final class ReadHandler
    extends ChannelInboundHandlerAdapter {
        private long bytesTransferred;
        private final CountDownLatch latch;

        ReadHandler(CountDownLatch latch) {
            this.latch = latch;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg instanceof ByteBuf) {
                ByteBuf buf = (ByteBuf)msg;
                this.bytesTransferred += (long)buf.readableBytes();
                buf.release();
                if (this.bytesTransferred == tmp.length()) {
                    this.latch.countDown();
                }
            }
        }
    }

    private static final class MessageDecoder
    extends ChannelInboundHandlerAdapter {
        private MessageDecoder() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof ByteBuf) {
                ByteBuf buf = (ByteBuf)msg;
                String message = buf.toString(Charset.defaultCharset());
                buf.release();
                if (message.equals("send-file")) {
                    RandomAccessFile raf = new RandomAccessFile(tmp, "r");
                    ctx.channel().writeAndFlush((Object)new DefaultFileRegion(raf.getChannel(), 0L, tmp.length()));
                }
            }
        }
    }
}

