/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.timeout;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CountDownLatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class WriteTimeoutHandlerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPromiseUseDifferentExecutor() throws Exception {
        DefaultEventExecutorGroup group1 = new DefaultEventExecutorGroup(1);
        DefaultEventExecutorGroup group2 = new DefaultEventExecutorGroup(1);
        EmbeddedChannel channel = new EmbeddedChannel(false, false, new ChannelHandler[0]);
        try {
            channel.pipeline().addLast((EventExecutorGroup)group1, new ChannelHandler[]{new WriteTimeoutHandler(10000)});
            final CountDownLatch latch = new CountDownLatch(1);
            channel.pipeline().addLast((EventExecutorGroup)group2, new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    ctx.writeAndFlush((Object)"something").addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            latch.countDown();
                        }
                    });
                }
            }});
            channel.register();
            latch.await();
            Assertions.assertTrue((boolean)channel.finishAndReleaseAll());
        }
        finally {
            group1.shutdownGracefully();
            group2.shutdownGracefully();
        }
    }
}

