/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.handler.ssl.util.LazyX509Certificate;
import io.netty.util.CharsetUtil;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LazyX509CertificateTest {
    private static final String CERTIFICATE = "-----BEGIN CERTIFICATE-----\nMIIEITCCAwmgAwIBAgIUaLL8vLOhWLCLXVHEJqXJhfmsTB8wDQYJKoZIhvcNAQEL\nBQAwgawxCzAJBgNVBAYTAlVTMRYwFAYDVQQIDA1NYXNzYWNodXNldHRzMRIwEAYD\nVQQHDAlDYW1icmlkZ2UxGDAWBgNVBAoMD25ldHR5IHRlc3QgY2FzZTEYMBYGA1UE\nCwwPbmV0dHkgdGVzdCBjYXNlMRgwFgYDVQQDDA9uZXR0eSB0ZXN0IGNhc2UxIzAh\nBgkqhkiG9w0BCQEWFGNjb25uZWxsQGh1YnNwb3QuY29tMB4XDTI0MDEyMTE5MzMy\nMFoXDTI1MDEyMDE5MzMyMFowgawxCzAJBgNVBAYTAlVTMRYwFAYDVQQIDA1NYXNz\nYWNodXNldHRzMRIwEAYDVQQHDAlDYW1icmlkZ2UxGDAWBgNVBAoMD25ldHR5IHRl\nc3QgY2FzZTEYMBYGA1UECwwPbmV0dHkgdGVzdCBjYXNlMRgwFgYDVQQDDA9uZXR0\neSB0ZXN0IGNhc2UxIzAhBgkqhkiG9w0BCQEWFGNjb25uZWxsQGh1YnNwb3QuY29t\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAy+qzEZpQMjVdLj0siUcG\ny8LIHOW4S+tgHIKFkF865qWq6FVGbROe2Z0f5W6yIamZkdxzptT0iv+8S5okNNeW\n2NbsN/HNJIRtWfxku1Jh1gBqSkAYIjXyq7+20hIaJTzzxqike9M/Lc14EGb33Ja/\nkDPRV3UtiM3Ntf3eALXKbrWptkbgQngCaTgtfg8IkMAEpP270wZ9fW0lDHv3NPPt\nZt0QSJzWSqWfu+l4ayvcUQYyNJesx9YmTHSJu69lvT4QApoX8FEiHfNCJ28R50CS\naIgOpCWUvkH7rqx0p9q393uJRS/S6RlLbU30xUN1fNrVmP/XAapfy+R0PSgiUi8o\nEQIDAQABozkwNzAWBgNVHRIEDzANggt3d3cuZm9vLmNvbTAdBgNVHQ4EFgQUl4FD\nY8jJ/JHJR68YqPsGUjUJuwgwDQYJKoZIhvcNAQELBQADggEBADVzivYz2M0qsWUc\njXjCHymwTIr+7ud10um53FbYEAfKWsIY8Pp35fKpFzUwc5wVdCnLU86K/YMKRzNB\nzL2Auow3PJFRvXecOv7dWxNlNneLDcwbVrdNRu6nQXmZUgyz0oUKuJbF+JGtI+7W\nkRw7yhBfki+UCSQWeDqvaWzgmA4Us0N8NFq3euAs4xFbMMPMQWrT9Z7DGchCeRiB\ndkQBvh88vbR3v2Saq14W4Wt5rj2++vXWGQSeAQL6nGbOwc3ohW6isNNV0eGQQTmS\nkhS2d/JDZq2XL5RGexf3CA6YYzWiTr9YZHNjuobvLH7mVnA2c8n6Zty/UhfnuK1x\nJbkleFk=\n-----END CERTIFICATE-----";

    @Test
    public void testLazyX509Certificate() throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(CERTIFICATE.getBytes(CharsetUtil.UTF_8)));
        LazyX509Certificate lazyX509Certificate = new LazyX509Certificate(CERTIFICATE.getBytes(CharsetUtil.UTF_8));
        Assertions.assertEquals((int)x509Certificate.getVersion(), (int)lazyX509Certificate.getVersion());
        Assertions.assertEquals((Object)x509Certificate.getSerialNumber(), (Object)lazyX509Certificate.getSerialNumber());
        Assertions.assertEquals((Object)x509Certificate.getIssuerDN(), (Object)lazyX509Certificate.getIssuerDN());
        Assertions.assertEquals((Object)x509Certificate.getIssuerX500Principal(), (Object)lazyX509Certificate.getIssuerX500Principal());
        Assertions.assertEquals((Object)x509Certificate.getSubjectDN(), (Object)lazyX509Certificate.getSubjectDN());
        Assertions.assertEquals((Object)x509Certificate.getNotBefore(), (Object)lazyX509Certificate.getNotBefore());
        Assertions.assertEquals((Object)x509Certificate.getNotAfter(), (Object)lazyX509Certificate.getNotAfter());
        Assertions.assertArrayEquals((byte[])x509Certificate.getTBSCertificate(), (byte[])lazyX509Certificate.getTBSCertificate());
        Assertions.assertArrayEquals((byte[])x509Certificate.getSignature(), (byte[])lazyX509Certificate.getSignature());
        Assertions.assertEquals((Object)x509Certificate.getSigAlgName(), (Object)lazyX509Certificate.getSigAlgName());
        Assertions.assertEquals((Object)x509Certificate.getSigAlgOID(), (Object)lazyX509Certificate.getSigAlgOID());
        Assertions.assertEquals((Object)x509Certificate.getSigAlgParams(), (Object)lazyX509Certificate.getSigAlgParams());
        Assertions.assertArrayEquals((boolean[])x509Certificate.getIssuerUniqueID(), (boolean[])lazyX509Certificate.getIssuerUniqueID());
        Assertions.assertArrayEquals((boolean[])x509Certificate.getSubjectUniqueID(), (boolean[])lazyX509Certificate.getSubjectUniqueID());
        Assertions.assertArrayEquals((boolean[])x509Certificate.getKeyUsage(), (boolean[])lazyX509Certificate.getKeyUsage());
        Assertions.assertEquals(x509Certificate.getExtendedKeyUsage(), (Object)lazyX509Certificate.getExtendedKeyUsage());
        Assertions.assertEquals((int)x509Certificate.getBasicConstraints(), (int)lazyX509Certificate.getBasicConstraints());
        Assertions.assertEquals(x509Certificate.getSubjectAlternativeNames(), (Object)lazyX509Certificate.getSubjectAlternativeNames());
        Assertions.assertEquals(x509Certificate.getIssuerAlternativeNames(), (Object)lazyX509Certificate.getIssuerAlternativeNames());
    }
}

