/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.Java8SslTestUtils;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslEngineTestParam;
import io.netty.handler.ssl.OpenSslTestUtils;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.SSLEngineTest;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLEngine;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class JdkOpenSslEngineInteroptTest
extends SSLEngineTest {
    public JdkOpenSslEngineInteroptTest() {
        super(SslProvider.isTlsv13Supported((SslProvider)SslProvider.JDK) && SslProvider.isTlsv13Supported((SslProvider)SslProvider.OPENSSL));
    }

    @Override
    protected List<SSLEngineTest.SSLEngineTestParam> newTestParams() {
        List<SSLEngineTest.SSLEngineTestParam> params = super.newTestParams();
        ArrayList<SSLEngineTest.SSLEngineTestParam> testParams = new ArrayList<SSLEngineTest.SSLEngineTestParam>();
        for (SSLEngineTest.SSLEngineTestParam param : params) {
            OpenSslEngineTestParam.expandCombinations(param, testParams);
        }
        return testParams;
    }

    @BeforeAll
    public static void checkOpenSsl() {
        OpenSsl.ensureAvailability();
    }

    @Override
    protected SslProvider sslClientProvider() {
        return SslProvider.JDK;
    }

    @Override
    protected SslProvider sslServerProvider() {
        return SslProvider.OPENSSL;
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled(value="Disable until figured out why this sometimes fail on the CI")
    public void testMutualAuthSameCerts(SSLEngineTest.SSLEngineTestParam param) throws Throwable {
        super.testMutualAuthSameCerts(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled(value="Disable until figured out why this sometimes fail on the CI")
    public void testMutualAuthDiffCerts(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        super.testMutualAuthDiffCerts(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled(value="Disable until figured out why this sometimes fail on the CI")
    public void testMutualAuthDiffCertsServerFailure(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        super.testMutualAuthDiffCertsServerFailure(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled(value="Disable until figured out why this sometimes fail on the CI")
    public void testMutualAuthDiffCertsClientFailure(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        super.testMutualAuthDiffCertsClientFailure(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled(value="Disable until figured out why this sometimes fail on the CI")
    public void testMutualAuthInvalidIntermediateCASucceedWithOptionalClientAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthInvalidIntermediateCASucceedWithOptionalClientAuth(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled(value="Disable until figured out why this sometimes fail on the CI")
    public void testMutualAuthInvalidIntermediateCAFailWithOptionalClientAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthInvalidIntermediateCAFailWithOptionalClientAuth(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled(value="Disable until figured out why this sometimes fail on the CI")
    public void testMutualAuthInvalidIntermediateCAFailWithRequiredClientAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthInvalidIntermediateCAFailWithRequiredClientAuth(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled(value="Disable until figured out why this sometimes fail on the CI")
    public void testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled(value="Disable until figured out why this sometimes fail on the CI")
    public void testMutualAuthValidClientCertChainTooLongFailRequireClientAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthValidClientCertChainTooLongFailRequireClientAuth(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionAfterHandshakeKeyManagerFactoryMutualAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSessionAfterHandshakeKeyManagerFactoryMutualAuth(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionAfterHandshakeKeyManagerFactory(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSessionAfterHandshakeKeyManagerFactory(param);
    }

    @Override
    protected void mySetupMutualAuthServerInitSslHandler(SslHandler handler) {
        ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)handler.engine();
        engine.setVerify(-1, 1);
    }

    @Override
    protected boolean mySetupMutualAuthServerIsValidClientException(Throwable cause) {
        return super.mySetupMutualAuthServerIsValidClientException(cause) || JdkOpenSslEngineInteroptTest.causedBySSLException(cause);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testHandshakeSession(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testHandshakeSession(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSupportedSignatureAlgorithms(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSupportedSignatureAlgorithms(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionLocalWhenNonMutualWithKeyManager(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSessionLocalWhenNonMutualWithKeyManager(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionLocalWhenNonMutualWithoutKeyManager(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        Assumptions.assumeTrue((boolean)OpenSsl.supportsKeyManagerFactory());
        super.testSessionLocalWhenNonMutualWithoutKeyManager(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionCache(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        Assumptions.assumeTrue((boolean)OpenSsl.isSessionCacheSupported());
        super.testSessionCache(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionCacheTimeout(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        Assumptions.assumeTrue((boolean)OpenSsl.isSessionCacheSupported());
        super.testSessionCacheTimeout(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionCacheSize(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        Assumptions.assumeTrue((boolean)OpenSsl.isSessionCacheSupported());
        super.testSessionCacheSize(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testRSASSAPSS(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testRSASSAPSS(param);
    }

    @Override
    protected SSLEngine wrapEngine(SSLEngine engine) {
        return Java8SslTestUtils.wrapSSLEngineForTesting(engine);
    }

    @Override
    protected SslContext wrapContext(SSLEngineTest.SSLEngineTestParam param, SslContext context) {
        return OpenSslEngineTestParam.wrapContext(param, context);
    }
}

