/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.CachedSelfSignedCertificate;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.net.ssl.SSLSession;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CloseNotifyTest {
    private static final UnpooledByteBufAllocator ALLOC = UnpooledByteBufAllocator.DEFAULT;
    private static final Object INACTIVE = new Object(){

        public String toString() {
            return "INACTIVE";
        }
    };

    static Collection<Object[]> data() {
        return Arrays.asList({SslProvider.JDK, "TLSv1.2"}, {SslProvider.JDK, "TLSv1.3"}, {SslProvider.OPENSSL, "TLSv1.2"}, {SslProvider.OPENSSL, "TLSv1.3"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{index}: provider={0}, protocol={1}")
    @Timeout(value=30L)
    @MethodSource(value={"data"})
    public void eventsOrder(SslProvider provider, String protocol) throws Exception {
        Assumptions.assumeTrue((provider != SslProvider.OPENSSL || OpenSsl.isAvailable() ? 1 : 0) != 0, (String)"OpenSSL is not available");
        if ("TLSv1.3".equals(protocol)) {
            Assumptions.assumeTrue((boolean)SslProvider.isTlsv13Supported((SslProvider)provider));
        }
        LinkedBlockingQueue<Object> clientEventQueue = new LinkedBlockingQueue<Object>();
        LinkedBlockingQueue<Object> serverEventQueue = new LinkedBlockingQueue<Object>();
        EmbeddedChannel clientChannel = CloseNotifyTest.initChannel(provider, protocol, true, clientEventQueue);
        EmbeddedChannel serverChannel = CloseNotifyTest.initChannel(provider, protocol, false, serverEventQueue);
        try {
            CloseNotifyTest.forwardData(clientChannel, serverChannel);
            CloseNotifyTest.forwardData(serverChannel, clientChannel);
            CloseNotifyTest.forwardData(clientChannel, serverChannel);
            CloseNotifyTest.forwardData(serverChannel, clientChannel);
            MatcherAssert.assertThat(clientEventQueue.poll(), (Matcher)Matchers.instanceOf(SslHandshakeCompletionEvent.class));
            MatcherAssert.assertThat(serverEventQueue.poll(), (Matcher)Matchers.instanceOf(SslHandshakeCompletionEvent.class));
            MatcherAssert.assertThat((Object)CloseNotifyTest.handshakenProtocol(clientChannel), (Matcher)Matchers.equalTo((Object)protocol));
            clientChannel.writeOutbound(new Object[]{ByteBufUtil.writeAscii((ByteBufAllocator)ALLOC, (CharSequence)"request_msg")});
            CloseNotifyTest.forwardData(clientChannel, serverChannel);
            MatcherAssert.assertThat(serverEventQueue.poll(), (Matcher)Matchers.equalTo((Object)"request_msg"));
            serverChannel.writeOutbound(new Object[]{ByteBufUtil.writeAscii((ByteBufAllocator)ALLOC, (CharSequence)"response_msg")});
            MatcherAssert.assertThat((Object)serverChannel.finish(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat(serverEventQueue.poll(), (Matcher)Matchers.instanceOf(SslCloseCompletionEvent.class));
            MatcherAssert.assertThat(clientEventQueue, (Matcher)Matchers.empty());
            CloseNotifyTest.forwardAllWithCloseNotify(serverChannel, clientChannel);
            MatcherAssert.assertThat(clientEventQueue.poll(), (Matcher)Matchers.equalTo((Object)"response_msg"));
            MatcherAssert.assertThat(clientEventQueue.poll(), (Matcher)Matchers.instanceOf(SslCloseCompletionEvent.class));
            if (!CloseNotifyTest.jdkTls13(provider, protocol)) {
                CloseNotifyTest.assertCloseNotify((ByteBuf)clientChannel.readOutbound());
            }
        }
        finally {
            try {
                clientChannel.finish();
            }
            finally {
                serverChannel.finish();
            }
        }
        if (CloseNotifyTest.jdkTls13(provider, protocol)) {
            CloseNotifyTest.assertCloseNotify((ByteBuf)clientChannel.readOutbound());
        } else {
            CloseNotifyTest.discardEmptyOutboundBuffers(clientChannel);
        }
        MatcherAssert.assertThat(clientEventQueue.poll(), (Matcher)Matchers.is((Object)INACTIVE));
        MatcherAssert.assertThat(clientEventQueue, (Matcher)Matchers.empty());
        MatcherAssert.assertThat(serverEventQueue.poll(), (Matcher)Matchers.is((Object)INACTIVE));
        MatcherAssert.assertThat(serverEventQueue, (Matcher)Matchers.empty());
        MatcherAssert.assertThat((Object)clientChannel.releaseInbound(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)clientChannel.releaseOutbound(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)serverChannel.releaseInbound(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)serverChannel.releaseOutbound(), (Matcher)Matchers.is((Object)false));
    }

    private static boolean jdkTls13(SslProvider provider, String protocol) {
        return provider == SslProvider.JDK && "TLSv1.3".equals(protocol);
    }

    private static EmbeddedChannel initChannel(SslProvider provider, String protocol, boolean useClientMode, final BlockingQueue<Object> eventQueue) throws Exception {
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        SslContext sslContext = (useClientMode ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE) : SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey())).sslProvider(provider).protocols(new String[]{protocol}).build();
        return new EmbeddedChannel(new ChannelHandler[]{sslContext.newHandler((ByteBufAllocator)ALLOC), new SimpleChannelInboundHandler<ByteBuf>(){

            protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
                eventQueue.add(msg.toString(StandardCharsets.US_ASCII));
            }

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                eventQueue.add(evt);
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                eventQueue.add(INACTIVE);
                super.channelInactive(ctx);
            }
        }});
    }

    private static void forwardData(EmbeddedChannel from, EmbeddedChannel to) {
        ByteBuf in;
        while ((in = (ByteBuf)from.readOutbound()) != null) {
            to.writeInbound(new Object[]{in});
        }
    }

    private static void forwardAllWithCloseNotify(EmbeddedChannel from, EmbeddedChannel to) {
        ByteBuf in;
        ByteBuf cumulation = Unpooled.EMPTY_BUFFER;
        ByteBuf closeNotify = null;
        while ((in = (ByteBuf)from.readOutbound()) != null) {
            if (closeNotify != null) {
                closeNotify.release();
            }
            closeNotify = in.duplicate();
            cumulation = ByteToMessageDecoder.MERGE_CUMULATOR.cumulate((ByteBufAllocator)ALLOC, cumulation, in.retain());
        }
        CloseNotifyTest.assertCloseNotify(closeNotify);
        to.writeInbound(new Object[]{cumulation});
    }

    private static String handshakenProtocol(EmbeddedChannel channel) {
        SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
        SSLSession session = sslHandler.engine().getSession();
        return session.getProtocol();
    }

    private static void discardEmptyOutboundBuffers(EmbeddedChannel channel) {
        ByteBuf buf;
        Queue outbound = channel.outboundMessages();
        while (outbound.peek() instanceof ByteBuf && !(buf = (ByteBuf)outbound.peek()).isReadable()) {
            buf.release();
            outbound.poll();
        }
    }

    static void assertCloseNotify(ByteBuf closeNotify) {
        MatcherAssert.assertThat((Object)closeNotify, (Matcher)Matchers.notNullValue());
        try {
            MatcherAssert.assertThat((String)"Doesn't match expected length of close_notify alert", (Object)closeNotify.readableBytes(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(7)));
        }
        finally {
            closeNotify.release();
        }
    }
}

