/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ipfilter;

import io.netty.handler.ipfilter.IpFilterRuleType;
import io.netty.handler.ipfilter.IpSubnetFilterRule;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

class IpSubnetFilterRuleTest {
    IpSubnetFilterRuleTest() {
    }

    @Test
    void createInvalidIpCidrRule() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                new IpSubnetFilterRule("192.168.0.0", IpFilterRuleType.ACCEPT);
            }
        });
    }

    @Test
    void createValidIpCidrRule() {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow((Executable)new Executable(){

            public void execute() throws Throwable {
                new IpSubnetFilterRule("192.168.0.0/24", IpFilterRuleType.ACCEPT);
            }
        });
    }

    @Test
    void validateIpAddressFromIpCidrString() {
        IpSubnetFilterRule rule = new IpSubnetFilterRule("10.10.0.0/16", IpFilterRuleType.ACCEPT);
        Assertions.assertThat((String)rule.getIpAddress()).isEqualTo("10.10.0.0");
    }
}

