/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.logging;

import io.netty.util.internal.logging.FormattingTuple;
import io.netty.util.internal.logging.MessageFormatter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MessageFormatterTest {
    @Test
    public void testNull() {
        String result = MessageFormatter.format(null, (Object)1).getMessage();
        Assertions.assertNull((Object)result);
    }

    @Test
    public void nullParametersShouldBeHandledWithoutBarfing() {
        String result = MessageFormatter.format((String)"Value is {}.", null).getMessage();
        Assertions.assertEquals((Object)"Value is null.", (Object)result);
        result = MessageFormatter.format((String)"Val1 is {}, val2 is {}.", null, null).getMessage();
        Assertions.assertEquals((Object)"Val1 is null, val2 is null.", (Object)result);
        result = MessageFormatter.format((String)"Val1 is {}, val2 is {}.", (Object)1, null).getMessage();
        Assertions.assertEquals((Object)"Val1 is 1, val2 is null.", (Object)result);
        result = MessageFormatter.format((String)"Val1 is {}, val2 is {}.", null, (Object)2).getMessage();
        Assertions.assertEquals((Object)"Val1 is null, val2 is 2.", (Object)result);
        result = MessageFormatter.arrayFormat((String)"Val1 is {}, val2 is {}, val3 is {}", (Object[])new Integer[]{null, null, null}).getMessage();
        Assertions.assertEquals((Object)"Val1 is null, val2 is null, val3 is null", (Object)result);
        result = MessageFormatter.arrayFormat((String)"Val1 is {}, val2 is {}, val3 is {}", (Object[])new Integer[]{null, 2, 3}).getMessage();
        Assertions.assertEquals((Object)"Val1 is null, val2 is 2, val3 is 3", (Object)result);
        result = MessageFormatter.arrayFormat((String)"Val1 is {}, val2 is {}, val3 is {}", (Object[])new Integer[]{null, null, 3}).getMessage();
        Assertions.assertEquals((Object)"Val1 is null, val2 is null, val3 is 3", (Object)result);
    }

    @Test
    public void verifyOneParameterIsHandledCorrectly() {
        String result = MessageFormatter.format((String)"Value is {}.", (Object)3).getMessage();
        Assertions.assertEquals((Object)"Value is 3.", (Object)result);
        result = MessageFormatter.format((String)"Value is {", (Object)3).getMessage();
        Assertions.assertEquals((Object)"Value is {", (Object)result);
        result = MessageFormatter.format((String)"{} is larger than 2.", (Object)3).getMessage();
        Assertions.assertEquals((Object)"3 is larger than 2.", (Object)result);
        result = MessageFormatter.format((String)"No subst", (Object)3).getMessage();
        Assertions.assertEquals((Object)"No subst", (Object)result);
        result = MessageFormatter.format((String)"Incorrect {subst", (Object)3).getMessage();
        Assertions.assertEquals((Object)"Incorrect {subst", (Object)result);
        result = MessageFormatter.format((String)"Value is {bla} {}", (Object)3).getMessage();
        Assertions.assertEquals((Object)"Value is {bla} 3", (Object)result);
        result = MessageFormatter.format((String)"Escaped \\{} subst", (Object)3).getMessage();
        Assertions.assertEquals((Object)"Escaped {} subst", (Object)result);
        result = MessageFormatter.format((String)"{Escaped", (Object)3).getMessage();
        Assertions.assertEquals((Object)"{Escaped", (Object)result);
        result = MessageFormatter.format((String)"\\{}Escaped", (Object)3).getMessage();
        Assertions.assertEquals((Object)"{}Escaped", (Object)result);
        result = MessageFormatter.format((String)"File name is {{}}.", (Object)"App folder.zip").getMessage();
        Assertions.assertEquals((Object)"File name is {App folder.zip}.", (Object)result);
        result = MessageFormatter.format((String)"File name is C:\\\\{}.", (Object)"App folder.zip").getMessage();
        Assertions.assertEquals((Object)"File name is C:\\App folder.zip.", (Object)result);
    }

    @Test
    public void testTwoParameters() {
        String result = MessageFormatter.format((String)"Value {} is smaller than {}.", (Object)1, (Object)2).getMessage();
        Assertions.assertEquals((Object)"Value 1 is smaller than 2.", (Object)result);
        result = MessageFormatter.format((String)"Value {} is smaller than {}", (Object)1, (Object)2).getMessage();
        Assertions.assertEquals((Object)"Value 1 is smaller than 2", (Object)result);
        result = MessageFormatter.format((String)"{}{}", (Object)1, (Object)2).getMessage();
        Assertions.assertEquals((Object)"12", (Object)result);
        result = MessageFormatter.format((String)"Val1={}, Val2={", (Object)1, (Object)2).getMessage();
        Assertions.assertEquals((Object)"Val1=1, Val2={", (Object)result);
        result = MessageFormatter.format((String)"Value {} is smaller than \\{}", (Object)1, (Object)2).getMessage();
        Assertions.assertEquals((Object)"Value 1 is smaller than {}", (Object)result);
        result = MessageFormatter.format((String)"Value {} is smaller than \\{} tail", (Object)1, (Object)2).getMessage();
        Assertions.assertEquals((Object)"Value 1 is smaller than {} tail", (Object)result);
        result = MessageFormatter.format((String)"Value {} is smaller than \\{", (Object)1, (Object)2).getMessage();
        Assertions.assertEquals((Object)"Value 1 is smaller than \\{", (Object)result);
        result = MessageFormatter.format((String)"Value {} is smaller than {tail", (Object)1, (Object)2).getMessage();
        Assertions.assertEquals((Object)"Value 1 is smaller than {tail", (Object)result);
        result = MessageFormatter.format((String)"Value \\{} is smaller than {}", (Object)1, (Object)2).getMessage();
        Assertions.assertEquals((Object)"Value {} is smaller than 1", (Object)result);
    }

    @Test
    public void testExceptionIn_toString() {
        Object o = new Object(){

            public String toString() {
                throw new IllegalStateException("a");
            }
        };
        String result = MessageFormatter.format((String)"Troublesome object {}", (Object)o).getMessage();
        Assertions.assertEquals((Object)"Troublesome object [FAILED toString()]", (Object)result);
    }

    @Test
    public void testNullArray() {
        String msg0 = "msg0";
        String msg1 = "msg1 {}";
        String msg2 = "msg2 {} {}";
        String msg3 = "msg3 {} {} {}";
        Object[] args = null;
        String result = MessageFormatter.arrayFormat((String)msg0, args).getMessage();
        Assertions.assertEquals((Object)msg0, (Object)result);
        result = MessageFormatter.arrayFormat((String)msg1, args).getMessage();
        Assertions.assertEquals((Object)msg1, (Object)result);
        result = MessageFormatter.arrayFormat((String)msg2, args).getMessage();
        Assertions.assertEquals((Object)msg2, (Object)result);
        result = MessageFormatter.arrayFormat((String)msg3, args).getMessage();
        Assertions.assertEquals((Object)msg3, (Object)result);
    }

    @Test
    public void testArrayFormat() {
        Object[] ia0 = new Integer[]{1, 2, 3};
        String result = MessageFormatter.arrayFormat((String)"Value {} is smaller than {} and {}.", (Object[])ia0).getMessage();
        Assertions.assertEquals((Object)"Value 1 is smaller than 2 and 3.", (Object)result);
        result = MessageFormatter.arrayFormat((String)"{}{}{}", (Object[])ia0).getMessage();
        Assertions.assertEquals((Object)"123", (Object)result);
        result = MessageFormatter.arrayFormat((String)"Value {} is smaller than {}.", (Object[])ia0).getMessage();
        Assertions.assertEquals((Object)"Value 1 is smaller than 2.", (Object)result);
        result = MessageFormatter.arrayFormat((String)"Value {} is smaller than {}", (Object[])ia0).getMessage();
        Assertions.assertEquals((Object)"Value 1 is smaller than 2", (Object)result);
        result = MessageFormatter.arrayFormat((String)"Val={}, {, Val={}", (Object[])ia0).getMessage();
        Assertions.assertEquals((Object)"Val=1, {, Val=2", (Object)result);
        result = MessageFormatter.arrayFormat((String)"Val={}, {, Val={}", (Object[])ia0).getMessage();
        Assertions.assertEquals((Object)"Val=1, {, Val=2", (Object)result);
        result = MessageFormatter.arrayFormat((String)"Val1={}, Val2={", (Object[])ia0).getMessage();
        Assertions.assertEquals((Object)"Val1=1, Val2={", (Object)result);
    }

    @Test
    public void testArrayValues() {
        Integer[] p1 = new Integer[]{2, 3};
        String result = MessageFormatter.format((String)"{}{}", (Object)1, (Object)p1).getMessage();
        Assertions.assertEquals((Object)"1[2, 3]", (Object)result);
        result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", p1}).getMessage();
        Assertions.assertEquals((Object)"a[2, 3]", (Object)result);
        result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", new byte[]{1, 2}}).getMessage();
        Assertions.assertEquals((Object)"a[1, 2]", (Object)result);
        result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", new int[]{1, 2}}).getMessage();
        Assertions.assertEquals((Object)"a[1, 2]", (Object)result);
        result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", new float[]{1.0f, 2.0f}}).getMessage();
        Assertions.assertEquals((Object)"a[1.0, 2.0]", (Object)result);
        result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", new double[]{1.0, 2.0}}).getMessage();
        Assertions.assertEquals((Object)"a[1.0, 2.0]", (Object)result);
    }

    @Test
    public void testMultiDimensionalArrayValues() {
        Integer[] ia0 = new Integer[]{1, 2, 3};
        Integer[] ia1 = new Integer[]{10, 20, 30};
        Integer[][] multiIntegerA = new Integer[][]{ia0, ia1};
        String result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", multiIntegerA}).getMessage();
        Assertions.assertEquals((Object)"a[[1, 2, 3], [10, 20, 30]]", (Object)result);
        int[][] multiIntA = new int[][]{{1, 2}, {10, 20}};
        result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", multiIntA}).getMessage();
        Assertions.assertEquals((Object)"a[[1, 2], [10, 20]]", (Object)result);
        float[][] multiFloatA = new float[][]{{1.0f, 2.0f}, {10.0f, 20.0f}};
        result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", multiFloatA}).getMessage();
        Assertions.assertEquals((Object)"a[[1.0, 2.0], [10.0, 20.0]]", (Object)result);
        Object[][] multiOA = new Object[][]{ia0, ia1};
        result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", multiOA}).getMessage();
        Assertions.assertEquals((Object)"a[[1, 2, 3], [10, 20, 30]]", (Object)result);
        Object[][][] _3DOA = new Object[][][]{multiOA, multiOA};
        result = MessageFormatter.arrayFormat((String)"{}{}", (Object[])new Object[]{"a", _3DOA}).getMessage();
        Assertions.assertEquals((Object)"a[[[1, 2, 3], [10, 20, 30]], [[1, 2, 3], [10, 20, 30]]]", (Object)result);
        Byte[] ba0 = new Byte[]{(byte)0, (byte)127, (byte)-128};
        Short[] sa0 = new Short[]{(short)0, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE};
        result = MessageFormatter.arrayFormat((String)"{}\\{}{}", (Object[])new Object[]{new Object[]{ba0, sa0}, ia1}).getMessage();
        Assertions.assertEquals((Object)"[[0, 127, -128], [0, -32768, 32767]]{}[10, 20, 30]", (Object)result);
    }

    @Test
    public void testCyclicArrays() {
        Object[] b;
        Object[] cyclicA;
        cyclicA[0] = cyclicA = new Object[1];
        Assertions.assertEquals((Object)"[[...]]", (Object)MessageFormatter.arrayFormat((String)"{}", (Object[])cyclicA).getMessage());
        Object[] a = new Object[2];
        a[0] = 1;
        Object[] c = new Object[]{3, a};
        a[1] = b = new Object[]{2, c};
        Assertions.assertEquals((Object)"1[2, [3, [1, [...]]]]", (Object)MessageFormatter.arrayFormat((String)"{}{}", (Object[])a).getMessage());
    }

    @Test
    public void testArrayThrowable() {
        Throwable t = new Throwable();
        Object[] ia = new Object[]{1, 2, 3, t};
        FormattingTuple ft = MessageFormatter.arrayFormat((String)"Value {} is smaller than {} and {}.", (Object[])ia);
        Assertions.assertEquals((Object)"Value 1 is smaller than 2 and 3.", (Object)ft.getMessage());
        Assertions.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"{}{}{}", (Object[])ia);
        Assertions.assertEquals((Object)"123", (Object)ft.getMessage());
        Assertions.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"Value {} is smaller than {}.", (Object[])ia);
        Assertions.assertEquals((Object)"Value 1 is smaller than 2.", (Object)ft.getMessage());
        Assertions.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"Value {} is smaller than {}", (Object[])ia);
        Assertions.assertEquals((Object)"Value 1 is smaller than 2", (Object)ft.getMessage());
        Assertions.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"Val={}, {, Val={}", (Object[])ia);
        Assertions.assertEquals((Object)"Val=1, {, Val=2", (Object)ft.getMessage());
        Assertions.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"Val={}, \\{, Val={}", (Object[])ia);
        Assertions.assertEquals((Object)"Val=1, \\{, Val=2", (Object)ft.getMessage());
        Assertions.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"Val1={}, Val2={", (Object[])ia);
        Assertions.assertEquals((Object)"Val1=1, Val2={", (Object)ft.getMessage());
        Assertions.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"Value {} is smaller than {} and {}.", (Object[])ia);
        Assertions.assertEquals((Object)"Value 1 is smaller than 2 and 3.", (Object)ft.getMessage());
        Assertions.assertEquals((Object)t, (Object)ft.getThrowable());
        ft = MessageFormatter.arrayFormat((String)"{}{}{}{}", (Object[])ia);
        Assertions.assertEquals((Object)"123java.lang.Throwable", (Object)ft.getMessage());
        Assertions.assertNull((Object)ft.getThrowable());
    }
}

