/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.ImmediateExecutor;
import java.util.concurrent.FutureTask;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class ImmediateExecutorTest {
    @Test
    public void testExecuteNullRunnable() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                ImmediateExecutor.INSTANCE.execute(null);
            }
        });
    }

    @Test
    public void testExecuteNonNullRunnable() throws Exception {
        FutureTask<Object> task = new FutureTask<Object>(new Runnable(){

            @Override
            public void run() {
            }
        }, null);
        ImmediateExecutor.INSTANCE.execute(task);
        Assertions.assertTrue((boolean)task.isDone());
        Assertions.assertFalse((boolean)task.isCancelled());
        Assertions.assertNull(task.get());
    }
}

