/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AsciiStringMemoryTest {
    private byte[] a;
    private byte[] b;
    private int aOffset = 22;
    private int bOffset = 53;
    private int length = 100;
    private AsciiString aAsciiString;
    private AsciiString bAsciiString;
    private final Random r = new Random();

    @BeforeEach
    public void setup() {
        this.a = new byte[128];
        this.b = new byte[256];
        this.r.nextBytes(this.a);
        this.r.nextBytes(this.b);
        this.aOffset = 22;
        this.bOffset = 53;
        this.length = 100;
        System.arraycopy(this.a, this.aOffset, this.b, this.bOffset, this.length);
        this.aAsciiString = new AsciiString(this.a, this.aOffset, this.length, false);
        this.bAsciiString = new AsciiString(this.b, this.bOffset, this.length, false);
    }

    @Test
    public void testSharedMemory() {
        int n = this.aOffset;
        this.a[n] = (byte)(this.a[n] + 1);
        AsciiString aAsciiString1 = new AsciiString(this.a, this.aOffset, this.length, true);
        AsciiString aAsciiString2 = new AsciiString(this.a, this.aOffset, this.length, false);
        Assertions.assertEquals((Object)this.aAsciiString, (Object)aAsciiString1);
        Assertions.assertEquals((Object)this.aAsciiString, (Object)aAsciiString2);
        for (int i = this.aOffset; i < this.length; ++i) {
            Assertions.assertEquals((byte)this.a[i], (byte)this.aAsciiString.byteAt(i - this.aOffset));
        }
    }

    @Test
    public void testNotSharedMemory() {
        AsciiString aAsciiString1 = new AsciiString(this.a, this.aOffset, this.length, true);
        int n = this.aOffset;
        this.a[n] = (byte)(this.a[n] + 1);
        Assertions.assertNotEquals((Object)this.aAsciiString, (Object)aAsciiString1);
        int i = this.aOffset;
        Assertions.assertNotEquals((byte)this.a[i], (byte)aAsciiString1.byteAt(i - this.aOffset));
        ++i;
        while (i < this.length) {
            Assertions.assertEquals((byte)this.a[i], (byte)aAsciiString1.byteAt(i - this.aOffset));
            ++i;
        }
    }

    @Test
    public void forEachTest() throws Exception {
        final AtomicReference<Integer> aCount = new AtomicReference<Integer>(0);
        final AtomicReference<Integer> bCount = new AtomicReference<Integer>(0);
        this.aAsciiString.forEachByte(new ByteProcessor(){
            int i;

            public boolean process(byte value) {
                Assertions.assertEquals((byte)value, (byte)AsciiStringMemoryTest.this.bAsciiString.byteAt(this.i++), (String)("failed at index: " + this.i));
                aCount.set((Integer)aCount.get() + 1);
                return true;
            }
        });
        this.bAsciiString.forEachByte(new ByteProcessor(){
            int i;

            public boolean process(byte value) {
                Assertions.assertEquals((byte)value, (byte)AsciiStringMemoryTest.this.aAsciiString.byteAt(this.i++), (String)("failed at index: " + this.i));
                bCount.set((Integer)bCount.get() + 1);
                return true;
            }
        });
        Assertions.assertEquals((int)this.aAsciiString.length(), (int)aCount.get());
        Assertions.assertEquals((int)this.bAsciiString.length(), (int)bCount.get());
    }

    @Test
    public void forEachWithIndexEndTest() throws Exception {
        Assertions.assertNotEquals((int)-1, (int)this.aAsciiString.forEachByte(this.aAsciiString.length() - 1, 1, (ByteProcessor)new ByteProcessor.IndexOfProcessor(this.aAsciiString.byteAt(this.aAsciiString.length() - 1))));
    }

    @Test
    public void forEachWithIndexBeginTest() throws Exception {
        Assertions.assertNotEquals((int)-1, (int)this.aAsciiString.forEachByte(0, 1, (ByteProcessor)new ByteProcessor.IndexOfProcessor(this.aAsciiString.byteAt(0))));
    }

    @Test
    public void forEachDescTest() throws Exception {
        final AtomicReference<Integer> aCount = new AtomicReference<Integer>(0);
        final AtomicReference<Integer> bCount = new AtomicReference<Integer>(0);
        this.aAsciiString.forEachByteDesc(new ByteProcessor(){
            int i = 1;

            public boolean process(byte value) {
                Assertions.assertEquals((byte)value, (byte)AsciiStringMemoryTest.this.bAsciiString.byteAt(AsciiStringMemoryTest.this.bAsciiString.length() - this.i++), (String)("failed at index: " + this.i));
                aCount.set((Integer)aCount.get() + 1);
                return true;
            }
        });
        this.bAsciiString.forEachByteDesc(new ByteProcessor(){
            int i = 1;

            public boolean process(byte value) {
                Assertions.assertEquals((byte)value, (byte)AsciiStringMemoryTest.this.aAsciiString.byteAt(AsciiStringMemoryTest.this.aAsciiString.length() - this.i++), (String)("failed at index: " + this.i));
                bCount.set((Integer)bCount.get() + 1);
                return true;
            }
        });
        Assertions.assertEquals((int)this.aAsciiString.length(), (int)aCount.get());
        Assertions.assertEquals((int)this.bAsciiString.length(), (int)bCount.get());
    }

    @Test
    public void forEachDescWithIndexEndTest() throws Exception {
        Assertions.assertNotEquals((int)-1, (int)this.bAsciiString.forEachByteDesc(this.bAsciiString.length() - 1, 1, (ByteProcessor)new ByteProcessor.IndexOfProcessor(this.bAsciiString.byteAt(this.bAsciiString.length() - 1))));
    }

    @Test
    public void forEachDescWithIndexBeginTest() throws Exception {
        Assertions.assertNotEquals((int)-1, (int)this.bAsciiString.forEachByteDesc(0, 1, (ByteProcessor)new ByteProcessor.IndexOfProcessor(this.bAsciiString.byteAt(0))));
    }

    @Test
    public void subSequenceTest() {
        int start = 12;
        int end = this.aAsciiString.length();
        AsciiString aSubSequence = this.aAsciiString.subSequence(12, end, false);
        AsciiString bSubSequence = this.bAsciiString.subSequence(12, end, true);
        Assertions.assertEquals((Object)aSubSequence, (Object)bSubSequence);
        Assertions.assertEquals((int)aSubSequence.hashCode(), (int)bSubSequence.hashCode());
    }

    @Test
    public void copyTest() {
        byte[] aCopy = new byte[this.aAsciiString.length()];
        this.aAsciiString.copy(0, aCopy, 0, aCopy.length);
        AsciiString aAsciiStringCopy = new AsciiString(aCopy, false);
        Assertions.assertEquals((Object)this.aAsciiString, (Object)aAsciiStringCopy);
    }
}

