/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateDecoder;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateDecoder;
import io.netty.util.CharsetUtil;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class PerMessageDeflateDecoderTest {
    private static final Random random = new Random();

    @Test
    public void testCompressedFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)9, (int)15, (int)8)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateDecoder(false, 0)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])payload)}));
        ByteBuf compressedPayload = (ByteBuf)encoderChannel.readOutbound();
        BinaryWebSocketFrame compressedFrame = new BinaryWebSocketFrame(true, 5, compressedPayload.slice(0, compressedPayload.readableBytes() - 4));
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame}));
        BinaryWebSocketFrame uncompressedFrame = (BinaryWebSocketFrame)decoderChannel.readInbound();
        Assertions.assertNotNull((Object)uncompressedFrame);
        Assertions.assertNotNull((Object)uncompressedFrame.content());
        Assertions.assertEquals((int)1, (int)uncompressedFrame.rsv());
        Assertions.assertEquals((int)300, (int)uncompressedFrame.content().readableBytes());
        byte[] finalPayload = new byte[300];
        uncompressedFrame.content().readBytes(finalPayload);
        Assertions.assertArrayEquals((byte[])finalPayload, (byte[])payload);
        uncompressedFrame.release();
    }

    @Test
    public void testNormalFrame() {
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateDecoder(false, 0)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(true, 1, Unpooled.wrappedBuffer((byte[])payload));
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{frame}));
        BinaryWebSocketFrame newFrame = (BinaryWebSocketFrame)decoderChannel.readInbound();
        Assertions.assertNotNull((Object)newFrame);
        Assertions.assertNotNull((Object)newFrame.content());
        Assertions.assertEquals((int)1, (int)newFrame.rsv());
        Assertions.assertEquals((int)300, (int)newFrame.content().readableBytes());
        byte[] finalPayload = new byte[300];
        newFrame.content().readBytes(finalPayload);
        Assertions.assertArrayEquals((byte[])finalPayload, (byte[])payload);
        newFrame.release();
    }

    @Test
    public void testFragmentedFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)9, (int)15, (int)8)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateDecoder(false, 0)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])payload)}));
        ByteBuf compressedPayload = (ByteBuf)encoderChannel.readOutbound();
        compressedPayload = compressedPayload.slice(0, compressedPayload.readableBytes() - 4);
        int oneThird = compressedPayload.readableBytes() / 3;
        BinaryWebSocketFrame compressedFrame1 = new BinaryWebSocketFrame(false, 5, compressedPayload.slice(0, oneThird));
        ContinuationWebSocketFrame compressedFrame2 = new ContinuationWebSocketFrame(false, 1, compressedPayload.slice(oneThird, oneThird));
        ContinuationWebSocketFrame compressedFrame3 = new ContinuationWebSocketFrame(true, 1, compressedPayload.slice(oneThird * 2, compressedPayload.readableBytes() - oneThird * 2));
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame1.retain()}));
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame2.retain()}));
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame3}));
        BinaryWebSocketFrame uncompressedFrame1 = (BinaryWebSocketFrame)decoderChannel.readInbound();
        ContinuationWebSocketFrame uncompressedFrame2 = (ContinuationWebSocketFrame)decoderChannel.readInbound();
        ContinuationWebSocketFrame uncompressedFrame3 = (ContinuationWebSocketFrame)decoderChannel.readInbound();
        Assertions.assertNotNull((Object)uncompressedFrame1);
        Assertions.assertNotNull((Object)uncompressedFrame2);
        Assertions.assertNotNull((Object)uncompressedFrame3);
        Assertions.assertEquals((int)1, (int)uncompressedFrame1.rsv());
        Assertions.assertEquals((int)1, (int)uncompressedFrame2.rsv());
        Assertions.assertEquals((int)1, (int)uncompressedFrame3.rsv());
        ByteBuf finalPayloadWrapped = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{uncompressedFrame1.content(), uncompressedFrame2.content(), uncompressedFrame3.content()});
        Assertions.assertEquals((int)300, (int)finalPayloadWrapped.readableBytes());
        byte[] finalPayload = new byte[300];
        finalPayloadWrapped.readBytes(finalPayload);
        Assertions.assertArrayEquals((byte[])finalPayload, (byte[])payload);
        finalPayloadWrapped.release();
    }

    @Test
    public void testMultiCompressedPayloadWithinFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)9, (int)15, (int)8)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateDecoder(false, 0)});
        byte[] payload1 = new byte[100];
        random.nextBytes(payload1);
        byte[] payload2 = new byte[100];
        random.nextBytes(payload2);
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])payload1)}));
        ByteBuf compressedPayload1 = (ByteBuf)encoderChannel.readOutbound();
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])payload2)}));
        ByteBuf compressedPayload2 = (ByteBuf)encoderChannel.readOutbound();
        BinaryWebSocketFrame compressedFrame = new BinaryWebSocketFrame(true, 5, Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{compressedPayload1, compressedPayload2.slice(0, compressedPayload2.readableBytes() - 4)}));
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame}));
        BinaryWebSocketFrame uncompressedFrame = (BinaryWebSocketFrame)decoderChannel.readInbound();
        Assertions.assertNotNull((Object)uncompressedFrame);
        Assertions.assertNotNull((Object)uncompressedFrame.content());
        Assertions.assertEquals((int)1, (int)uncompressedFrame.rsv());
        Assertions.assertEquals((int)200, (int)uncompressedFrame.content().readableBytes());
        byte[] finalPayload1 = new byte[100];
        uncompressedFrame.content().readBytes(finalPayload1);
        Assertions.assertArrayEquals((byte[])finalPayload1, (byte[])payload1);
        byte[] finalPayload2 = new byte[100];
        uncompressedFrame.content().readBytes(finalPayload2);
        Assertions.assertArrayEquals((byte[])finalPayload2, (byte[])payload2);
        uncompressedFrame.release();
    }

    @Test
    public void testDecompressionSkipForBinaryFrame() {
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)9, (int)15, (int)8)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateDecoder(false, WebSocketExtensionFilter.ALWAYS_SKIP, 0)});
        byte[] payload = new byte[300];
        random.nextBytes(payload);
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])payload)}));
        ByteBuf compressedPayload = (ByteBuf)encoderChannel.readOutbound();
        BinaryWebSocketFrame compressedBinaryFrame = new BinaryWebSocketFrame(true, 4, compressedPayload);
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedBinaryFrame}));
        WebSocketFrame inboundFrame = (WebSocketFrame)decoderChannel.readInbound();
        Assertions.assertEquals((int)4, (int)inboundFrame.rsv());
        Assertions.assertEquals((Object)compressedPayload, (Object)inboundFrame.content());
        Assertions.assertTrue((boolean)inboundFrame.release());
        Assertions.assertTrue((boolean)encoderChannel.finishAndReleaseAll());
        Assertions.assertFalse((boolean)decoderChannel.finish());
    }

    @Test
    public void testSelectivityDecompressionSkip() {
        WebSocketExtensionFilter selectivityDecompressionFilter = new WebSocketExtensionFilter(){

            public boolean mustSkip(WebSocketFrame frame) {
                return frame instanceof TextWebSocketFrame && frame.content().readableBytes() < 100;
            }
        };
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)9, (int)15, (int)8)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateDecoder(false, selectivityDecompressionFilter, 0)});
        String textPayload = "compressed payload";
        byte[] binaryPayload = new byte[300];
        random.nextBytes(binaryPayload);
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])textPayload.getBytes(CharsetUtil.UTF_8))}));
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])binaryPayload)}));
        ByteBuf compressedTextPayload = (ByteBuf)encoderChannel.readOutbound();
        ByteBuf compressedBinaryPayload = (ByteBuf)encoderChannel.readOutbound();
        TextWebSocketFrame compressedTextFrame = new TextWebSocketFrame(true, 4, compressedTextPayload);
        BinaryWebSocketFrame compressedBinaryFrame = new BinaryWebSocketFrame(true, 4, compressedBinaryPayload);
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedTextFrame}));
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedBinaryFrame}));
        TextWebSocketFrame inboundTextFrame = (TextWebSocketFrame)decoderChannel.readInbound();
        BinaryWebSocketFrame inboundBinaryFrame = (BinaryWebSocketFrame)decoderChannel.readInbound();
        Assertions.assertEquals((int)4, (int)inboundTextFrame.rsv());
        Assertions.assertEquals((Object)compressedTextPayload, (Object)inboundTextFrame.content());
        Assertions.assertTrue((boolean)inboundTextFrame.release());
        Assertions.assertEquals((int)0, (int)inboundBinaryFrame.rsv());
        Assertions.assertArrayEquals((byte[])binaryPayload, (byte[])ByteBufUtil.getBytes((ByteBuf)inboundBinaryFrame.content()));
        Assertions.assertTrue((boolean)inboundBinaryFrame.release());
        Assertions.assertTrue((boolean)encoderChannel.finishAndReleaseAll());
        Assertions.assertFalse((boolean)decoderChannel.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIllegalStateWhenDecompressionInProgress() {
        WebSocketExtensionFilter selectivityDecompressionFilter = new WebSocketExtensionFilter(){

            public boolean mustSkip(WebSocketFrame frame) {
                return frame.content().readableBytes() < 100;
            }
        };
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)9, (int)15, (int)8)});
        final EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateDecoder(false, selectivityDecompressionFilter, 0)});
        byte[] firstPayload = new byte[200];
        random.nextBytes(firstPayload);
        byte[] finalPayload = new byte[50];
        random.nextBytes(finalPayload);
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])firstPayload)}));
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])finalPayload)}));
        ByteBuf compressedFirstPayload = (ByteBuf)encoderChannel.readOutbound();
        ByteBuf compressedFinalPayload = (ByteBuf)encoderChannel.readOutbound();
        Assertions.assertTrue((boolean)encoderChannel.finishAndReleaseAll());
        BinaryWebSocketFrame firstPart = new BinaryWebSocketFrame(false, 4, compressedFirstPayload);
        final ContinuationWebSocketFrame finalPart = new ContinuationWebSocketFrame(true, 4, compressedFinalPayload);
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{firstPart}));
        BinaryWebSocketFrame outboundFirstPart = (BinaryWebSocketFrame)decoderChannel.readInbound();
        Assertions.assertEquals((int)0, (int)outboundFirstPart.rsv());
        Assertions.assertArrayEquals((byte[])firstPayload, (byte[])ByteBufUtil.getBytes((ByteBuf)outboundFirstPart.content()));
        Assertions.assertTrue((boolean)outboundFirstPart.release());
        try {
            Assertions.assertThrows(DecoderException.class, (Executable)new Executable(){

                public void execute() {
                    decoderChannel.writeInbound(new Object[]{finalPart});
                }
            });
        }
        finally {
            Assertions.assertTrue((boolean)finalPart.release());
            Assertions.assertFalse((boolean)encoderChannel.finishAndReleaseAll());
        }
    }

    @Test
    public void testEmptyFrameDecompression() {
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateDecoder(false, 0)});
        TextWebSocketFrame emptyDeflateBlockFrame = new TextWebSocketFrame(true, 4, DeflateDecoder.EMPTY_DEFLATE_BLOCK);
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{emptyDeflateBlockFrame}));
        TextWebSocketFrame emptyBufferFrame = (TextWebSocketFrame)decoderChannel.readInbound();
        Assertions.assertFalse((boolean)emptyBufferFrame.content().isReadable());
        Assertions.assertTrue((boolean)emptyBufferFrame.release());
        Assertions.assertFalse((boolean)decoderChannel.finish());
    }

    @Test
    public void testFragmentedFrameWithLeftOverInLastFragment() {
        String hexDump = "677170647a777a737574656b707a787a6f6a7561756578756f6b7868616371716c657a6d64697479766d726f6269746c6376777464776f6f72767a726f64667278676764687775786f6762766d776d706b76697773777a70726a6a737279707a7078697a6c69616d7461656d646278626d786f66666e686e776a7a7461746d7a776668776b6f6f736e73746575637a6d727a7175707a6e74627578687871767771697a71766c64626d78726d6d767575687762667963626b687a726d676e646263776e67797264706d6c6863626577616967706a78636a72697464756e627977616f79736475676f76736f7178746a7a7479626c64636b6b6778637768746c62";
        EmbeddedChannel encoderChannel = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.NONE, (int)9, (int)15, (int)8)});
        EmbeddedChannel decoderChannel = new EmbeddedChannel(new ChannelHandler[]{new PerMessageDeflateDecoder(false, 0)});
        ByteBuf originPayload = Unpooled.wrappedBuffer((byte[])ByteBufUtil.decodeHexDump((CharSequence)hexDump));
        Assertions.assertTrue((boolean)encoderChannel.writeOutbound(new Object[]{originPayload.duplicate().retain()}));
        ByteBuf compressedPayload = (ByteBuf)encoderChannel.readOutbound();
        compressedPayload = compressedPayload.slice(0, compressedPayload.readableBytes() - 4);
        int oneThird = compressedPayload.readableBytes() / 3;
        TextWebSocketFrame compressedFrame1 = new TextWebSocketFrame(false, 4, compressedPayload.slice(0, oneThird));
        ContinuationWebSocketFrame compressedFrame2 = new ContinuationWebSocketFrame(false, 1, compressedPayload.slice(oneThird, oneThird));
        ContinuationWebSocketFrame compressedFrame3 = new ContinuationWebSocketFrame(false, 1, compressedPayload.slice(oneThird * 2, oneThird));
        int offset = oneThird * 3;
        ContinuationWebSocketFrame compressedFrameWithExtraData = new ContinuationWebSocketFrame(true, 1, compressedPayload.slice(offset, compressedPayload.readableBytes() - offset));
        Assertions.assertEquals((int)1, (int)compressedFrameWithExtraData.content().readableBytes());
        Assertions.assertEquals((int)1, (int)compressedFrameWithExtraData.content().getByte(0));
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame1.retain()}));
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame2.retain()}));
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrame3.retain()}));
        Assertions.assertTrue((boolean)decoderChannel.writeInbound(new Object[]{compressedFrameWithExtraData}));
        TextWebSocketFrame uncompressedFrame1 = (TextWebSocketFrame)decoderChannel.readInbound();
        ContinuationWebSocketFrame uncompressedFrame2 = (ContinuationWebSocketFrame)decoderChannel.readInbound();
        ContinuationWebSocketFrame uncompressedFrame3 = (ContinuationWebSocketFrame)decoderChannel.readInbound();
        ContinuationWebSocketFrame uncompressedExtraData = (ContinuationWebSocketFrame)decoderChannel.readInbound();
        Assertions.assertFalse((boolean)uncompressedExtraData.content().isReadable());
        ByteBuf uncompressedPayload = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{uncompressedFrame1.content(), uncompressedFrame2.content(), uncompressedFrame3.content(), uncompressedExtraData.content()});
        Assertions.assertEquals((Object)originPayload, (Object)uncompressedPayload);
        Assertions.assertTrue((boolean)originPayload.release());
        Assertions.assertTrue((boolean)uncompressedPayload.release());
        Assertions.assertTrue((boolean)encoderChannel.finishAndReleaseAll());
        Assertions.assertFalse((boolean)decoderChannel.finish());
    }
}

