/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CorruptedWebSocketFrameException;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.Utf8FrameValidator;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class WebSocketUtf8FrameValidatorTest {
    @Test
    public void testCorruptedFrameExceptionInFinish() {
        this.assertCorruptedFrameExceptionHandling(new byte[]{-50});
    }

    @Test
    public void testCorruptedFrameExceptionInCheck() {
        this.assertCorruptedFrameExceptionHandling(new byte[]{-8, -120, -128, -128, -128});
    }

    @Test
    void testNotCloseOnProtocolViolation() {
        final EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new Utf8FrameValidator(false)});
        final TextWebSocketFrame frame = new TextWebSocketFrame(Unpooled.copiedBuffer((byte[])new byte[]{-50}));
        Assertions.assertThrows(CorruptedWebSocketFrameException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                channel.writeInbound(new Object[]{frame});
            }
        }, (String)"bytes are not UTF-8");
        Assertions.assertTrue((boolean)channel.isActive());
        Assertions.assertFalse((boolean)channel.finish());
        Assertions.assertEquals((int)0, (int)frame.refCnt());
    }

    private void assertCorruptedFrameExceptionHandling(byte[] data) {
        final EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new Utf8FrameValidator()});
        final TextWebSocketFrame frame = new TextWebSocketFrame(Unpooled.copiedBuffer((byte[])data));
        Assertions.assertThrows(CorruptedWebSocketFrameException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                channel.writeInbound(new Object[]{frame});
            }
        }, (String)"bytes are not UTF-8");
        Assertions.assertFalse((boolean)channel.isActive());
        CloseWebSocketFrame closeFrame = (CloseWebSocketFrame)channel.readOutbound();
        Assertions.assertNotNull((Object)closeFrame);
        Assertions.assertEquals((Object)"bytes are not UTF-8", (Object)closeFrame.reasonText());
        Assertions.assertEquals((int)1007, (int)closeFrame.statusCode());
        Assertions.assertTrue((boolean)closeFrame.release());
        Assertions.assertEquals((int)0, (int)frame.refCnt());
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    void testCloseWithStatusInTheMiddleOfFragmentAllowed() {
        WebSocketUtf8FrameValidatorTest.testControlFrameInTheMiddleOfFragmentAllowed((WebSocketFrame)new CloseWebSocketFrame(WebSocketCloseStatus.NORMAL_CLOSURE));
    }

    @Test
    void testPingInTheMiddleOfFragmentAllowed() {
        WebSocketUtf8FrameValidatorTest.testControlFrameInTheMiddleOfFragmentAllowed((WebSocketFrame)new PingWebSocketFrame(Unpooled.EMPTY_BUFFER));
    }

    @Test
    void testPongInTheMiddleOfFragmentAllowed() {
        WebSocketUtf8FrameValidatorTest.testControlFrameInTheMiddleOfFragmentAllowed((WebSocketFrame)new PongWebSocketFrame(Unpooled.EMPTY_BUFFER));
    }

    private static void testControlFrameInTheMiddleOfFragmentAllowed(WebSocketFrame controlFrame) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new Utf8FrameValidator(false)});
        TextWebSocketFrame frame = new TextWebSocketFrame(false, 0, "text");
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{frame}));
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{controlFrame}));
        Assertions.assertTrue((boolean)channel.finishAndReleaseAll());
    }
}

