/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CorruptedWebSocketFrameException;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker13;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerTest;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class WebSocketServerHandshaker13Test
extends WebSocketServerHandshakerTest {
    @Override
    protected WebSocketServerHandshaker newHandshaker(String webSocketURL, String subprotocols, WebSocketDecoderConfig decoderConfig) {
        return new WebSocketServerHandshaker13(webSocketURL, subprotocols, decoderConfig);
    }

    @Override
    protected WebSocketVersion webSocketVersion() {
        return WebSocketVersion.V13;
    }

    @Test
    public void testPerformOpeningHandshake() {
        WebSocketServerHandshaker13Test.testPerformOpeningHandshake0(true);
    }

    @Test
    public void testPerformOpeningHandshakeSubProtocolNotSupported() {
        WebSocketServerHandshaker13Test.testPerformOpeningHandshake0(false);
    }

    private static void testPerformOpeningHandshake0(boolean subProtocol) {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpObjectAggregator(42), new HttpResponseEncoder(), new HttpRequestDecoder()});
        if (subProtocol) {
            WebSocketServerHandshaker13Test.testUpgrade0(ch, new WebSocketServerHandshaker13("ws://example.com/chat", "chat", false, Integer.MAX_VALUE, false));
        } else {
            WebSocketServerHandshaker13Test.testUpgrade0(ch, new WebSocketServerHandshaker13("ws://example.com/chat", null, false, Integer.MAX_VALUE, false));
        }
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testCloseReasonWithEncoderAndDecoder() {
        WebSocketServerHandshaker13Test.testCloseReason0(new ChannelHandler[]{new HttpResponseEncoder(), new HttpRequestDecoder()});
    }

    @Test
    public void testCloseReasonWithCodec() {
        WebSocketServerHandshaker13Test.testCloseReason0(new ChannelHandler[]{new HttpServerCodec()});
    }

    @Test
    public void testHandshakeExceptionWhenConnectionHeaderIsAbsent() {
        final WebSocketServerHandshaker serverHandshaker = this.newHandshaker("ws://example.com/chat", "chat", WebSocketDecoderConfig.DEFAULT);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "ws://example.com/chat");
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)"server.example.com").set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (Object)"dGhlIHNhbXBsZSBub25jZQ==").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, (Object)"http://example.com").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)"chat, superchat").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)"13");
        Throwable exception = Assertions.assertThrows(WebSocketServerHandshakeException.class, (Executable)new Executable((FullHttpRequest)request){
            final /* synthetic */ FullHttpRequest val$request;
            {
                this.val$request = fullHttpRequest;
            }

            public void execute() throws Throwable {
                serverHandshaker.handshake(null, this.val$request, null, null);
            }
        });
        Assertions.assertEquals((Object)"not a WebSocket request: a |Connection| header must includes a token 'Upgrade'", (Object)exception.getMessage());
        Assertions.assertTrue((boolean)request.release());
    }

    @Test
    public void testHandshakeExceptionWhenInvalidConnectionHeader() {
        final WebSocketServerHandshaker serverHandshaker = this.newHandshaker("ws://example.com/chat", "chat", WebSocketDecoderConfig.DEFAULT);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "ws://example.com/chat");
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)"server.example.com").set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close").set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (Object)"dGhlIHNhbXBsZSBub25jZQ==").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, (Object)"http://example.com").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)"chat, superchat").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)"13");
        Throwable exception = Assertions.assertThrows(WebSocketServerHandshakeException.class, (Executable)new Executable((FullHttpRequest)request){
            final /* synthetic */ FullHttpRequest val$request;
            {
                this.val$request = fullHttpRequest;
            }

            public void execute() throws Throwable {
                serverHandshaker.handshake(null, this.val$request, null, null);
            }
        });
        Assertions.assertEquals((Object)"not a WebSocket request: a |Connection| header must includes a token 'Upgrade'", (Object)exception.getMessage());
        Assertions.assertTrue((boolean)request.release());
    }

    @Test
    public void testHandshakeExceptionWhenInvalidUpgradeHeader() {
        final WebSocketServerHandshaker serverHandshaker = this.newHandshaker("ws://example.com/chat", "chat", WebSocketDecoderConfig.DEFAULT);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "ws://example.com/chat");
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)"server.example.com").set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.UPGRADE, (Object)"my_websocket").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (Object)"dGhlIHNhbXBsZSBub25jZQ==").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, (Object)"http://example.com").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)"chat, superchat").set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)"13");
        Throwable exception = Assertions.assertThrows(WebSocketServerHandshakeException.class, (Executable)new Executable((FullHttpRequest)request){
            final /* synthetic */ FullHttpRequest val$request;
            {
                this.val$request = fullHttpRequest;
            }

            public void execute() throws Throwable {
                serverHandshaker.handshake(null, this.val$request, null, null);
            }
        });
        Assertions.assertEquals((Object)"not a WebSocket request: a |Upgrade| header must containing the value 'websocket'", (Object)exception.getMessage());
        Assertions.assertTrue((boolean)request.release());
    }

    private static void testCloseReason0(ChannelHandler ... handlers) {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpObjectAggregator(42)});
        ch.pipeline().addLast(handlers);
        WebSocketServerHandshaker13Test.testUpgrade0(ch, new WebSocketServerHandshaker13("ws://example.com/chat", "chat", WebSocketDecoderConfig.newBuilder().maxFramePayloadLength(4).closeOnProtocolViolation(true).build()));
        ch.writeOutbound(new Object[]{new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])new byte[8]))});
        ByteBuf buffer = (ByteBuf)ch.readOutbound();
        try {
            ch.writeInbound(new Object[]{buffer});
            Assertions.fail();
        }
        catch (CorruptedWebSocketFrameException corruptedWebSocketFrameException) {
            // empty catch block
        }
        ReferenceCounted closeMessage = (ReferenceCounted)ch.readOutbound();
        Assertions.assertInstanceOf(ByteBuf.class, (Object)closeMessage);
        closeMessage.release();
        Assertions.assertFalse((boolean)ch.finish());
    }

    private static void testUpgrade0(EmbeddedChannel ch, WebSocketServerHandshaker13 handshaker) {
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/chat");
        req.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)"server.example.com");
        req.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET);
        req.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"Upgrade");
        req.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (Object)"dGhlIHNhbXBsZSBub25jZQ==");
        req.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, (Object)"http://example.com");
        req.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)"chat, superchat");
        req.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)"13");
        handshaker.handshake((Channel)ch, (FullHttpRequest)req);
        ByteBuf resBuf = (ByteBuf)ch.readOutbound();
        EmbeddedChannel ch2 = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch2.writeInbound(new Object[]{resBuf});
        HttpResponse res = (HttpResponse)ch2.readInbound();
        Assertions.assertEquals((Object)"s3pPLMBiTxaQ9kYGzzhZRbK+xOo=", (Object)res.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT));
        Iterator subProtocols = handshaker.subprotocols().iterator();
        if (subProtocols.hasNext()) {
            Assertions.assertEquals(subProtocols.next(), (Object)res.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL));
        } else {
            Assertions.assertNull((Object)res.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL));
        }
        ReferenceCountUtil.release((Object)res);
        req.release();
    }
}

