/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.multipart.MixedAttribute;
import io.netty.handler.codec.http.multipart.MixedFileUpload;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MixedTest {
    @Test
    public void mixedAttributeRefCnt() throws IOException {
        MixedAttribute attribute = new MixedAttribute("foo", 100L);
        Assertions.assertEquals((int)1, (int)attribute.refCnt());
        attribute.retain();
        Assertions.assertEquals((int)2, (int)attribute.refCnt());
        attribute.addContent(Unpooled.wrappedBuffer((byte[])new byte[90]), false);
        Assertions.assertEquals((int)2, (int)attribute.refCnt());
        attribute.addContent(Unpooled.wrappedBuffer((byte[])new byte[90]), true);
        Assertions.assertEquals((int)2, (int)attribute.refCnt());
        attribute.release(2);
    }

    @Test
    public void mixedFileUploadRefCnt() throws IOException {
        MixedFileUpload upload = new MixedFileUpload("foo", "foo", "foo", "UTF-8", CharsetUtil.UTF_8, 0L, 100L);
        Assertions.assertEquals((int)1, (int)upload.refCnt());
        upload.retain();
        Assertions.assertEquals((int)2, (int)upload.refCnt());
        upload.addContent(Unpooled.wrappedBuffer((byte[])new byte[90]), false);
        Assertions.assertEquals((int)2, (int)upload.refCnt());
        upload.addContent(Unpooled.wrappedBuffer((byte[])new byte[90]), true);
        Assertions.assertEquals((int)2, (int)upload.refCnt());
        upload.release(2);
    }

    @Test
    public void testSpecificCustomBaseDir() throws IOException {
        File baseDir = new File("target/MixedTest/testSpecificCustomBaseDir");
        baseDir.mkdirs();
        MixedFileUpload upload = new MixedFileUpload("foo", "foo", "foo", "UTF-8", CharsetUtil.UTF_8, 1000L, 100L, baseDir.getAbsolutePath(), true);
        upload.addContent(Unpooled.wrappedBuffer((byte[])new byte[1000]), true);
        Assertions.assertTrue((boolean)upload.getFile().getAbsolutePath().startsWith(baseDir.getAbsolutePath()));
        Assertions.assertTrue((boolean)upload.getFile().exists());
        Assertions.assertEquals((long)1000L, (long)upload.getFile().length());
        upload.delete();
    }
}

