/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cors;

import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class CorsConfigTest {
    @Test
    public void disabled() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().disable().build();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)cors.isCorsSupportEnabled());
    }

    @Test
    public void anyOrigin() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().build();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)cors.isAnyOriginSupported());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"*", (Object)cors.origin());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)cors.origins().isEmpty());
    }

    @Test
    public void wildcardOrigin() {
        CorsConfig cors = CorsConfigBuilder.forOrigin((String)"*").build();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)cors.isAnyOriginSupported());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"*", (Object)cors.origin());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)cors.origins().isEmpty());
    }

    @Test
    public void origin() {
        CorsConfig cors = CorsConfigBuilder.forOrigin((String)"http://localhost:7888").build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://localhost:7888", (Object)cors.origin());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)cors.isAnyOriginSupported());
    }

    @Test
    public void origins() {
        Object[] origins = new String[]{"http://localhost:7888", "https://localhost:7888"};
        CorsConfig cors = CorsConfigBuilder.forOrigins((String[])origins).build();
        Assertions.assertThat((Iterable)cors.origins()).contains(origins);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)cors.isAnyOriginSupported());
    }

    @Test
    public void exposeHeaders() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().exposeHeaders(new String[]{"custom-header1", "custom-header2"}).build();
        Assertions.assertThat((Iterable)cors.exposedHeaders()).contains((Object[])new String[]{"custom-header1", "custom-header2"});
    }

    @Test
    public void allowCredentials() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().allowCredentials().build();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)cors.isCredentialsAllowed());
    }

    @Test
    public void maxAge() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().maxAge(3000L).build();
        org.junit.jupiter.api.Assertions.assertEquals((long)3000L, (long)cors.maxAge());
    }

    @Test
    public void requestMethods() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().allowedRequestMethods(new HttpMethod[]{HttpMethod.POST, HttpMethod.GET}).build();
        Assertions.assertThat((Iterable)cors.allowedRequestMethods()).contains((Object[])new HttpMethod[]{HttpMethod.POST, HttpMethod.GET});
    }

    @Test
    public void requestHeaders() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().allowedRequestHeaders(new String[]{"preflight-header1", "preflight-header2"}).build();
        Assertions.assertThat((Iterable)cors.allowedRequestHeaders()).contains((Object[])new String[]{"preflight-header1", "preflight-header2"});
    }

    @Test
    public void preflightResponseHeadersSingleValue() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().preflightResponseHeader((CharSequence)"SingleValue", new Object[]{"value"}).build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"value", (Object)cors.preflightResponseHeaders().get(HttpHeadersTestUtils.of("SingleValue")));
    }

    @Test
    public void preflightResponseHeadersMultipleValues() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().preflightResponseHeader((CharSequence)"MultipleValues", new Object[]{"value1", "value2"}).build();
        Assertions.assertThat((List)cors.preflightResponseHeaders().getAll(HttpHeadersTestUtils.of("MultipleValues"))).contains((Object[])new String[]{"value1", "value2"});
    }

    @Test
    public void defaultPreflightResponseHeaders() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().build();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)cors.preflightResponseHeaders().get((CharSequence)HttpHeaderNames.DATE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"0", (Object)cors.preflightResponseHeaders().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
    }

    @Test
    public void emptyPreflightResponseHeaders() {
        CorsConfig cors = CorsConfigBuilder.forAnyOrigin().noPreflightResponseHeaders().build();
        org.junit.jupiter.api.Assertions.assertEquals((Object)EmptyHttpHeaders.INSTANCE, (Object)cors.preflightResponseHeaders());
    }

    @Test
    public void shouldThrowIfValueIsNull() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                CorsConfigBuilder.forOrigin((String)"*").preflightResponseHeader((CharSequence)"HeaderName", new Object[]{null}).build();
            }
        });
    }

    @Test
    public void shortCircuit() {
        CorsConfig cors = CorsConfigBuilder.forOrigin((String)"http://localhost:8080").shortCircuit().build();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)cors.isShortCircuit());
    }
}

