/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.QueryStringEncoder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QueryStringEncoderTest {
    @Test
    public void testDefaultEncoding() throws Exception {
        QueryStringEncoder e = new QueryStringEncoder("/foo");
        e.addParam("a", "b=c");
        Assertions.assertEquals((Object)"/foo?a=b%3Dc", (Object)e.toString());
        Assertions.assertEquals((Object)new URI("/foo?a=b%3Dc"), (Object)e.toUri());
        e = new QueryStringEncoder("/foo/\u00a5");
        e.addParam("a", "\u00a5");
        Assertions.assertEquals((Object)"/foo/\u00a5?a=%C2%A5", (Object)e.toString());
        Assertions.assertEquals((Object)new URI("/foo/\u00a5?a=%C2%A5"), (Object)e.toUri());
        e = new QueryStringEncoder("/foo/\u00a5");
        e.addParam("a", "abc\u00a5");
        Assertions.assertEquals((Object)"/foo/\u00a5?a=abc%C2%A5", (Object)e.toString());
        Assertions.assertEquals((Object)new URI("/foo/\u00a5?a=abc%C2%A5"), (Object)e.toUri());
        e = new QueryStringEncoder("/foo");
        e.addParam("a", "1");
        e.addParam("b", "2");
        Assertions.assertEquals((Object)"/foo?a=1&b=2", (Object)e.toString());
        Assertions.assertEquals((Object)new URI("/foo?a=1&b=2"), (Object)e.toUri());
        e = new QueryStringEncoder("/foo");
        e.addParam("a", "1");
        e.addParam("b", "");
        e.addParam("c", null);
        e.addParam("d", null);
        Assertions.assertEquals((Object)"/foo?a=1&b=&c&d", (Object)e.toString());
        Assertions.assertEquals((Object)new URI("/foo?a=1&b=&c&d"), (Object)e.toUri());
        e = new QueryStringEncoder("/foo");
        e.addParam("test", "a~b");
        Assertions.assertEquals((Object)"/foo?test=a~b", (Object)e.toString());
        Assertions.assertEquals((Object)new URI("/foo?test=a~b"), (Object)e.toUri());
    }

    @Test
    public void testNonDefaultEncoding() throws Exception {
        QueryStringEncoder e = new QueryStringEncoder("/foo/\u00a5", StandardCharsets.UTF_16);
        e.addParam("a", "\u00a5");
        Assertions.assertEquals((Object)"/foo/\u00a5?a=%FE%FF%00%A5", (Object)e.toString());
        Assertions.assertEquals((Object)new URI("/foo/\u00a5?a=%FE%FF%00%A5"), (Object)e.toUri());
    }

    @Test
    public void testWhitespaceEncoding() throws Exception {
        QueryStringEncoder e = new QueryStringEncoder("/foo");
        e.addParam("a", "b c");
        Assertions.assertEquals((Object)"/foo?a=b%20c", (Object)e.toString());
        Assertions.assertEquals((Object)new URI("/foo?a=b%20c"), (Object)e.toUri());
    }
}

