/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QueryStringDecoderTest {
    @Test
    public void testBasicUris() throws URISyntaxException {
        QueryStringDecoder d = new QueryStringDecoder(new URI("http://localhost/path"));
        Assertions.assertEquals((int)0, (int)d.parameters().size());
    }

    @Test
    public void testBasic() {
        QueryStringDecoder d = new QueryStringDecoder("/foo");
        Assertions.assertEquals((Object)"/foo", (Object)d.path());
        Assertions.assertEquals((int)0, (int)d.parameters().size());
        d = new QueryStringDecoder("/foo%20bar");
        Assertions.assertEquals((Object)"/foo bar", (Object)d.path());
        Assertions.assertEquals((int)0, (int)d.parameters().size());
        d = new QueryStringDecoder("/foo?a=b=c");
        Assertions.assertEquals((Object)"/foo", (Object)d.path());
        Assertions.assertEquals((int)1, (int)d.parameters().size());
        Assertions.assertEquals((int)1, (int)((List)d.parameters().get("a")).size());
        Assertions.assertEquals((Object)"b=c", ((List)d.parameters().get("a")).get(0));
        d = new QueryStringDecoder("/foo?a=1&a=2");
        Assertions.assertEquals((Object)"/foo", (Object)d.path());
        Assertions.assertEquals((int)1, (int)d.parameters().size());
        Assertions.assertEquals((int)2, (int)((List)d.parameters().get("a")).size());
        Assertions.assertEquals((Object)"1", ((List)d.parameters().get("a")).get(0));
        Assertions.assertEquals((Object)"2", ((List)d.parameters().get("a")).get(1));
        d = new QueryStringDecoder("/foo%20bar?a=1&a=2");
        Assertions.assertEquals((Object)"/foo bar", (Object)d.path());
        Assertions.assertEquals((int)1, (int)d.parameters().size());
        Assertions.assertEquals((int)2, (int)((List)d.parameters().get("a")).size());
        Assertions.assertEquals((Object)"1", ((List)d.parameters().get("a")).get(0));
        Assertions.assertEquals((Object)"2", ((List)d.parameters().get("a")).get(1));
        d = new QueryStringDecoder("/foo?a=&a=2");
        Assertions.assertEquals((Object)"/foo", (Object)d.path());
        Assertions.assertEquals((int)1, (int)d.parameters().size());
        Assertions.assertEquals((int)2, (int)((List)d.parameters().get("a")).size());
        Assertions.assertEquals((Object)"", ((List)d.parameters().get("a")).get(0));
        Assertions.assertEquals((Object)"2", ((List)d.parameters().get("a")).get(1));
        d = new QueryStringDecoder("/foo?a=1&a=");
        Assertions.assertEquals((Object)"/foo", (Object)d.path());
        Assertions.assertEquals((int)1, (int)d.parameters().size());
        Assertions.assertEquals((int)2, (int)((List)d.parameters().get("a")).size());
        Assertions.assertEquals((Object)"1", ((List)d.parameters().get("a")).get(0));
        Assertions.assertEquals((Object)"", ((List)d.parameters().get("a")).get(1));
        d = new QueryStringDecoder("/foo?a=1&a=&a=");
        Assertions.assertEquals((Object)"/foo", (Object)d.path());
        Assertions.assertEquals((int)1, (int)d.parameters().size());
        Assertions.assertEquals((int)3, (int)((List)d.parameters().get("a")).size());
        Assertions.assertEquals((Object)"1", ((List)d.parameters().get("a")).get(0));
        Assertions.assertEquals((Object)"", ((List)d.parameters().get("a")).get(1));
        Assertions.assertEquals((Object)"", ((List)d.parameters().get("a")).get(2));
        d = new QueryStringDecoder("/foo?a=1=&a==2");
        Assertions.assertEquals((Object)"/foo", (Object)d.path());
        Assertions.assertEquals((int)1, (int)d.parameters().size());
        Assertions.assertEquals((int)2, (int)((List)d.parameters().get("a")).size());
        Assertions.assertEquals((Object)"1=", ((List)d.parameters().get("a")).get(0));
        Assertions.assertEquals((Object)"=2", ((List)d.parameters().get("a")).get(1));
        d = new QueryStringDecoder("/foo?abc=1%2023&abc=124%20");
        Assertions.assertEquals((Object)"/foo", (Object)d.path());
        Assertions.assertEquals((int)1, (int)d.parameters().size());
        Assertions.assertEquals((int)2, (int)((List)d.parameters().get("abc")).size());
        Assertions.assertEquals((Object)"1 23", ((List)d.parameters().get("abc")).get(0));
        Assertions.assertEquals((Object)"124 ", ((List)d.parameters().get("abc")).get(1));
        d = new QueryStringDecoder("/foo?abc=%7E");
        Assertions.assertEquals((Object)"~", ((List)d.parameters().get("abc")).get(0));
    }

    @Test
    public void testNonHtmlQuery() {
        QueryStringDecoder d = QueryStringDecoder.builder().build("/foo?abc=foo+bar");
        Assertions.assertEquals((Object)"foo bar", ((List)d.parameters().get("abc")).get(0));
        d = QueryStringDecoder.builder().htmlQueryDecoding(false).build("/foo?abc=foo+bar");
        Assertions.assertEquals((Object)"foo+bar", ((List)d.parameters().get("abc")).get(0));
    }

    @Test
    public void testExotic() {
        QueryStringDecoderTest.assertQueryString("", "");
        QueryStringDecoderTest.assertQueryString("foo", "foo");
        QueryStringDecoderTest.assertQueryString("foo", "foo?");
        QueryStringDecoderTest.assertQueryString("/foo", "/foo?");
        QueryStringDecoderTest.assertQueryString("/foo", "/foo");
        QueryStringDecoderTest.assertQueryString("?a=", "?a");
        QueryStringDecoderTest.assertQueryString("foo?a=", "foo?a");
        QueryStringDecoderTest.assertQueryString("/foo?a=", "/foo?a");
        QueryStringDecoderTest.assertQueryString("/foo?a=", "/foo?a&");
        QueryStringDecoderTest.assertQueryString("/foo?a=", "/foo?&a");
        QueryStringDecoderTest.assertQueryString("/foo?a=", "/foo?&a&");
        QueryStringDecoderTest.assertQueryString("/foo?a=", "/foo?&=a");
        QueryStringDecoderTest.assertQueryString("/foo?a=", "/foo?=a&");
        QueryStringDecoderTest.assertQueryString("/foo?a=", "/foo?a=&");
        QueryStringDecoderTest.assertQueryString("/foo?a=b&c=d", "/foo?a=b&&c=d");
        QueryStringDecoderTest.assertQueryString("/foo?a=b&c=d", "/foo?a=b&=&c=d");
        QueryStringDecoderTest.assertQueryString("/foo?a=b&c=d", "/foo?a=b&==&c=d");
        QueryStringDecoderTest.assertQueryString("/foo?a=b&c=&x=y", "/foo?a=b&c&x=y");
        QueryStringDecoderTest.assertQueryString("/foo?a=", "/foo?a=");
        QueryStringDecoderTest.assertQueryString("/foo?a=", "/foo?&a=");
        QueryStringDecoderTest.assertQueryString("/foo?a=b&c=d", "/foo?a=b&c=d");
        QueryStringDecoderTest.assertQueryString("/foo?a=1&a=&a=", "/foo?a=1&a&a=");
    }

    @Test
    public void testSemicolon() {
        QueryStringDecoderTest.assertQueryString("/foo?a=1;2", "/foo?a=1;2", false);
        QueryStringDecoderTest.assertQueryString("/foo?a=1;2", "/foo?a=1%3B2", true);
    }

    @Test
    public void testPathSpecific() {
        Assertions.assertEquals((Object)"/foo bar/", (Object)new QueryStringDecoder("/foo%20bar/?").path());
        Assertions.assertEquals((Object)"/foo\r\n\\bar/", (Object)new QueryStringDecoder("/foo%0D%0A\\bar/?").path());
        Assertions.assertEquals((Object)"", (Object)new QueryStringDecoder("#123").path());
        Assertions.assertEquals((Object)"foo", (Object)new QueryStringDecoder("foo?bar#anchor").path());
        Assertions.assertEquals((Object)"/foo-bar", (Object)new QueryStringDecoder("/foo-bar#anchor").path());
        Assertions.assertEquals((Object)"/foo-bar", (Object)new QueryStringDecoder("/foo-bar#a#b?c=d").path());
        Assertions.assertEquals((Object)"+", (Object)new QueryStringDecoder("+").path());
        Assertions.assertEquals((Object)"/foo+bar/", (Object)new QueryStringDecoder("/foo+bar/?").path());
        Assertions.assertEquals((Object)"/foo++", (Object)new QueryStringDecoder("/foo++?index.php").path());
        Assertions.assertEquals((Object)"/foo +", (Object)new QueryStringDecoder("/foo%20+?index.php").path());
        Assertions.assertEquals((Object)"/foo+ ", (Object)new QueryStringDecoder("/foo+%20").path());
    }

    @Test
    public void testExcludeFragment() {
        Assertions.assertEquals((Object)"a", new QueryStringDecoder("?a#anchor").parameters().keySet().iterator().next());
        Assertions.assertEquals((Object)"b", ((List)new QueryStringDecoder("?a=b#anchor").parameters().get("a")).get(0));
        Assertions.assertTrue((boolean)new QueryStringDecoder("?#").parameters().isEmpty());
        Assertions.assertTrue((boolean)new QueryStringDecoder("?#anchor").parameters().isEmpty());
        Assertions.assertTrue((boolean)new QueryStringDecoder("#?a=b#anchor").parameters().isEmpty());
        Assertions.assertTrue((boolean)new QueryStringDecoder("?#a=b#anchor").parameters().isEmpty());
    }

    @Test
    public void testHashDos() {
        StringBuilder buf = new StringBuilder();
        buf.append('?');
        for (int i = 0; i < 65536; ++i) {
            buf.append('k');
            buf.append(i);
            buf.append("=v");
            buf.append(i);
            buf.append('&');
        }
        Assertions.assertEquals((int)1024, (int)new QueryStringDecoder(buf.toString()).parameters().size());
    }

    @Test
    public void testHasPath() {
        QueryStringDecoder decoder = new QueryStringDecoder("1=2", false);
        Assertions.assertEquals((Object)"", (Object)decoder.path());
        Map params = decoder.parameters();
        Assertions.assertEquals((int)1, (int)params.size());
        Assertions.assertTrue((boolean)params.containsKey("1"));
        List param = (List)params.get("1");
        Assertions.assertNotNull((Object)param);
        Assertions.assertEquals((int)1, (int)param.size());
        Assertions.assertEquals((Object)"2", param.get(0));
    }

    @Test
    public void testUrlDecoding() throws Exception {
        String caffe = new String(new byte[]{67, 97, 102, 102, -61, -87}, StandardCharsets.UTF_8);
        String[] tests = new String[]{"", "", "foo", "foo", "f+o", "f o", "f++", "f  ", "fo%", "unterminated escape sequence at index 2 of: fo%", "%42", "B", "%5f", "_", "f%4", "unterminated escape sequence at index 1 of: f%4", "%x2", "invalid hex byte 'x2' at index 1 of '%x2'", "%4x", "invalid hex byte '4x' at index 1 of '%4x'", "Caff%C3%A9", caffe, "\u0441\u043b\u0443\u0447\u0430\u0439\u043d\u044b\u0439 \u043f\u0440\u0430\u0437\u0434\u043d\u0438\u043a", "\u0441\u043b\u0443\u0447\u0430\u0439\u043d\u044b\u0439 \u043f\u0440\u0430\u0437\u0434\u043d\u0438\u043a", "\u0441\u043b\u0443\u0447\u0430\u0439\u043d\u044b\u0439%20\u043f\u0440\u0430\u0437\u0434\u043d\u0438\u043a", "\u0441\u043b\u0443\u0447\u0430\u0439\u043d\u044b\u0439 \u043f\u0440\u0430\u0437\u0434\u043d\u0438\u043a", "\u0441\u043b\u0443\u0447\u0430\u0439\u043d\u044b\u0439%20\u043f\u0440\u0430\u0437\u0434\u043d\u0438\u043a%20%E2%98%BA", "\u0441\u043b\u0443\u0447\u0430\u0439\u043d\u044b\u0439 \u043f\u0440\u0430\u0437\u0434\u043d\u0438\u043a \u263a"};
        for (int i = 0; i < tests.length; i += 2) {
            String encoded = tests[i];
            String expected = tests[i + 1];
            try {
                String decoded = QueryStringDecoder.decodeComponent((String)encoded);
                Assertions.assertEquals((Object)expected, (Object)decoded);
                continue;
            }
            catch (IllegalArgumentException e) {
                Assertions.assertEquals((Object)expected, (Object)e.getMessage());
            }
        }
    }

    private static void assertQueryString(String expected, String actual) {
        QueryStringDecoderTest.assertQueryString(expected, actual, false);
    }

    private static void assertQueryString(String expected, String actual, boolean semicolonIsNormalChar) {
        QueryStringDecoder ed = new QueryStringDecoder(expected, CharsetUtil.UTF_8, true, 1024, semicolonIsNormalChar);
        QueryStringDecoder ad = new QueryStringDecoder(actual, CharsetUtil.UTF_8, true, 1024, semicolonIsNormalChar);
        Assertions.assertEquals((Object)ed.path(), (Object)ad.path());
        Assertions.assertEquals((Object)ed.parameters(), (Object)ad.parameters());
    }

    @Test
    public void testURI() {
        URI uri = URI.create("http://localhost:8080/foo?param1=value1&param2=value2&param3=value3");
        QueryStringDecoder decoder = new QueryStringDecoder(uri);
        Assertions.assertEquals((Object)"/foo", (Object)decoder.path());
        Assertions.assertEquals((Object)"/foo", (Object)decoder.rawPath());
        Assertions.assertEquals((Object)"param1=value1&param2=value2&param3=value3", (Object)decoder.rawQuery());
        Map params = decoder.parameters();
        Assertions.assertEquals((int)3, (int)params.size());
        Iterator entries = params.entrySet().iterator();
        Map.Entry entry = entries.next();
        Assertions.assertEquals((Object)"param1", entry.getKey());
        Assertions.assertEquals((int)1, (int)((List)entry.getValue()).size());
        Assertions.assertEquals((Object)"value1", ((List)entry.getValue()).get(0));
        entry = entries.next();
        Assertions.assertEquals((Object)"param2", entry.getKey());
        Assertions.assertEquals((int)1, (int)((List)entry.getValue()).size());
        Assertions.assertEquals((Object)"value2", ((List)entry.getValue()).get(0));
        entry = entries.next();
        Assertions.assertEquals((Object)"param3", entry.getKey());
        Assertions.assertEquals((int)1, (int)((List)entry.getValue()).size());
        Assertions.assertEquals((Object)"value3", ((List)entry.getValue()).get(0));
        Assertions.assertFalse((boolean)entries.hasNext());
    }

    @Test
    public void testURISlashPath() {
        URI uri = URI.create("http://localhost:8080/?param1=value1&param2=value2&param3=value3");
        QueryStringDecoder decoder = new QueryStringDecoder(uri);
        Assertions.assertEquals((Object)"/", (Object)decoder.path());
        Assertions.assertEquals((Object)"/", (Object)decoder.rawPath());
        Assertions.assertEquals((Object)"param1=value1&param2=value2&param3=value3", (Object)decoder.rawQuery());
        Map params = decoder.parameters();
        Assertions.assertEquals((int)3, (int)params.size());
        Iterator entries = params.entrySet().iterator();
        Map.Entry entry = entries.next();
        Assertions.assertEquals((Object)"param1", entry.getKey());
        Assertions.assertEquals((int)1, (int)((List)entry.getValue()).size());
        Assertions.assertEquals((Object)"value1", ((List)entry.getValue()).get(0));
        entry = entries.next();
        Assertions.assertEquals((Object)"param2", entry.getKey());
        Assertions.assertEquals((int)1, (int)((List)entry.getValue()).size());
        Assertions.assertEquals((Object)"value2", ((List)entry.getValue()).get(0));
        entry = entries.next();
        Assertions.assertEquals((Object)"param3", entry.getKey());
        Assertions.assertEquals((int)1, (int)((List)entry.getValue()).size());
        Assertions.assertEquals((Object)"value3", ((List)entry.getValue()).get(0));
        Assertions.assertFalse((boolean)entries.hasNext());
    }

    @Test
    public void testURINoPath() {
        URI uri = URI.create("http://localhost:8080?param1=value1&param2=value2&param3=value3");
        QueryStringDecoder decoder = new QueryStringDecoder(uri);
        Assertions.assertEquals((Object)"", (Object)decoder.path());
        Assertions.assertEquals((Object)"", (Object)decoder.rawPath());
        Assertions.assertEquals((Object)"param1=value1&param2=value2&param3=value3", (Object)decoder.rawQuery());
        Map params = decoder.parameters();
        Assertions.assertEquals((int)3, (int)params.size());
        Iterator entries = params.entrySet().iterator();
        Map.Entry entry = entries.next();
        Assertions.assertEquals((Object)"param1", entry.getKey());
        Assertions.assertEquals((int)1, (int)((List)entry.getValue()).size());
        Assertions.assertEquals((Object)"value1", ((List)entry.getValue()).get(0));
        entry = entries.next();
        Assertions.assertEquals((Object)"param2", entry.getKey());
        Assertions.assertEquals((int)1, (int)((List)entry.getValue()).size());
        Assertions.assertEquals((Object)"value2", ((List)entry.getValue()).get(0));
        entry = entries.next();
        Assertions.assertEquals((Object)"param3", entry.getKey());
        Assertions.assertEquals((int)1, (int)((List)entry.getValue()).size());
        Assertions.assertEquals((Object)"value3", ((List)entry.getValue()).get(0));
        Assertions.assertFalse((boolean)entries.hasNext());
    }

    @Test
    public void testURI2() {
        URI uri = URI.create("http://foo.com/images;num=10?query=name;value=123");
        QueryStringDecoder decoder = new QueryStringDecoder(uri);
        Assertions.assertEquals((Object)"/images;num=10", (Object)decoder.path());
        Assertions.assertEquals((Object)"/images;num=10", (Object)decoder.rawPath());
        Assertions.assertEquals((Object)"query=name;value=123", (Object)decoder.rawQuery());
        Map params = decoder.parameters();
        Assertions.assertEquals((int)2, (int)params.size());
        Iterator entries = params.entrySet().iterator();
        Map.Entry entry = entries.next();
        Assertions.assertEquals((Object)"query", entry.getKey());
        Assertions.assertEquals((int)1, (int)((List)entry.getValue()).size());
        Assertions.assertEquals((Object)"name", ((List)entry.getValue()).get(0));
        entry = entries.next();
        Assertions.assertEquals((Object)"value", entry.getKey());
        Assertions.assertEquals((int)1, (int)((List)entry.getValue()).size());
        Assertions.assertEquals((Object)"123", ((List)entry.getValue()).get(0));
        Assertions.assertFalse((boolean)entries.hasNext());
    }

    @Test
    public void testEmptyStrings() {
        QueryStringDecoder pathSlash = new QueryStringDecoder("path/");
        Assertions.assertEquals((Object)"path/", (Object)pathSlash.rawPath());
        Assertions.assertEquals((Object)"", (Object)pathSlash.rawQuery());
        QueryStringDecoder pathQuestion = new QueryStringDecoder("path?");
        Assertions.assertEquals((Object)"path", (Object)pathQuestion.rawPath());
        Assertions.assertEquals((Object)"", (Object)pathQuestion.rawQuery());
        QueryStringDecoder empty = new QueryStringDecoder("");
        Assertions.assertEquals((Object)"", (Object)empty.rawPath());
        Assertions.assertEquals((Object)"", (Object)empty.rawQuery());
    }
}

