/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.HttpDecoderConfig;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class MultipleContentLengthHeadersTest {
    static Collection<Object[]> parameters() {
        return Arrays.asList({false, false, false}, {false, false, true}, {false, true, false}, {false, true, true}, {true, false, false}, {true, false, true}, {true, true, false}, {true, true, true});
    }

    private static EmbeddedChannel newChannel(boolean allowDuplicateContentLengths) {
        HttpDecoderConfig config = new HttpDecoderConfig().setAllowDuplicateContentLengths(allowDuplicateContentLengths);
        HttpRequestDecoder decoder = new HttpRequestDecoder(config);
        return new EmbeddedChannel(new ChannelHandler[]{decoder});
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testMultipleContentLengthHeadersBehavior(boolean allowDuplicateContentLengths, boolean sameValue, boolean singleField) {
        EmbeddedChannel channel = MultipleContentLengthHeadersTest.newChannel(allowDuplicateContentLengths);
        String requestStr = MultipleContentLengthHeadersTest.setupRequestString(sameValue, singleField);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest request = (HttpRequest)channel.readInbound();
        if (allowDuplicateContentLengths) {
            if (sameValue) {
                MultipleContentLengthHeadersTest.assertValid(request);
                List contentLengths = request.headers().getAll((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                Assertions.assertThat((List)contentLengths).contains((Object[])new String[]{"1"});
                LastHttpContent body = (LastHttpContent)channel.readInbound();
                org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)body.content().readableBytes());
                org.junit.jupiter.api.Assertions.assertEquals((Object)"a", (Object)body.content().readCharSequence(1, CharsetUtil.US_ASCII).toString());
            } else {
                MultipleContentLengthHeadersTest.assertInvalid(request);
            }
        } else {
            MultipleContentLengthHeadersTest.assertInvalid(request);
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    private static String setupRequestString(boolean sameValue, boolean singleField) {
        String firstValue = "1";
        String secondValue = sameValue ? firstValue : "2";
        String contentLength = singleField ? "Content-Length: " + firstValue + ", " + secondValue + "\r\n\r\n" : "Content-Length: " + firstValue + "\r\nContent-Length: " + secondValue + "\r\n\r\n";
        return "PUT /some/path HTTP/1.1\r\n" + contentLength + "ab";
    }

    @Test
    public void testDanglingComma() {
        EmbeddedChannel channel = MultipleContentLengthHeadersTest.newChannel(false);
        String requestStr = "GET /some/path HTTP/1.1\r\nContent-Length: 1,\r\nConnection: close\r\n\r\nab";
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest request = (HttpRequest)channel.readInbound();
        MultipleContentLengthHeadersTest.assertInvalid(request);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    private static void assertValid(HttpRequest request) {
        org.junit.jupiter.api.Assertions.assertFalse((boolean)request.decoderResult().isFailure());
    }

    private static void assertInvalid(HttpRequest request) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)request.decoderResult().isFailure());
        org.junit.jupiter.api.Assertions.assertInstanceOf(IllegalArgumentException.class, (Object)request.decoderResult().cause());
        Assertions.assertThat((String)request.decoderResult().cause().getMessage()).contains(new CharSequence[]{"Multiple Content-Length values found"});
    }
}

