/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpVersionParsingTest {
    @Test
    void testStandardVersions() {
        HttpVersion v10 = HttpVersion.valueOf((String)"HTTP/1.0");
        HttpVersion v11 = HttpVersion.valueOf((String)"HTTP/1.1");
        Assertions.assertSame((Object)HttpVersion.HTTP_1_0, (Object)v10);
        Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)v11);
        Assertions.assertEquals((Object)"HTTP", (Object)v10.protocolName());
        Assertions.assertEquals((int)1, (int)v10.majorVersion());
        Assertions.assertEquals((int)0, (int)v10.minorVersion());
        Assertions.assertEquals((Object)"HTTP", (Object)v11.protocolName());
        Assertions.assertEquals((int)1, (int)v11.majorVersion());
        Assertions.assertEquals((int)1, (int)v11.minorVersion());
    }

    @Test
    void testLowerCaseProtocolNameNonStrict() {
        HttpVersion version = HttpVersion.valueOf((String)"http/1.1");
        Assertions.assertEquals((Object)"HTTP", (Object)version.protocolName());
        Assertions.assertEquals((int)1, (int)version.majorVersion());
        Assertions.assertEquals((int)1, (int)version.minorVersion());
        Assertions.assertEquals((Object)"HTTP/1.1", (Object)version.text());
    }

    @Test
    void testMixedCaseProtocolNameNonStrict() {
        HttpVersion version = HttpVersion.valueOf((String)"hTtP/1.0");
        Assertions.assertEquals((Object)"HTTP", (Object)version.protocolName());
        Assertions.assertEquals((int)1, (int)version.majorVersion());
        Assertions.assertEquals((int)0, (int)version.minorVersion());
        Assertions.assertEquals((Object)"HTTP/1.0", (Object)version.text());
    }

    @Test
    void testCustomLowerCaseProtocolNonStrict() {
        HttpVersion version = HttpVersion.valueOf((String)"mqtt/5.0");
        Assertions.assertEquals((Object)"MQTT", (Object)version.protocolName());
        Assertions.assertEquals((int)5, (int)version.majorVersion());
        Assertions.assertEquals((int)0, (int)version.minorVersion());
        Assertions.assertEquals((Object)"MQTT/5.0", (Object)version.text());
    }

    @Test
    void testCustomVersionNonStrict() {
        HttpVersion version = HttpVersion.valueOf((String)"MyProto/2.3");
        Assertions.assertEquals((Object)"MYPROTO", (Object)version.protocolName());
        Assertions.assertEquals((int)2, (int)version.majorVersion());
        Assertions.assertEquals((int)3, (int)version.minorVersion());
        Assertions.assertEquals((Object)"MYPROTO/2.3", (Object)version.text());
    }

    @Test
    void testCustomVersionStrict() {
        HttpVersion version = new HttpVersion("HTTP/1.1", true, true);
        Assertions.assertEquals((Object)"HTTP", (Object)version.protocolName());
        Assertions.assertEquals((int)1, (int)version.majorVersion());
        Assertions.assertEquals((int)1, (int)version.minorVersion());
    }

    @Test
    void testCustomVersionStrictFailsOnLongVersion() {
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new HttpVersion("HTTP/10.1", true, true));
        Assertions.assertTrue((boolean)ex.getMessage().contains("invalid version format"));
    }

    @Test
    void testInvalidFormatMissingSlash() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpVersion.valueOf((String)"HTTP1.1"));
    }

    @Test
    void testInvalidFormatWhitespaceInProtocol() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpVersion.valueOf((String)"HT TP/1.1"));
    }
}

