/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class HttpServerUpgradeHandlerTest {
    @Test
    public void upgradesPipelineInSameMethodInvocation() {
        HttpServerCodec httpServerCodec = new HttpServerCodec();
        HttpServerUpgradeHandler.UpgradeCodecFactory factory = new HttpServerUpgradeHandler.UpgradeCodecFactory(){

            public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
                return new TestUpgradeCodec();
            }
        };
        ChannelDuplexHandler testInStackFrame = new ChannelDuplexHandler(){
            private boolean inReadCall;
            private boolean writeUpgradeMessage;
            private boolean writeFlushed;

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                org.junit.jupiter.api.Assertions.assertFalse((boolean)this.inReadCall);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)this.writeUpgradeMessage);
                this.inReadCall = true;
                try {
                    super.channelRead(ctx, msg);
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)this.writeUpgradeMessage);
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)this.writeFlushed);
                    org.junit.jupiter.api.Assertions.assertNull((Object)ctx.pipeline().get(HttpServerCodec.class));
                    org.junit.jupiter.api.Assertions.assertNotNull((Object)ctx.pipeline().get("marker"));
                }
                finally {
                    this.inReadCall = false;
                }
            }

            public void write(final ChannelHandlerContext ctx, final Object msg, final ChannelPromise promise) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)this.inReadCall);
                this.writeUpgradeMessage = true;
                ctx.channel().eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        ctx.write(msg, promise);
                    }
                });
                promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) {
                        writeFlushed = true;
                    }
                });
            }
        };
        HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)httpServerCodec, factory);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{testInStackFrame, httpServerCodec, upgradeHandler});
        String upgradeString = "GET / HTTP/1.1\r\nHost: example.com\r\nConnection: Upgrade, HTTP2-Settings\r\nUpgrade: nextprotocol\r\nHTTP2-Settings: AAMAAABkAAQAAP__\r\n\r\n";
        ByteBuf upgrade = Unpooled.copiedBuffer((CharSequence)upgradeString, (Charset)CharsetUtil.US_ASCII);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{upgrade}));
        org.junit.jupiter.api.Assertions.assertNull((Object)channel.pipeline().get(HttpServerCodec.class));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)channel.pipeline().get("marker"));
        channel.flushOutbound();
        ByteBuf upgradeMessage = (ByteBuf)channel.readOutbound();
        String expectedHttpResponse = "HTTP/1.1 101 Switching Protocols\r\nconnection: upgrade\r\nupgrade: nextprotocol\r\n\r\n";
        org.junit.jupiter.api.Assertions.assertEquals((Object)expectedHttpResponse, (Object)upgradeMessage.toString(CharsetUtil.US_ASCII));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)upgradeMessage.release());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finishAndReleaseAll());
    }

    @Test
    public void skippedUpgrade() {
        HttpServerCodec httpServerCodec = new HttpServerCodec();
        HttpServerUpgradeHandler.UpgradeCodecFactory factory = new HttpServerUpgradeHandler.UpgradeCodecFactory(){

            public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
                org.junit.jupiter.api.Assertions.fail((String)"Should never be invoked");
                return null;
            }
        };
        HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)httpServerCodec, factory){

            protected boolean shouldHandleUpgradeRequest(HttpRequest req) {
                return !req.headers().contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)"do-not-upgrade", false);
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{httpServerCodec, upgradeHandler});
        String upgradeString = "GET / HTTP/1.1\r\nHost: example.com\r\nConnection: Upgrade\r\nUpgrade: do-not-upgrade\r\n\r\n";
        ByteBuf upgrade = Unpooled.copiedBuffer((CharSequence)upgradeString, (Charset)CharsetUtil.US_ASCII);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{upgrade}));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)channel.pipeline().get(HttpServerCodec.class));
        org.junit.jupiter.api.Assertions.assertNull((Object)channel.pipeline().get("marker"));
        HttpRequest req = (HttpRequest)channel.readInbound();
        Assertions.assertThat((Object)req).isNotInstanceOf(FullHttpRequest.class);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)req.headers().contains((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)"Upgrade", false));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)req.headers().contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)"do-not-upgrade", false));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(channel.readInbound() instanceof LastHttpContent));
        org.junit.jupiter.api.Assertions.assertNull((Object)channel.readInbound());
        channel.flushOutbound();
        org.junit.jupiter.api.Assertions.assertNull((Object)channel.readOutbound());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finishAndReleaseAll());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void upgradeFail(boolean removeAfterFirst) {
        HttpServerCodec httpServerCodec = new HttpServerCodec();
        HttpServerUpgradeHandler.UpgradeCodecFactory factory = new HttpServerUpgradeHandler.UpgradeCodecFactory(){

            public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
                return new TestUpgradeCodec();
            }
        };
        HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)httpServerCodec, factory, 0, (HttpHeadersFactory)DefaultHttpHeadersFactory.headersFactory(), (HttpHeadersFactory)DefaultHttpHeadersFactory.trailersFactory(), removeAfterFirst);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{httpServerCodec, upgradeHandler});
        String upgradeString = "GET / HTTP/1.1\r\nHost: example.com\r\nUpgrade: h2c\r\n\r\n";
        ByteBuf upgrade = Unpooled.copiedBuffer((CharSequence)upgradeString, (Charset)CharsetUtil.US_ASCII);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{upgrade}));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)channel.pipeline().get(HttpServerCodec.class));
        if (removeAfterFirst) {
            org.junit.jupiter.api.Assertions.assertNull((Object)channel.pipeline().get(HttpServerUpgradeHandler.class));
        } else {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)channel.pipeline().get(HttpServerUpgradeHandler.class));
        }
        org.junit.jupiter.api.Assertions.assertNull((Object)channel.pipeline().get("marker"));
        HttpRequest req = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)req.protocolVersion());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)req.headers().contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)"h2c", false));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)req.headers().contains((CharSequence)HttpHeaderNames.CONNECTION));
        ReferenceCountUtil.release((Object)req);
        org.junit.jupiter.api.Assertions.assertNull((Object)channel.readInbound());
        channel.flushOutbound();
        org.junit.jupiter.api.Assertions.assertNull((Object)channel.readOutbound());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finishAndReleaseAll());
    }

    @Test
    public void upgradeExpect() {
        HttpServerCodec httpServerCodec = new HttpServerCodec();
        HttpServerUpgradeHandler.UpgradeCodecFactory factory = new HttpServerUpgradeHandler.UpgradeCodecFactory(){

            public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
                return new TestUpgradeCodec();
            }
        };
        HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)httpServerCodec, factory);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{httpServerCodec, upgradeHandler});
        String upgradeString = "GET / HTTP/1.1\r\nExpect: foo\r\nUpgrade: h2c\r\n\r\nGET / HTTP/1.1\r\nContent-Length: 0\r\n\r\n";
        ByteBuf upgrade = Unpooled.copiedBuffer((CharSequence)upgradeString, (Charset)CharsetUtil.US_ASCII);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{upgrade}));
        channel.checkException();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.finishAndReleaseAll());
    }

    @Test
    public void upgradePrematureClose() throws Exception {
        HttpServerCodec httpServerCodec = new HttpServerCodec();
        HttpServerUpgradeHandler.UpgradeCodecFactory factory = new HttpServerUpgradeHandler.UpgradeCodecFactory(){

            public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
                return new TestUpgradeCodec();
            }
        };
        HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)httpServerCodec, factory);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{httpServerCodec, upgradeHandler});
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"POST / HTTP/1.1\nUpgrade:\nExpect:\nContent-Length: 8\n\nGET / HTTP/1.1\n", (Charset)CharsetUtil.US_ASCII)});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.finishAndReleaseAll());
    }

    private static class TestUpgradeCodec
    implements HttpServerUpgradeHandler.UpgradeCodec {
        private TestUpgradeCodec() {
        }

        public Collection<CharSequence> requiredUpgradeHeaders() {
            return Collections.emptyList();
        }

        public boolean prepareUpgradeResponse(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest, HttpHeaders upgradeHeaders) {
            return true;
        }

        public void upgradeTo(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)ctx.pipeline().context(HttpServerUpgradeHandler.class), (Object)ctx);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)ctx.pipeline().get(HttpServerUpgradeHandler.class));
            ctx.pipeline().addAfter(ctx.name(), "marker", (ChannelHandler)new ChannelInboundHandlerAdapter());
        }
    }
}

