/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.util.AsciiString;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class HttpResponseStatusTest {
    @Test
    public void parseLineStringJustCode() {
        Assertions.assertSame((Object)HttpResponseStatus.OK, (Object)HttpResponseStatus.parseLine((String)"200"));
    }

    @Test
    public void parseLineStringCodeAndPhrase() {
        Assertions.assertSame((Object)HttpResponseStatus.OK, (Object)HttpResponseStatus.parseLine((String)"200 OK"));
    }

    @Test
    public void parseLineStringCustomCode() {
        HttpResponseStatus customStatus = HttpResponseStatus.parseLine((String)"612");
        Assertions.assertEquals((int)612, (int)customStatus.code());
    }

    @Test
    public void parseLineStringCustomCodeAndPhrase() {
        HttpResponseStatus customStatus = HttpResponseStatus.parseLine((String)"612 FOO");
        Assertions.assertEquals((int)612, (int)customStatus.code());
        Assertions.assertEquals((Object)"FOO", (Object)customStatus.reasonPhrase());
    }

    @Test
    public void parseLineStringMalformedCode() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                HttpResponseStatus.parseLine((String)"200a");
            }
        });
    }

    @Test
    public void parseLineStringMalformedCodeWithPhrase() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                HttpResponseStatus.parseLine((String)"200a foo");
            }
        });
    }

    @Test
    public void parseLineAsciiStringJustCode() {
        Assertions.assertSame((Object)HttpResponseStatus.OK, (Object)HttpResponseStatus.parseLine((AsciiString)new AsciiString((CharSequence)"200")));
    }

    @Test
    public void parseLineAsciiStringCodeAndPhrase() {
        Assertions.assertSame((Object)HttpResponseStatus.OK, (Object)HttpResponseStatus.parseLine((AsciiString)new AsciiString((CharSequence)"200 OK")));
    }

    @Test
    public void parseLineAsciiStringCustomCode() {
        HttpResponseStatus customStatus = HttpResponseStatus.parseLine((AsciiString)new AsciiString((CharSequence)"612"));
        Assertions.assertEquals((int)612, (int)customStatus.code());
    }

    @Test
    public void parseLineAsciiStringCustomCodeAndPhrase() {
        HttpResponseStatus customStatus = HttpResponseStatus.parseLine((AsciiString)new AsciiString((CharSequence)"612 FOO"));
        Assertions.assertEquals((int)612, (int)customStatus.code());
        Assertions.assertEquals((Object)"FOO", (Object)customStatus.reasonPhrase());
    }

    @Test
    public void parseLineAsciiStringMalformedCode() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                HttpResponseStatus.parseLine((AsciiString)new AsciiString((CharSequence)"200a"));
            }
        });
    }

    @Test
    public void parseLineAsciiStringMalformedCodeWithPhrase() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                HttpResponseStatus.parseLine((AsciiString)new AsciiString((CharSequence)"200a foo"));
            }
        });
    }

    @Test
    public void testHttpStatusClassValueOf() {
        HttpStatusClass httpStatusClass;
        int code;
        for (code = 100; code < 600; ++code) {
            httpStatusClass = HttpStatusClass.valueOf((int)code);
            Assertions.assertNotSame((Object)HttpStatusClass.UNKNOWN, (Object)httpStatusClass);
            if (HttpStatusClass.INFORMATIONAL.contains(code)) {
                Assertions.assertEquals((Object)HttpStatusClass.INFORMATIONAL, (Object)httpStatusClass);
                continue;
            }
            if (HttpStatusClass.SUCCESS.contains(code)) {
                Assertions.assertEquals((Object)HttpStatusClass.SUCCESS, (Object)httpStatusClass);
                continue;
            }
            if (HttpStatusClass.REDIRECTION.contains(code)) {
                Assertions.assertEquals((Object)HttpStatusClass.REDIRECTION, (Object)httpStatusClass);
                continue;
            }
            if (HttpStatusClass.CLIENT_ERROR.contains(code)) {
                Assertions.assertEquals((Object)HttpStatusClass.CLIENT_ERROR, (Object)httpStatusClass);
                continue;
            }
            if (HttpStatusClass.SERVER_ERROR.contains(code)) {
                Assertions.assertEquals((Object)HttpStatusClass.SERVER_ERROR, (Object)httpStatusClass);
                continue;
            }
            Assertions.fail((String)"At least one of the if-branches above must be true");
        }
        for (code = Integer.MIN_VALUE; code < 100; ++code) {
            httpStatusClass = HttpStatusClass.valueOf((int)code);
            Assertions.assertEquals((Object)HttpStatusClass.UNKNOWN, (Object)httpStatusClass);
        }
        for (code = 600; code > 0; ++code) {
            httpStatusClass = HttpStatusClass.valueOf((int)code);
            Assertions.assertEquals((Object)HttpStatusClass.UNKNOWN, (Object)httpStatusClass);
        }
    }
}

