/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMessageDecoderResult;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.InvalidChunkExtensionException;
import io.netty.handler.codec.http.InvalidChunkTerminationException;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.TooLongHttpHeaderException;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class HttpResponseDecoderTest {
    @Test
    public void testMaxHeaderSize1() {
        int maxHeaderSize = 8192;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder(4096, 8192, 8192)});
        char[] bytes = new char[4092];
        Arrays.fill(bytes, 'a');
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\n", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"A:", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((char[])bytes, (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)});
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"B:", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((char[])bytes, (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertNull((Object)res.decoderResult().cause());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)res.decoderResult().isSuccess());
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.finish());
        org.junit.jupiter.api.Assertions.assertInstanceOf(LastHttpContent.class, (Object)ch.readInbound());
    }

    @Test
    public void testMaxHeaderSize2() {
        int maxHeaderSize = 8192;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder(4096, 8192, 8192)});
        char[] bytes = new char[4094];
        Arrays.fill(bytes, 'a');
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\n", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"A:", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((char[])bytes, (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)});
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"B: ", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((char[])bytes, (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertInstanceOf(TooLongHttpHeaderException.class, (Object)res.decoderResult().cause());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.finish());
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    void testTotalHeaderLimit() throws Exception {
        String requestStr = "HTTP/1.1 200 OK\r\nServer: X\r\na1: b\r\na2: b\r\n\r\n";
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder(1024, 18, 1024)});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpResponse response = (HttpResponse)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.decoderResult().isFailure());
        org.junit.jupiter.api.Assertions.assertInstanceOf(TooLongHttpHeaderException.class, (Object)response.decoderResult().cause());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
        channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder(1024, 19, 1024)});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        response = (HttpResponse)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.decoderResult().isSuccess());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"X", (Object)response.headers().get("Server"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", (Object)response.headers().get("a1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", (Object)response.headers().get("a2"));
        channel.close();
        org.junit.jupiter.api.Assertions.assertEquals((Object)LastHttpContent.EMPTY_LAST_CONTENT, (Object)channel.readInbound());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testResponseChunked() {
        int i;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)res.status());
        byte[] data = new byte[64];
        for (i = 0; i < data.length; ++i) {
            data[i] = (byte)i;
        }
        for (i = 0; i < 10; ++i) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)(Integer.toHexString(data.length) + "\r\n"), (Charset)CharsetUtil.US_ASCII)}));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data)}));
            HttpContent content = (HttpContent)ch.readInbound();
            org.junit.jupiter.api.Assertions.assertEquals((int)data.length, (int)content.content().readableBytes());
            byte[] decodedData = new byte[data.length];
            content.content().readBytes(decodedData);
            org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])data, (byte[])decodedData);
            content.release();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)}));
        }
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"0\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        LastHttpContent content = (LastHttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)content.content().isReadable());
        content.release();
        ch.finish();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testResponseChunkedWithValidUncommonPatterns() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)res.status());
        byte[] data = new byte[1];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)i;
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)("  " + Integer.toHexString(data.length) + " \r\n"), (Charset)CharsetUtil.US_ASCII)}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data)}));
        HttpContent content = (HttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)data.length, (int)content.content().readableBytes());
        byte[] decodedData = new byte[data.length];
        content.content().readBytes(decodedData);
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])data, (byte[])decodedData);
        content.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)("  " + Integer.toHexString(data.length) + "\u0000\r\n"), (Charset)CharsetUtil.US_ASCII)}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data)}));
        content = (HttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)data.length, (int)content.content().readableBytes());
        decodedData = new byte[data.length];
        content.content().readBytes(decodedData);
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])data, (byte[])decodedData);
        content.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)("  " + Integer.toHexString(data.length) + ";\r\n"), (Charset)CharsetUtil.US_ASCII)}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data)}));
        content = (HttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)data.length, (int)content.content().readableBytes());
        decodedData = new byte[data.length];
        content.content().readBytes(decodedData);
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])data, (byte[])decodedData);
        content.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)}));
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"0\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)lastContent.content().isReadable());
        lastContent.release();
        ch.finish();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testResponseChunkedWithControlChars() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)res.status());
        byte[] data = new byte[1];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)i;
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)("  " + Integer.toHexString(data.length) + " \r\n"), (Charset)CharsetUtil.US_ASCII)}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data)}));
        HttpContent content = (HttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)data.length, (int)content.content().readableBytes());
        byte[] decodedData = new byte[data.length];
        content.content().readBytes(decodedData);
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])data, (byte[])decodedData);
        content.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)}));
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"0\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)lastContent.content().isReadable());
        lastContent.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.finish());
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testResponseDisallowPartialChunks() {
        HttpResponseDecoder decoder = new HttpResponseDecoder(4096, 8192, 8192, true, 128, false, false);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{decoder});
        String headers = "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n";
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)headers, (Charset)CharsetUtil.US_ASCII)}));
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)res.status());
        byte[] chunkBytes = new byte[10];
        Random random = new Random();
        random.nextBytes(chunkBytes);
        ByteBuf chunk = ch.alloc().buffer().writeBytes(chunkBytes);
        int chunkSize = chunk.readableBytes();
        ByteBuf partialChunk1 = chunk.retainedSlice(0, 5);
        ByteBuf partialChunk2 = chunk.retainedSlice(5, 5);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)(Integer.toHexString(chunkSize) + "\r\n"), (Charset)CharsetUtil.US_ASCII)}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{partialChunk1}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{partialChunk2}));
        HttpContent content = (HttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)chunk, (Object)content.content());
        content.release();
        chunk.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"0\r\n\r\n", (Charset)CharsetUtil.US_ASCII)}));
        HttpContent lastContent = (HttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)lastContent.content().isReadable());
        lastContent.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testResponseChunkedExceedMaxChunkSize() {
        int i;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder(4096, 8192, 32)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)res.status());
        byte[] data = new byte[64];
        for (i = 0; i < data.length; ++i) {
            data[i] = (byte)i;
        }
        for (i = 0; i < 10; ++i) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)(Integer.toHexString(data.length) + "\r\n"), (Charset)CharsetUtil.US_ASCII)}));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data)}));
            byte[] decodedData = new byte[data.length];
            HttpContent content = (HttpContent)ch.readInbound();
            org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)content.content().readableBytes());
            content.content().readBytes(decodedData, 0, 32);
            content.release();
            content = (HttpContent)ch.readInbound();
            org.junit.jupiter.api.Assertions.assertEquals((int)32, (int)content.content().readableBytes());
            content.content().readBytes(decodedData, 32, 32);
            org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])data, (byte[])decodedData);
            content.release();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)}));
        }
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"0\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        LastHttpContent content = (LastHttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)content.content().isReadable());
        content.release();
        ch.finish();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testClosureWithoutContentLength1() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)res.status());
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.finish());
        LastHttpContent content = (LastHttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)content.content().isReadable());
        content.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testClosureWithoutContentLength2() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\n\r\n12345678", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)res.status());
        HttpContent content = (HttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"12345678", (Object)content.content().toString(CharsetUtil.US_ASCII));
        Assertions.assertThat((Object)content).isNotInstanceOf(LastHttpContent.class);
        content.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.finish());
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)lastContent.content().isReadable());
        lastContent.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testPrematureClosureWithChunkedEncoding1() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)res.status());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"chunked", (Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING));
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
        ch.finish();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testPrematureClosureWithChunkedEncoding2() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n8\r\n12345678", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)res.status());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"chunked", (Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING));
        HttpContent content = (HttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"12345678", (Object)content.content().toString(CharsetUtil.US_ASCII));
        Assertions.assertThat((Object)content).isNotInstanceOf(LastHttpContent.class);
        content.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
        ch.finish();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testLastResponseWithEmptyHeaderAndEmptyContent() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)res.status());
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.finish());
        LastHttpContent content = (LastHttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)content.content().isReadable());
        content.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testLastResponseWithoutContentLengthHeader() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)res.status());
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[1024])});
        HttpContent content = (HttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)1024, (int)content.content().readableBytes());
        content.release();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.finish());
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)lastContent.content().isReadable());
        lastContent.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testLastResponseWithHeaderRemoveTrailingSpaces() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nX-Header: h2=h2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT       \r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)res.status());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"h2=h2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT", (Object)res.headers().get(HttpHeadersTestUtils.of("X-Header")));
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[1024])});
        HttpContent content = (HttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)1024, (int)content.content().readableBytes());
        content.release();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.finish());
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)lastContent.content().isReadable());
        lastContent.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testResetContentResponseWithTransferEncoding() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 205 Reset Content\r\nTransfer-Encoding: chunked\r\n\r\n0\r\n\r\n", (Charset)CharsetUtil.US_ASCII)}));
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.RESET_CONTENT, (Object)res.status());
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)lastContent.content().isReadable());
        lastContent.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testLastResponseWithTrailingHeader() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n0\r\nSet-Cookie: t1=t1v1\r\nSet-Cookie: t2=t2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)res.status());
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)lastContent.content().isReadable());
        HttpHeaders headers = lastContent.trailingHeaders();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)headers.names().size());
        List values = headers.getAll(HttpHeadersTestUtils.of("Set-Cookie"));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)values.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains("t1=t1v1"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains("t2=t2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT"));
        lastContent.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.finish());
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testLastResponseWithTrailingHeaderFragmented() {
        byte[] data = "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n0\r\nSet-Cookie: t1=t1v1\r\nSet-Cookie: t2=t2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT\r\n\r\n".getBytes(CharsetUtil.US_ASCII);
        for (int i = 1; i < data.length; ++i) {
            HttpResponseDecoderTest.testLastResponseWithTrailingHeaderFragmented(data, i);
        }
    }

    private static void testLastResponseWithTrailingHeaderFragmented(byte[] content, int fragmentSize) {
        int amount;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        int headerLength = 47;
        for (int a = 0; a < headerLength; a += amount) {
            amount = fragmentSize;
            if (a + amount > headerLength) {
                amount = headerLength - a;
            }
            boolean headerDone = a + amount == headerLength;
            org.junit.jupiter.api.Assertions.assertEquals((Object)headerDone, (Object)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])content, (int)a, (int)amount)}));
        }
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])content, (int)headerLength, (int)(content.length - headerLength))});
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)res.status());
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)lastContent.content().isReadable());
        HttpHeaders headers = lastContent.trailingHeaders();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)headers.names().size());
        List values = headers.getAll(HttpHeadersTestUtils.of("Set-Cookie"));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)values.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains("t1=t1v1"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains("t2=t2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT"));
        lastContent.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.finish());
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testResponseWithContentLength() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nContent-Length: 10\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        byte[] data = new byte[10];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)i;
        }
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data, (int)0, (int)(data.length / 2))});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data, (int)5, (int)(data.length / 2))});
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)res.status());
        HttpContent firstContent = (HttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)firstContent.content().readableBytes());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Unpooled.copiedBuffer((byte[])data, (int)0, (int)5), (Object)firstContent.content());
        firstContent.release();
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)lastContent.content().readableBytes());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Unpooled.copiedBuffer((byte[])data, (int)5, (int)5), (Object)lastContent.content());
        lastContent.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.finish());
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testResponseWithContentLengthFragmented() {
        byte[] data = "HTTP/1.1 200 OK\r\nContent-Length: 10\r\n\r\n".getBytes(CharsetUtil.US_ASCII);
        for (int i = 1; i < data.length; ++i) {
            HttpResponseDecoderTest.testResponseWithContentLengthFragmented(data, i);
        }
    }

    private static void testResponseWithContentLengthFragmented(byte[] header, int fragmentSize) {
        int amount;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        for (int a = 0; a < header.length; a += amount) {
            amount = fragmentSize;
            if (a + amount > header.length) {
                amount = header.length - a;
            }
            ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])header, (int)a, (int)amount)});
        }
        byte[] data = new byte[10];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)i;
        }
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data, (int)0, (int)(data.length / 2))});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data, (int)5, (int)(data.length / 2))});
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)res.status());
        HttpContent firstContent = (HttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)firstContent.content().readableBytes());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Unpooled.wrappedBuffer((byte[])data, (int)0, (int)5), (Object)firstContent.content());
        firstContent.release();
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)lastContent.content().readableBytes());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Unpooled.wrappedBuffer((byte[])data, (int)5, (int)5), (Object)lastContent.content());
        lastContent.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.finish());
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testOrderOfHeadersWithContentLength() {
        String requestStr = "HTTP/1.1 200 OK\r\nContent-Type: text/plain; charset=UTF-8\r\nContent-Length: 5\r\nConnection: close\r\n\r\nhello";
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpResponse response = (HttpResponse)channel.readInbound();
        ArrayList<String> headers = new ArrayList<String>();
        for (Map.Entry header : response.headers()) {
            headers.add((String)header.getKey());
        }
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("Content-Type", "Content-Length", "Connection"), headers, (String)"ordered headers");
    }

    @Test
    public void testWebSocketResponse() {
        byte[] data = "HTTP/1.1 101 WebSocket Protocol Handshake\r\nUpgrade: WebSocket\r\nConnection: Upgrade\r\nSec-WebSocket-Origin: http://localhost:8080\r\nSec-WebSocket-Location: ws://localhost/some/path\r\n\r\n1234567812345678".getBytes();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])data)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.SWITCHING_PROTOCOLS, (Object)res.status());
        HttpContent content = (HttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)16, (int)content.content().readableBytes());
        content.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.finish());
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebSocketResponseWithDataFollowing() {
        byte[] data = "HTTP/1.1 101 WebSocket Protocol Handshake\r\nUpgrade: WebSocket\r\nConnection: Upgrade\r\nSec-WebSocket-Origin: http://localhost:8080\r\nSec-WebSocket-Location: ws://localhost/some/path\r\n\r\n1234567812345678".getBytes();
        byte[] otherData = new byte[]{1, 2, 3, 4};
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[][])new byte[][]{data, otherData})});
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.SWITCHING_PROTOCOLS, (Object)res.status());
        HttpContent content = (HttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)16, (int)content.content().readableBytes());
        content.release();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.finish());
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])otherData);
        ByteBuf buffer = (ByteBuf)ch.readInbound();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)buffer);
        }
        finally {
            expected.release();
            if (buffer != null) {
                buffer.release();
            }
        }
    }

    @Test
    public void testGarbageHeaders() {
        byte[] data = "<html>\r\n<head><title>400 Bad Request</title></head>\r\n<body bgcolor=\"white\">\r\n<center><h1>400 Bad Request</h1></center>\r\n<hr><center>nginx/1.1.19</center>\r\n</body>\r\n</html>\r\n".getBytes();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_0, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((int)999, (int)res.status().code());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)res.decoderResult().isFailure());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)res.decoderResult().isFinished());
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data)});
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
        ch.finish();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testGarbageChunk() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        String responseWithIllegalChunk = "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\nNOT_A_CHUNK_LENGTH\r\n";
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)responseWithIllegalChunk, (Charset)CharsetUtil.US_ASCII)});
        org.junit.jupiter.api.Assertions.assertInstanceOf(HttpResponse.class, (Object)channel.readInbound());
        LastHttpContent invalidChunk = (LastHttpContent)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)invalidChunk.decoderResult().isFailure());
        invalidChunk.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)channel.readInbound());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testWhiteSpaceGarbageChunk() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        String responseWithIllegalChunk = "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n \r\n";
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)responseWithIllegalChunk, (Charset)CharsetUtil.US_ASCII)});
        org.junit.jupiter.api.Assertions.assertInstanceOf(HttpResponse.class, (Object)channel.readInbound());
        LastHttpContent invalidChunk = (LastHttpContent)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)invalidChunk.decoderResult().isFailure());
        invalidChunk.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)channel.readInbound());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testLeadingWhiteSpacesSemiColonGarbageChunk() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        String responseWithIllegalChunk = "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n  ;\r\n";
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)responseWithIllegalChunk, (Charset)CharsetUtil.US_ASCII)});
        org.junit.jupiter.api.Assertions.assertInstanceOf(HttpResponse.class, (Object)channel.readInbound());
        LastHttpContent invalidChunk = (LastHttpContent)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)invalidChunk.decoderResult().isFailure());
        invalidChunk.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)channel.readInbound());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testControlCharGarbageChunk() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        String responseWithIllegalChunk = "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n\u0000\r\n";
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)responseWithIllegalChunk, (Charset)CharsetUtil.US_ASCII)});
        org.junit.jupiter.api.Assertions.assertInstanceOf(HttpResponse.class, (Object)channel.readInbound());
        LastHttpContent invalidChunk = (LastHttpContent)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)invalidChunk.decoderResult().isFailure());
        invalidChunk.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)channel.readInbound());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testLeadingWhiteSpacesControlCharGarbageChunk() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        String responseWithIllegalChunk = "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n  \u0000\r\n";
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)responseWithIllegalChunk, (Charset)CharsetUtil.US_ASCII)});
        org.junit.jupiter.api.Assertions.assertInstanceOf(HttpResponse.class, (Object)channel.readInbound());
        LastHttpContent invalidChunk = (LastHttpContent)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)invalidChunk.decoderResult().isFailure());
        invalidChunk.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)channel.readInbound());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testGarbageChunkAfterWhiteSpaces() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        String responseWithIllegalChunk = "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n  12345N1 ;\r\n";
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)responseWithIllegalChunk, (Charset)CharsetUtil.US_ASCII)});
        org.junit.jupiter.api.Assertions.assertInstanceOf(HttpResponse.class, (Object)channel.readInbound());
        LastHttpContent invalidChunk = (LastHttpContent)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)invalidChunk.decoderResult().isFailure());
        invalidChunk.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)channel.readInbound());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    void mustRejectImproperlyTerminatedChunkExtensions() throws Exception {
        String requestStr = "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n2;\nxx\r\n1D\r\n0\r\n\r\nHTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n0\r\n\r\n";
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpResponse response = (HttpResponse)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)response.decoderResult().isFailure());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.headers().names().contains("Transfer-Encoding"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.headers().contains("Transfer-Encoding", "chunked", false));
        HttpContent content = (HttpContent)channel.readInbound();
        DecoderResult decoderResult = content.decoderResult();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)decoderResult.isFailure());
        Assertions.assertThat((Throwable)decoderResult.cause()).isInstanceOf(InvalidChunkExtensionException.class);
        content.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    void mustRejectImproperlyTerminatedChunkBodies() throws Exception {
        String requestStr = "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n5\r\nAAAAXX1D\r\n0\r\nHTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n0\r\n\r\n";
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpResponse response = (HttpResponse)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)response.decoderResult().isFailure());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.headers().names().contains("Transfer-Encoding"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.headers().contains("Transfer-Encoding", "chunked", false));
        HttpContent content = (HttpContent)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)content.decoderResult().isFailure());
        content.release();
        content = (HttpContent)channel.readInbound();
        DecoderResult decoderResult = content.decoderResult();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)decoderResult.isFailure());
        Assertions.assertThat((Throwable)decoderResult.cause()).isInstanceOf(InvalidChunkTerminationException.class);
        content.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testConnectionClosedBeforeHeadersReceived() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        String responseInitialLine = "HTTP/1.1 200 OK\r\n";
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)responseInitialLine, (Charset)CharsetUtil.US_ASCII)}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.finish());
        HttpMessage message = (HttpMessage)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)message.decoderResult().isFailure());
        org.junit.jupiter.api.Assertions.assertInstanceOf(PrematureChannelClosureException.class, (Object)message.decoderResult().cause());
        org.junit.jupiter.api.Assertions.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testTrailerWithEmptyLineInSeparateBuffer() {
        HttpResponseDecoder decoder = new HttpResponseDecoder();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder});
        String headers = "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\nTrailer: My-Trailer\r\n";
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])headers.getBytes(CharsetUtil.US_ASCII))}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])"\r\n".getBytes(CharsetUtil.US_ASCII))}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"0\r\n", (Charset)CharsetUtil.US_ASCII)}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"My-Trailer: 42\r\n", (Charset)CharsetUtil.US_ASCII)}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)}));
        HttpResponse response = (HttpResponse)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)response.headers().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"chunked", (Object)response.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"My-Trailer", (Object)response.headers().get((CharSequence)HttpHeaderNames.TRAILER));
        LastHttpContent lastContent = (LastHttpContent)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)lastContent.trailingHeaders().size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"42", (Object)lastContent.trailingHeaders().get("My-Trailer"));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)lastContent.content().readableBytes());
        lastContent.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testWhitespace() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        String requestStr = "HTTP/1.1 200 OK\r\nTransfer-Encoding : chunked\r\nHost: netty.io\r\n\r\n";
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpResponse response = (HttpResponse)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)response.decoderResult().isFailure());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpHeaderValues.CHUNKED.toString(), (Object)response.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"netty.io", (Object)response.headers().get((CharSequence)HttpHeaderNames.HOST));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testHttpMessageDecoderResult() {
        String responseStr = "HTTP/1.1 200 OK\r\nContent-Length: 11\r\nConnection: close\r\n\r\nLorem ipsum";
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)responseStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpResponse response = (HttpResponse)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.decoderResult().isSuccess());
        org.junit.jupiter.api.Assertions.assertInstanceOf(HttpMessageDecoderResult.class, (Object)response.decoderResult());
        HttpMessageDecoderResult decoderResult = (HttpMessageDecoderResult)response.decoderResult();
        org.junit.jupiter.api.Assertions.assertEquals((int)15, (int)decoderResult.initialLineLength());
        org.junit.jupiter.api.Assertions.assertEquals((int)35, (int)decoderResult.headerSize());
        org.junit.jupiter.api.Assertions.assertEquals((int)50, (int)decoderResult.totalSize());
        HttpContent c = (HttpContent)channel.readInbound();
        c.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testStatusWithoutReasonPhrase() {
        String responseStr = "HTTP/1.1 200 \r\nContent-Length: 0\r\n\r\n";
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)responseStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpResponse response = (HttpResponse)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.decoderResult().isSuccess());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)response.status());
        HttpContent c = (HttpContent)channel.readInbound();
        c.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testHeaderNameStartsWithControlChar1c() {
        this.testHeaderNameStartsWithControlChar(28);
    }

    @Test
    public void testHeaderNameStartsWithControlChar1d() {
        this.testHeaderNameStartsWithControlChar(29);
    }

    @Test
    public void testHeaderNameStartsWithControlChar1e() {
        this.testHeaderNameStartsWithControlChar(30);
    }

    @Test
    public void testHeaderNameStartsWithControlChar1f() {
        this.testHeaderNameStartsWithControlChar(31);
    }

    @Test
    public void testHeaderNameStartsWithControlChar0c() {
        this.testHeaderNameStartsWithControlChar(12);
    }

    private void testHeaderNameStartsWithControlChar(int controlChar) {
        ByteBuf responseBuffer = Unpooled.buffer();
        responseBuffer.writeCharSequence((CharSequence)"HTTP/1.1 200 OK\r\nHost: netty.io\r\n", CharsetUtil.US_ASCII);
        responseBuffer.writeByte(controlChar);
        responseBuffer.writeCharSequence((CharSequence)"Transfer-Encoding: chunked\r\n\r\n", CharsetUtil.US_ASCII);
        HttpResponseDecoderTest.testInvalidHeaders0(responseBuffer);
    }

    @Test
    public void testHeaderNameEndsWithControlChar1c() {
        HttpResponseDecoderTest.testHeaderNameEndsWithControlChar(28);
    }

    @Test
    public void testHeaderNameEndsWithControlChar1d() {
        HttpResponseDecoderTest.testHeaderNameEndsWithControlChar(29);
    }

    @Test
    public void testHeaderNameEndsWithControlChar1e() {
        HttpResponseDecoderTest.testHeaderNameEndsWithControlChar(30);
    }

    @Test
    public void testHeaderNameEndsWithControlChar1f() {
        HttpResponseDecoderTest.testHeaderNameEndsWithControlChar(31);
    }

    @Test
    public void testHeaderNameEndsWithControlChar0c() {
        HttpResponseDecoderTest.testHeaderNameEndsWithControlChar(12);
    }

    private static void testHeaderNameEndsWithControlChar(int controlChar) {
        ByteBuf responseBuffer = Unpooled.buffer();
        responseBuffer.writeCharSequence((CharSequence)"HTTP/1.1 200 OK\r\nHost: netty.io\r\n", CharsetUtil.US_ASCII);
        responseBuffer.writeCharSequence((CharSequence)"Transfer-Encoding", CharsetUtil.US_ASCII);
        responseBuffer.writeByte(controlChar);
        responseBuffer.writeCharSequence((CharSequence)": chunked\r\n\r\n", CharsetUtil.US_ASCII);
        HttpResponseDecoderTest.testInvalidHeaders0(responseBuffer);
    }

    @ParameterizedTest
    @ValueSource(strings={"HTP/1.1", "HTTP", "HTTP/1x", "Something/1.1", "HTTP/1", "HTTP/1.11", "HTTP/11.1", "HTTP/A.1", "HTTP/1.B"})
    public void testInvalidVersion(String version) {
        HttpResponseDecoderTest.testInvalidHeaders0(Unpooled.copiedBuffer((CharSequence)(version + " 200 OK\r\nHost: whatever\r\n\r\n"), (Charset)CharsetUtil.US_ASCII));
    }

    private static void testInvalidHeaders0(ByteBuf responseBuffer) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{responseBuffer}));
        HttpResponse response = (HttpResponse)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertInstanceOf(IllegalArgumentException.class, (Object)response.decoderResult().cause());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)response.decoderResult().isFailure());
        ReferenceCountUtil.release((Object)response);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }
}

