/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpDecoderConfig;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpMessageDecoderResult;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.InvalidChunkExtensionException;
import io.netty.handler.codec.http.InvalidChunkTerminationException;
import io.netty.handler.codec.http.InvalidLineSeparatorException;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.TooLongHttpHeaderException;
import io.netty.handler.codec.http.TooLongHttpLineException;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class HttpRequestDecoderTest {
    private static final byte[] CONTENT_CRLF_DELIMITERS = HttpRequestDecoderTest.createContent("\r\n");
    private static final byte[] CONTENT_LF_DELIMITERS = HttpRequestDecoderTest.createContent("\n");
    private static final byte[] CONTENT_MIXED_DELIMITERS = HttpRequestDecoderTest.createContent("\r\n", "\n");
    private static final int CONTENT_LENGTH = 8;

    private static byte[] createContent(String ... lineDelimiters) {
        String lineDelimiter2;
        String lineDelimiter;
        if (lineDelimiters.length == 2) {
            lineDelimiter = lineDelimiters[0];
            lineDelimiter2 = lineDelimiters[1];
        } else {
            lineDelimiter = lineDelimiters[0];
            lineDelimiter2 = lineDelimiters[0];
        }
        return ("GET /some/path?foo=bar&wibble=eek HTTP/1.1\r\nUpgrade: WebSocket" + lineDelimiter2 + "Connection: Upgrade" + lineDelimiter + "Host: localhost" + lineDelimiter2 + "Accept: */*" + lineDelimiter + "Origin: http://localhost:8080" + lineDelimiter + "Sec-WebSocket-Key1: 10  28 8V7 8 48     0" + lineDelimiter2 + "Sec-WebSocket-Key2: 8 Xt754O3Q3QW 0   _60" + lineDelimiter + "Content-Length: " + 8 + lineDelimiter2 + "\r\n12345678").getBytes(CharsetUtil.US_ASCII);
    }

    @Test
    public void testDecodeWholeRequestAtOnceCRLFDelimiters() {
        HttpRequestDecoderTest.testDecodeWholeRequestAtOnce(CONTENT_CRLF_DELIMITERS);
    }

    @Test
    public void testDecodeWholeRequestAtOnceLFDelimiters() {
        HttpRequestDecoderTest.testDecodeWholeRequestAtOnce(CONTENT_LF_DELIMITERS);
    }

    @Test
    public void testDecodeWholeRequestAtOnceMixedDelimiters() {
        HttpRequestDecoderTest.testDecodeWholeRequestAtOnce(CONTENT_MIXED_DELIMITERS);
    }

    @Test
    public void testDecodeWholeRequestAtOnceFailesWithLFDelimiters() {
        HttpRequestDecoderTest.testDecodeWholeRequestAtOnce(CONTENT_LF_DELIMITERS, 8192, true, true);
    }

    @Test
    public void testDecodeWholeRequestAtOnceFailsWithMixedDelimiters() {
        HttpRequestDecoderTest.testDecodeWholeRequestAtOnce(CONTENT_MIXED_DELIMITERS, 8192, true, true);
    }

    @Test
    public void testDecodeWholeRequestAtOnceMixedDelimitersWithIntegerOverflowOnMaxBodySize() {
        HttpRequestDecoderTest.testDecodeWholeRequestAtOnce(CONTENT_MIXED_DELIMITERS, Integer.MAX_VALUE, false, false);
        HttpRequestDecoderTest.testDecodeWholeRequestAtOnce(CONTENT_MIXED_DELIMITERS, 0x7FFFFFFE, false, false);
    }

    private static void testDecodeWholeRequestAtOnce(byte[] content) {
        HttpRequestDecoderTest.testDecodeWholeRequestAtOnce(content, 8192, false, false);
    }

    private static void testDecodeWholeRequestAtOnce(byte[] content, int maxHeaderSize, boolean strictLineParsing, boolean expectFailure) {
        HttpDecoderConfig config = new HttpDecoderConfig().setMaxHeaderSize(maxHeaderSize).setStrictLineParsing(strictLineParsing);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(config)});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])content)}));
        HttpRequest req = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)req);
        if (expectFailure) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)req.decoderResult().isFailure());
            Assertions.assertThat((Throwable)req.decoderResult().cause()).isInstanceOf(InvalidLineSeparatorException.class);
        } else {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)req.decoderResult().isFailure());
            HttpRequestDecoderTest.checkHeaders(req.headers());
            LastHttpContent c = (LastHttpContent)channel.readInbound();
            org.junit.jupiter.api.Assertions.assertEquals((int)8, (int)c.content().readableBytes());
            org.junit.jupiter.api.Assertions.assertEquals((Object)Unpooled.wrappedBuffer((byte[])content, (int)(content.length - 8), (int)8), (Object)c.content().readSlice(8));
            c.release();
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
        org.junit.jupiter.api.Assertions.assertNull((Object)channel.readInbound());
    }

    private static void checkHeaders(HttpHeaders headers) {
        org.junit.jupiter.api.Assertions.assertEquals((int)8, (int)headers.names().size());
        HttpRequestDecoderTest.checkHeader(headers, "Upgrade", "WebSocket");
        HttpRequestDecoderTest.checkHeader(headers, "Connection", "Upgrade");
        HttpRequestDecoderTest.checkHeader(headers, "Host", "localhost");
        HttpRequestDecoderTest.checkHeader(headers, "Accept", "*/*");
        HttpRequestDecoderTest.checkHeader(headers, "Origin", "http://localhost:8080");
        HttpRequestDecoderTest.checkHeader(headers, "Sec-WebSocket-Key1", "10  28 8V7 8 48     0");
        HttpRequestDecoderTest.checkHeader(headers, "Sec-WebSocket-Key2", "8 Xt754O3Q3QW 0   _60");
        HttpRequestDecoderTest.checkHeader(headers, "Content-Length", String.valueOf(8));
    }

    private static void checkHeader(HttpHeaders headers, String name, String value) {
        List header1 = headers.getAll(HttpHeadersTestUtils.of(name));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)header1.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)value, header1.get(0));
    }

    @Test
    public void testDecodeWholeRequestInMultipleStepsCRLFDelimiters() {
        HttpRequestDecoderTest.testDecodeWholeRequestInMultipleSteps(CONTENT_CRLF_DELIMITERS, true, false);
    }

    @Test
    public void testDecodeWholeRequestInMultipleStepsLFDelimiters() {
        HttpRequestDecoderTest.testDecodeWholeRequestInMultipleSteps(CONTENT_LF_DELIMITERS, false, false);
    }

    @Test
    public void testDecodeWholeRequestInMultipleStepsMixedDelimiters() {
        HttpRequestDecoderTest.testDecodeWholeRequestInMultipleSteps(CONTENT_MIXED_DELIMITERS, false, false);
    }

    @Test
    public void testDecodeWholeRequestInMultipleStepsFailsWithLFDelimiters() {
        HttpRequestDecoderTest.testDecodeWholeRequestInMultipleSteps(CONTENT_LF_DELIMITERS, true, true);
    }

    @Test
    public void testDecodeWholeRequestInMultipleStepsFailsWithMixedDelimiters() {
        HttpRequestDecoderTest.testDecodeWholeRequestInMultipleSteps(CONTENT_MIXED_DELIMITERS, true, true);
    }

    private static void testDecodeWholeRequestInMultipleSteps(byte[] content, boolean strictLineParsing, boolean expectFailure) {
        for (int i = 1; i < content.length; ++i) {
            HttpRequestDecoderTest.testDecodeWholeRequestInMultipleSteps(content, i, strictLineParsing, expectFailure);
        }
    }

    private static void testDecodeWholeRequestInMultipleSteps(byte[] content, int fragmentSize, boolean strictLineParsing, boolean expectFailure) {
        int amount;
        HttpDecoderConfig config = new HttpDecoderConfig().setStrictLineParsing(strictLineParsing);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(config)});
        int headerLength = content.length - 8;
        for (int a = 0; a < headerLength; a += amount) {
            amount = fragmentSize;
            if (a + amount > headerLength) {
                amount = headerLength - a;
            }
            channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])content, (int)a, (int)amount)});
        }
        for (int i = 8; i > 0; --i) {
            channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])content, (int)(content.length - i), (int)1)});
        }
        HttpRequest req = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)req);
        if (expectFailure) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)req.decoderResult().isFailure());
            Assertions.assertThat((Throwable)req.decoderResult().cause()).isInstanceOf(InvalidLineSeparatorException.class);
            return;
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)req.decoderResult().isFailure());
        HttpRequestDecoderTest.checkHeaders(req.headers());
        for (int i = 8; i > 1; --i) {
            HttpContent c = (HttpContent)channel.readInbound();
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)c.content().readableBytes());
            org.junit.jupiter.api.Assertions.assertEquals((byte)content[content.length - i], (byte)c.content().readByte());
            c.release();
        }
        LastHttpContent c = (LastHttpContent)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)c.content().readableBytes());
        org.junit.jupiter.api.Assertions.assertEquals((byte)content[content.length - 1], (byte)c.content().readByte());
        c.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
        org.junit.jupiter.api.Assertions.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testMultiLineHeader() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        String crlf = "\r\n";
        String request = "GET /some/path HTTP/1.1" + crlf + "Host: localhost" + crlf + "MyTestHeader: part1" + crlf + "              newLinePart2" + crlf + "MyTestHeader2: part21" + crlf + "\t            newLinePart22" + crlf + crlf;
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)request, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest req = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"part1 newLinePart2", (Object)req.headers().get(HttpHeadersTestUtils.of("MyTestHeader")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"part21 newLinePart22", (Object)req.headers().get(HttpHeadersTestUtils.of("MyTestHeader2")));
        LastHttpContent c = (LastHttpContent)channel.readInbound();
        c.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
        org.junit.jupiter.api.Assertions.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testEmptyHeaderValue() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        String crlf = "\r\n";
        String request = "GET /some/path HTTP/1.1" + crlf + "Host: localhost" + crlf + "EmptyHeader:" + crlf + crlf;
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)request, (Charset)CharsetUtil.US_ASCII)});
        HttpRequest req = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)req.headers().get(HttpHeadersTestUtils.of("EmptyHeader")));
    }

    @Test
    public void test100Continue() {
        HttpRequestDecoder decoder = new HttpRequestDecoder();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder});
        String oversized = "PUT /file HTTP/1.1\r\nExpect: 100-continue\r\nContent-Length: 1048576000\r\n\r\n";
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)oversized, (Charset)CharsetUtil.US_ASCII)});
        org.junit.jupiter.api.Assertions.assertInstanceOf(HttpRequest.class, (Object)channel.readInbound());
        decoder.reset();
        String query = "GET /max-file-size HTTP/1.1\r\n\r\n";
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)query, (Charset)CharsetUtil.US_ASCII)});
        org.junit.jupiter.api.Assertions.assertInstanceOf(HttpRequest.class, (Object)channel.readInbound());
        org.junit.jupiter.api.Assertions.assertInstanceOf(LastHttpContent.class, (Object)channel.readInbound());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void test100ContinueWithBadClient() {
        HttpRequestDecoder decoder = new HttpRequestDecoder();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder});
        String oversized = "PUT /file HTTP/1.1\r\nExpect: 100-continue\r\nContent-Length: 1048576000\r\n\r\nWAY_TOO_LARGE_DATA_BEGINS";
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)oversized, (Charset)CharsetUtil.US_ASCII)});
        org.junit.jupiter.api.Assertions.assertInstanceOf(HttpRequest.class, (Object)channel.readInbound());
        HttpContent prematureData = (HttpContent)channel.readInbound();
        prematureData.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)channel.readInbound());
        decoder.reset();
        String query = "GET /max-file-size HTTP/1.1\r\n\r\n";
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)query, (Charset)CharsetUtil.US_ASCII)});
        org.junit.jupiter.api.Assertions.assertInstanceOf(HttpRequest.class, (Object)channel.readInbound());
        org.junit.jupiter.api.Assertions.assertInstanceOf(LastHttpContent.class, (Object)channel.readInbound());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testMessagesSplitBetweenMultipleBuffers() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        String crlf = "\r\n";
        String str1 = "GET /some/path HTTP/1.1" + crlf + "Host: localhost1" + crlf + crlf + "GET /some/other/path HTTP/1.0" + crlf + "Hos";
        String str2 = "t: localhost2" + crlf + "content-length: 0" + crlf + crlf;
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)str1, (Charset)CharsetUtil.US_ASCII)});
        HttpRequest req = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)req.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/some/path", (Object)req.uri());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)req.headers().size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)AsciiString.contentEqualsIgnoreCase((CharSequence)"localhost1", (CharSequence)req.headers().get((CharSequence)HttpHeaderNames.HOST)));
        LastHttpContent cnt = (LastHttpContent)channel.readInbound();
        cnt.release();
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)str2, (Charset)CharsetUtil.US_ASCII)});
        req = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpVersion.HTTP_1_0, (Object)req.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/some/other/path", (Object)req.uri());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)req.headers().size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)AsciiString.contentEqualsIgnoreCase((CharSequence)"localhost2", (CharSequence)req.headers().get((CharSequence)HttpHeaderNames.HOST)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)AsciiString.contentEqualsIgnoreCase((CharSequence)"0", (CharSequence)req.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH)));
        cnt = (LastHttpContent)channel.readInbound();
        cnt.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finishAndReleaseAll());
    }

    @Test
    public void testTooLargeInitialLine() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(10, 1024, 1024)});
        String requestStr = "GET /some/path HTTP/1.1\r\nHost: localhost1\r\n\r\n";
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest request = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)request.decoderResult().isFailure());
        org.junit.jupiter.api.Assertions.assertInstanceOf(TooLongHttpLineException.class, (Object)request.decoderResult().cause());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testTooLargeInitialLineWithWSOnly() {
        HttpRequestDecoderTest.testTooLargeInitialLineWithControlCharsOnly("                    ");
    }

    @Test
    public void testTooLargeInitialLineWithCRLFOnly() {
        HttpRequestDecoderTest.testTooLargeInitialLineWithControlCharsOnly("\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n");
    }

    private static void testTooLargeInitialLineWithControlCharsOnly(String controlChars) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(15, 1024, 1024)});
        String requestStr = controlChars + "GET / HTTP/1.1\r\nHost: localhost1\r\n\r\n";
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest request = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)request.decoderResult().isFailure());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(request.decoderResult().cause() instanceof TooLongHttpLineException));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testInitialLineWithLeadingControlChars() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        String crlf = "\r\n";
        String request = crlf + "GET /some/path HTTP/1.1" + crlf + "Host: localhost" + crlf + crlf;
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)request, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest req = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpMethod.GET, (Object)req.method());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"/some/path", (Object)req.uri());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)req.protocolVersion());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.finishAndReleaseAll());
    }

    @Test
    public void testTooLargeHeaders() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(1024, 10, 1024)});
        String requestStr = "GET /some/path HTTP/1.1\r\nHost: localhost1\r\n\r\n";
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest request = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)request.decoderResult().isFailure());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(request.decoderResult().cause() instanceof TooLongHttpHeaderException));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    void testTotalHeaderLimit() throws Exception {
        String requestStr = "GET /some/path HTTP/1.1\r\nHost: a.b\r\na1: b\r\na2: b\r\n\r\n";
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(1024, 18, 1024)});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest request = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)request.decoderResult().isFailure());
        org.junit.jupiter.api.Assertions.assertInstanceOf(TooLongHttpHeaderException.class, (Object)request.decoderResult().cause());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
        channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(1024, 19, 1024)});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        request = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)request.decoderResult().isSuccess());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a.b", (Object)request.headers().get("Host"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", (Object)request.headers().get("a1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", (Object)request.headers().get("a2"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)LastHttpContent.EMPTY_LAST_CONTENT, (Object)channel.readInbound());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testHeaderNameStartsWithControlChar1c() {
        this.testHeaderNameStartsWithControlChar(28);
    }

    @Test
    public void testHeaderNameStartsWithControlChar1d() {
        this.testHeaderNameStartsWithControlChar(29);
    }

    @Test
    public void testHeaderNameStartsWithControlChar1e() {
        this.testHeaderNameStartsWithControlChar(30);
    }

    @Test
    public void testHeaderNameStartsWithControlChar1f() {
        this.testHeaderNameStartsWithControlChar(31);
    }

    @Test
    public void testHeaderNameStartsWithControlChar0c() {
        this.testHeaderNameStartsWithControlChar(12);
    }

    private void testHeaderNameStartsWithControlChar(int controlChar) {
        ByteBuf requestBuffer = Unpooled.buffer();
        requestBuffer.writeCharSequence((CharSequence)"GET /some/path HTTP/1.1\r\nHost: netty.io\r\n", CharsetUtil.US_ASCII);
        requestBuffer.writeByte(controlChar);
        requestBuffer.writeCharSequence((CharSequence)"Transfer-Encoding: chunked\r\n\r\n", CharsetUtil.US_ASCII);
        HttpRequestDecoderTest.testInvalidHeaders0(requestBuffer);
    }

    @Test
    public void testHeaderNameEndsWithControlChar1c() {
        this.testHeaderNameEndsWithControlChar(28);
    }

    @Test
    public void testHeaderNameEndsWithControlChar1d() {
        this.testHeaderNameEndsWithControlChar(29);
    }

    @Test
    public void testHeaderNameEndsWithControlChar1e() {
        this.testHeaderNameEndsWithControlChar(30);
    }

    @Test
    public void testHeaderNameEndsWithControlChar1f() {
        this.testHeaderNameEndsWithControlChar(31);
    }

    @Test
    public void testHeaderNameEndsWithControlChar0c() {
        this.testHeaderNameEndsWithControlChar(12);
    }

    private void testHeaderNameEndsWithControlChar(int controlChar) {
        ByteBuf requestBuffer = Unpooled.buffer();
        requestBuffer.writeCharSequence((CharSequence)"GET /some/path HTTP/1.1\r\nHost: netty.io\r\n", CharsetUtil.US_ASCII);
        requestBuffer.writeCharSequence((CharSequence)"Transfer-Encoding", CharsetUtil.US_ASCII);
        requestBuffer.writeByte(controlChar);
        requestBuffer.writeCharSequence((CharSequence)": chunked\r\n\r\n", CharsetUtil.US_ASCII);
        HttpRequestDecoderTest.testInvalidHeaders0(requestBuffer);
    }

    @Test
    public void testWhitespace() {
        String requestStr = "GET /some/path HTTP/1.1\r\nTransfer-Encoding : chunked\r\nHost: netty.io\r\n\r\n";
        HttpRequestDecoderTest.testInvalidHeaders0(requestStr);
    }

    @Test
    public void testWhitespaceInTransferEncoding01() {
        String requestStr = "GET /some/path HTTP/1.1\r\nTransfer-Encoding : chunked\r\nContent-Length: 1\r\nHost: netty.io\r\n\r\na";
        HttpRequestDecoderTest.testInvalidHeaders0(requestStr);
    }

    @Test
    public void testWhitespaceInTransferEncoding02() {
        String requestStr = "POST / HTTP/1.1Transfer-Encoding : chunked\r\nHost: target.comContent-Length: 65\r\n\r\n0\r\n\r\nGET /maliciousRequest HTTP/1.1\r\nHost: evilServer.com\r\nFoo: x";
        HttpRequestDecoderTest.testInvalidHeaders0(requestStr);
    }

    @Test
    public void testHeaderWithNoValueAndMissingColon() {
        String requestStr = "GET /some/path HTTP/1.1\r\nContent-Length: 0\r\nHost:\r\nnetty.io\r\n\r\n";
        HttpRequestDecoderTest.testInvalidHeaders0(requestStr);
    }

    @Test
    public void testMultipleContentLengthHeaders() {
        String requestStr = "GET /some/path HTTP/1.1\r\nContent-Length: 1\r\nContent-Length: 0\r\n\r\nb";
        HttpRequestDecoderTest.testInvalidHeaders0(requestStr);
    }

    @Test
    public void testMultipleContentLengthHeaders2() {
        String requestStr = "GET /some/path HTTP/1.1\r\nContent-Length: 1\r\nConnection: close\r\nContent-Length: 0\r\n\r\nb";
        HttpRequestDecoderTest.testInvalidHeaders0(requestStr);
    }

    @Test
    public void testContentLengthHeaderWithCommaValue() {
        String requestStr = "GET /some/path HTTP/1.1\r\nContent-Length: 1,1\r\n\r\nb";
        HttpRequestDecoderTest.testInvalidHeaders0(requestStr);
    }

    @Test
    public void testMultipleContentLengthHeadersWithFolding() {
        String requestStr = "POST / HTTP/1.1\r\nHost: example.com\r\nConnection: close\r\nContent-Length: 5\r\nContent-Length:\r\n\t6\r\n\r\n123456";
        HttpRequestDecoderTest.testInvalidHeaders0(requestStr);
    }

    @Test
    public void testContentLengthAndTransferEncodingHeadersWithVerticalTab() {
        HttpRequestDecoderTest.testContentLengthAndTransferEncodingHeadersWithInvalidSeparator('\u000b', false);
        HttpRequestDecoderTest.testContentLengthAndTransferEncodingHeadersWithInvalidSeparator('\u000b', true);
    }

    @Test
    public void testContentLengthAndTransferEncodingHeadersWithCR() {
        HttpRequestDecoderTest.testContentLengthAndTransferEncodingHeadersWithInvalidSeparator('\r', false);
        HttpRequestDecoderTest.testContentLengthAndTransferEncodingHeadersWithInvalidSeparator('\r', true);
    }

    private static void testContentLengthAndTransferEncodingHeadersWithInvalidSeparator(char separator, boolean extraLine) {
        String requestStr = "POST / HTTP/1.1\r\nHost: example.com\r\nConnection: close\r\nContent-Length: 9\r\nTransfer-Encoding:" + separator + "chunked\r\n\r\n" + (extraLine ? "0\r\n\r\n" : "") + "something\r\n\r\n";
        HttpRequestDecoderTest.testInvalidHeaders0(requestStr);
    }

    @Test
    public void testContentLengthHeaderAndChunked() {
        String requestStr = "POST / HTTP/1.1\r\nHost: example.com\r\nConnection: close\r\nContent-Length: 5\r\nTransfer-Encoding: chunked\r\n\r\n0\r\n\r\n";
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest request = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)request.decoderResult().isFailure());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)request.headers().names().contains("Transfer-Encoding"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)request.headers().contains("Transfer-Encoding", "chunked", false));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)request.headers().contains("Content-Length"));
        LastHttpContent c = (LastHttpContent)channel.readInbound();
        c.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    void mustRejectImproperlyTerminatedChunkExtensions() throws Exception {
        String requestStr = "GET /one HTTP/1.1\r\nHost: localhost\r\nTransfer-Encoding: chunked\r\n\r\n2;\nxx\r\n45\r\n0\r\n\r\nGET /two HTTP/1.1\r\nHost: localhost\r\nTransfer-Encoding: chunked\r\n\r\n0\r\n\r\n";
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest request = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)request.decoderResult().isFailure());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)request.headers().names().contains("Transfer-Encoding"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)request.headers().contains("Transfer-Encoding", "chunked", false));
        HttpContent content = (HttpContent)channel.readInbound();
        DecoderResult decoderResult = content.decoderResult();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)decoderResult.isFailure());
        Assertions.assertThat((Throwable)decoderResult.cause()).isInstanceOf(InvalidChunkExtensionException.class);
        content.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    void mustRejectImproperlyTerminatedChunkBodies() throws Exception {
        String requestStr = "GET /one HTTP/1.1\r\nHost: localhost\r\nTransfer-Encoding: chunked\r\n\r\n5\r\nAAAAAXX45\r\n0\r\nGET /two HTTP/1.1\r\nHost: localhost\r\nTransfer-Encoding: chunked\r\n\r\n0\r\n\r\n";
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest request = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)request.decoderResult().isFailure());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)request.headers().names().contains("Transfer-Encoding"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)request.headers().contains("Transfer-Encoding", "chunked", false));
        HttpContent content = (HttpContent)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)content.decoderResult().isFailure());
        content.release();
        content = (HttpContent)channel.readInbound();
        DecoderResult decoderResult = content.decoderResult();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)decoderResult.isFailure());
        Assertions.assertThat((Throwable)decoderResult.cause()).isInstanceOf(InvalidChunkTerminationException.class);
        content.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testOrderOfHeadersWithContentLength() {
        String requestStr = "GET /some/path HTTP/1.1\r\nHost: example.com\r\nContent-Length: 5\r\nConnection: close\r\n\r\nhello";
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest request = (HttpRequest)channel.readInbound();
        ArrayList<String> headers = new ArrayList<String>();
        for (Map.Entry header : request.headers()) {
            headers.add((String)header.getKey());
        }
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("Host", "Content-Length", "Connection"), headers, (String)"ordered headers");
    }

    @Test
    public void testHttpMessageDecoderResult() {
        String requestStr = "PUT /some/path HTTP/1.1\r\nContent-Length: 11\r\nConnection: close\r\n\r\nLorem ipsum";
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest request = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)request.decoderResult().isSuccess());
        org.junit.jupiter.api.Assertions.assertInstanceOf(HttpMessageDecoderResult.class, (Object)request.decoderResult());
        HttpMessageDecoderResult decoderResult = (HttpMessageDecoderResult)request.decoderResult();
        org.junit.jupiter.api.Assertions.assertEquals((int)23, (int)decoderResult.initialLineLength());
        org.junit.jupiter.api.Assertions.assertEquals((int)35, (int)decoderResult.headerSize());
        org.junit.jupiter.api.Assertions.assertEquals((int)58, (int)decoderResult.totalSize());
        HttpContent c = (HttpContent)channel.readInbound();
        c.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    void headerValuesMayBeBracketedByZeroOrMoreWhitespace() throws Exception {
        String requestStr = "GET / HTTP/1.1\r\nHost:example.com\r\nX-0-Header:  x0\r\nX-1-Header:\tx1\r\nX-2-Header: \t x2\r\nX-3-Header:x3\t \r\n\r\n";
        HttpRequestDecoder decoder = new HttpRequestDecoder();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest request = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)request.decoderResult().isSuccess());
        HttpHeaders headers = request.headers();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"example.com", (Object)headers.get("Host"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"x0", (Object)headers.get("X-0-Header"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"x1", (Object)headers.get("X-1-Header"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"x2", (Object)headers.get("X-2-Header"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"x3", (Object)headers.get("X-3-Header"));
        LastHttpContent last = (LastHttpContent)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)LastHttpContent.EMPTY_LAST_CONTENT, (Object)last);
        last.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testChunkSizeOverflow() {
        String requestStr = "PUT /some/path HTTP/1.1\r\nTransfer-Encoding: chunked\r\n\r\n8ccccccc\r\n";
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest request = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)request.decoderResult().isSuccess());
        HttpContent c = (HttpContent)channel.readInbound();
        c.release();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)c.decoderResult().isFailure());
        org.junit.jupiter.api.Assertions.assertInstanceOf(NumberFormatException.class, (Object)c.decoderResult().cause());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testChunkSizeOverflow2() {
        String requestStr = "PUT /some/path HTTP/1.1\r\nTransfer-Encoding: chunked\r\n\r\nbbbbbbbe;\r\n\r\n";
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpRequest request = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)request.decoderResult().isSuccess());
        HttpContent c = (HttpContent)channel.readInbound();
        c.release();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)c.decoderResult().isFailure());
        org.junit.jupiter.api.Assertions.assertInstanceOf(NumberFormatException.class, (Object)c.decoderResult().cause());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    @ParameterizedTest
    @ValueSource(strings={"HTP/1.1", "HTTP", "HTTP/1x", "Something/1.1", "HTTP/1", "HTTP/1.11", "HTTP/11.1", "HTTP/A.1", "HTTP/1.B"})
    public void testInvalidVersion(String version) {
        HttpRequestDecoderTest.testInvalidHeaders0("GET / " + version + "\r\nHost: whatever\r\n\r\n");
    }

    @ParameterizedTest
    @ValueSource(strings={"\r", "\u000b", "\f"})
    public void testHeaderValueWithInvalidSuffix(String suffix) {
        HttpRequestDecoderTest.testInvalidHeaders0("GET / HTTP/1.1\r\nHost: whatever\r\nTest-Key: test-value" + suffix + "\r\n\r\n");
    }

    @Test
    public void testLeadingWhitespaceInFirstHeaderName() {
        HttpRequestDecoderTest.testInvalidHeaders0("POST / HTTP/1.1\r\n\tContent-Length: 1\r\n\r\nX");
    }

    @Test
    public void testNulInInitialLine() {
        HttpRequestDecoderTest.testInvalidHeaders0("GET / HTTP/1.1\u0000\r\nHost: whatever\r\n\r\n");
    }

    @Test
    void reentrantClose() {
        String requestStr = "GET / HTTP/1.1\r\nHost: example.com\r\nContent-Length: 0\r\n\r\nGET / HTTP/1.1\r\nHost: example.com\r\nContent-Length: 0\r\n\r\n";
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(), new ChannelInboundHandlerAdapter(){
            private int i;

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                if (this.i == 0) {
                    org.junit.jupiter.api.Assertions.assertInstanceOf(HttpRequest.class, (Object)msg);
                } else if (this.i == 1) {
                    org.junit.jupiter.api.Assertions.assertInstanceOf(LastHttpContent.class, (Object)msg);
                } else if (this.i == 2) {
                    org.junit.jupiter.api.Assertions.assertInstanceOf(HttpRequest.class, (Object)msg);
                } else if (this.i == 3) {
                    org.junit.jupiter.api.Assertions.assertInstanceOf(LastHttpContent.class, (Object)msg);
                }
                ReferenceCountUtil.release((Object)msg);
                if (++this.i == 1) {
                    ctx.close();
                }
            }
        }});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }

    private static void testInvalidHeaders0(String requestStr) {
        HttpRequestDecoderTest.testInvalidHeaders0(Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII));
    }

    private static void testInvalidHeaders0(ByteBuf requestBuffer) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{requestBuffer}));
        HttpRequest request = (HttpRequest)channel.readInbound();
        org.junit.jupiter.api.Assertions.assertInstanceOf(IllegalArgumentException.class, (Object)request.decoderResult().cause());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)request.decoderResult().isFailure());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.finish());
    }
}

