/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.DecoderResultProvider;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.TooLongHttpContentException;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mockito;

public class HttpObjectAggregatorTest {
    @Test
    public void testAggregate() {
        HttpObjectAggregator aggr = new HttpObjectAggregator(0x100000);
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{aggr});
        DefaultHttpRequest message = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http://localhost");
        message.headers().set(HttpHeadersTestUtils.of("X-Test"), (Object)true);
        DefaultHttpContent chunk1 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII));
        DefaultHttpContent chunk2 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test2", (Charset)CharsetUtil.US_ASCII));
        DefaultLastHttpContent chunk3 = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER);
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{message}));
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk1}));
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk2}));
        Assertions.assertTrue((boolean)embedder.writeInbound(new Object[]{chunk3}));
        Assertions.assertTrue((boolean)embedder.finish());
        FullHttpRequest aggregatedMessage = (FullHttpRequest)embedder.readInbound();
        Assertions.assertNotNull((Object)aggregatedMessage);
        Assertions.assertEquals((long)(chunk1.content().readableBytes() + chunk2.content().readableBytes()), (long)HttpUtil.getContentLength((HttpMessage)aggregatedMessage));
        Assertions.assertEquals((Object)Boolean.TRUE.toString(), (Object)aggregatedMessage.headers().get(HttpHeadersTestUtils.of("X-Test")));
        HttpObjectAggregatorTest.checkContentBuffer(aggregatedMessage);
        Assertions.assertNull((Object)embedder.readInbound());
    }

    private static void checkContentBuffer(FullHttpRequest aggregatedMessage) {
        CompositeByteBuf buffer = (CompositeByteBuf)aggregatedMessage.content();
        Assertions.assertEquals((int)2, (int)buffer.numComponents());
        List buffers = buffer.decompose(0, buffer.capacity());
        Assertions.assertEquals((int)2, (int)buffers.size());
        for (ByteBuf buf : buffers) {
            Assertions.assertFalse((boolean)(buf instanceof CompositeByteBuf));
        }
        aggregatedMessage.release();
    }

    @Test
    public void testAggregateWithTrailer() {
        HttpObjectAggregator aggr = new HttpObjectAggregator(0x100000);
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{aggr});
        DefaultHttpRequest message = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http://localhost");
        message.headers().set(HttpHeadersTestUtils.of("X-Test"), (Object)true);
        HttpUtil.setTransferEncodingChunked((HttpMessage)message, (boolean)true);
        DefaultHttpContent chunk1 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII));
        DefaultHttpContent chunk2 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test2", (Charset)CharsetUtil.US_ASCII));
        DefaultLastHttpContent trailer = new DefaultLastHttpContent();
        trailer.trailingHeaders().set(HttpHeadersTestUtils.of("X-Trailer"), (Object)true);
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{message}));
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk1}));
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk2}));
        Assertions.assertTrue((boolean)embedder.writeInbound(new Object[]{trailer}));
        Assertions.assertTrue((boolean)embedder.finish());
        FullHttpRequest aggregatedMessage = (FullHttpRequest)embedder.readInbound();
        Assertions.assertNotNull((Object)aggregatedMessage);
        Assertions.assertEquals((long)(chunk1.content().readableBytes() + chunk2.content().readableBytes()), (long)HttpUtil.getContentLength((HttpMessage)aggregatedMessage));
        Assertions.assertEquals((Object)Boolean.TRUE.toString(), (Object)aggregatedMessage.headers().get(HttpHeadersTestUtils.of("X-Test")));
        Assertions.assertEquals((Object)Boolean.TRUE.toString(), (Object)aggregatedMessage.trailingHeaders().get(HttpHeadersTestUtils.of("X-Trailer")));
        HttpObjectAggregatorTest.checkContentBuffer(aggregatedMessage);
        Assertions.assertNull((Object)embedder.readInbound());
    }

    @Test
    public void testOversizedRequest() {
        final EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpObjectAggregator(4)});
        DefaultHttpRequest message = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "http://localhost");
        DefaultHttpContent chunk1 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII));
        DefaultHttpContent chunk2 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test2", (Charset)CharsetUtil.US_ASCII));
        LastHttpContent chunk3 = LastHttpContent.EMPTY_LAST_CONTENT;
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{message}));
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk1}));
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk2}));
        FullHttpResponse response = (FullHttpResponse)embedder.readOutbound();
        Assertions.assertEquals((Object)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, (Object)response.status());
        Assertions.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        Assertions.assertFalse((boolean)embedder.isOpen());
        Assertions.assertThrows(ClosedChannelException.class, (Executable)new Executable((HttpContent)chunk3){
            final /* synthetic */ HttpContent val$chunk3;
            {
                this.val$chunk3 = httpContent;
            }

            public void execute() {
                embedder.writeInbound(new Object[]{this.val$chunk3});
            }
        });
        Assertions.assertFalse((boolean)embedder.finish());
    }

    @Test
    public void testOversizedRequestWithContentLengthAndDecoder() {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(), new HttpObjectAggregator(4, false)});
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"PUT /upload HTTP/1.1\r\nContent-Length: 5\r\n\r\n", (Charset)CharsetUtil.US_ASCII)}));
        Assertions.assertNull((Object)embedder.readInbound());
        FullHttpResponse response = (FullHttpResponse)embedder.readOutbound();
        Assertions.assertEquals((Object)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, (Object)response.status());
        Assertions.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        Assertions.assertTrue((boolean)embedder.isOpen());
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4})}));
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{5})}));
        Assertions.assertNull((Object)embedder.readOutbound());
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"PUT /upload HTTP/1.1\r\nContent-Length: 2\r\n\r\n", (Charset)CharsetUtil.US_ASCII)}));
        Assertions.assertEquals((Object)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, (Object)response.status());
        Assertions.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        Assertions.assertInstanceOf(LastHttpContent.class, (Object)response);
        ReferenceCountUtil.release((Object)response);
        Assertions.assertTrue((boolean)embedder.isOpen());
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])new byte[]{1})}));
        Assertions.assertNull((Object)embedder.readOutbound());
        Assertions.assertTrue((boolean)embedder.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])new byte[]{2})}));
        Assertions.assertNull((Object)embedder.readOutbound());
        FullHttpRequest request = (FullHttpRequest)embedder.readInbound();
        Assertions.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)request.protocolVersion());
        Assertions.assertEquals((Object)HttpMethod.PUT, (Object)request.method());
        Assertions.assertEquals((Object)"/upload", (Object)request.uri());
        Assertions.assertEquals((long)2L, (long)HttpUtil.getContentLength((HttpMessage)request));
        byte[] actual = new byte[request.content().readableBytes()];
        request.content().readBytes(actual);
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2}, (byte[])actual);
        request.release();
        Assertions.assertFalse((boolean)embedder.finish());
    }

    @Test
    public void testOversizedRequestWithoutKeepAlive() {
        DefaultHttpRequest message = new DefaultHttpRequest(HttpVersion.HTTP_1_0, HttpMethod.PUT, "http://localhost");
        HttpUtil.setContentLength((HttpMessage)message, (long)5L);
        HttpObjectAggregatorTest.checkOversizedRequest((HttpRequest)message);
    }

    @Test
    public void testOversizedRequestWithContentLength() {
        DefaultHttpRequest message = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "http://localhost");
        HttpUtil.setContentLength((HttpMessage)message, (long)5L);
        HttpObjectAggregatorTest.checkOversizedRequest((HttpRequest)message);
    }

    private static void checkOversizedRequest(HttpRequest message) {
        final EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpObjectAggregator(4)});
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{message}));
        HttpResponse response = (HttpResponse)embedder.readOutbound();
        Assertions.assertEquals((Object)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, (Object)response.status());
        Assertions.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        Assertions.assertInstanceOf(LastHttpContent.class, (Object)response);
        ReferenceCountUtil.release((Object)response);
        if (HttpObjectAggregatorTest.serverShouldCloseConnection(message, response)) {
            Assertions.assertFalse((boolean)embedder.isOpen());
            Assertions.assertThrows(ClosedChannelException.class, (Executable)new Executable(){

                public void execute() {
                    embedder.writeInbound(new Object[]{new DefaultHttpContent(Unpooled.EMPTY_BUFFER)});
                }
            });
            Assertions.assertFalse((boolean)embedder.finish());
        } else {
            Assertions.assertTrue((boolean)embedder.isOpen());
            Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{new DefaultHttpContent(Unpooled.copiedBuffer((byte[])new byte[8]))}));
            Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{new DefaultHttpContent(Unpooled.copiedBuffer((byte[])new byte[8]))}));
            DefaultHttpRequest message2 = new DefaultHttpRequest(HttpVersion.HTTP_1_0, HttpMethod.PUT, "http://localhost");
            HttpUtil.setContentLength((HttpMessage)message, (long)2L);
            Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{message2}));
            Assertions.assertNull((Object)embedder.readOutbound());
            Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{new DefaultHttpContent(Unpooled.copiedBuffer((byte[])new byte[]{1}))}));
            Assertions.assertNull((Object)embedder.readOutbound());
            Assertions.assertTrue((boolean)embedder.writeInbound(new Object[]{new DefaultLastHttpContent(Unpooled.copiedBuffer((byte[])new byte[]{2}))}));
            Assertions.assertNull((Object)embedder.readOutbound());
            FullHttpRequest request = (FullHttpRequest)embedder.readInbound();
            Assertions.assertEquals((Object)message2.protocolVersion(), (Object)request.protocolVersion());
            Assertions.assertEquals((Object)message2.method(), (Object)request.method());
            Assertions.assertEquals((Object)message2.uri(), (Object)request.uri());
            Assertions.assertEquals((long)2L, (long)HttpUtil.getContentLength((HttpMessage)request));
            byte[] actual = new byte[request.content().readableBytes()];
            request.content().readBytes(actual);
            Assertions.assertArrayEquals((byte[])new byte[]{1, 2}, (byte[])actual);
            request.release();
            Assertions.assertFalse((boolean)embedder.finish());
        }
    }

    private static boolean serverShouldCloseConnection(HttpRequest message, HttpResponse response) {
        if (!HttpUtil.isKeepAlive((HttpMessage)response)) {
            return true;
        }
        if (HttpUtil.is100ContinueExpected((HttpMessage)message)) {
            return false;
        }
        return !HttpUtil.isKeepAlive((HttpMessage)message);
    }

    @Test
    public void testOversizedResponse() {
        final EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpObjectAggregator(4)});
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        DefaultHttpContent chunk1 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII));
        DefaultHttpContent chunk2 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test2", (Charset)CharsetUtil.US_ASCII));
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{message}));
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk1}));
        Assertions.assertThrows(TooLongHttpContentException.class, (Executable)new Executable((HttpContent)chunk2){
            final /* synthetic */ HttpContent val$chunk2;
            {
                this.val$chunk2 = httpContent;
            }

            public void execute() {
                embedder.writeInbound(new Object[]{this.val$chunk2});
            }
        });
        Assertions.assertFalse((boolean)embedder.isOpen());
        Assertions.assertFalse((boolean)embedder.finish());
    }

    @Test
    public void testInvalidConstructorUsage() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new HttpObjectAggregator(-1);
            }
        });
    }

    @Test
    public void testInvalidMaxCumulationBufferComponents() {
        final HttpObjectAggregator aggr = new HttpObjectAggregator(Integer.MAX_VALUE);
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                aggr.setMaxCumulationBufferComponents(1);
            }
        });
    }

    @Test
    public void testSetMaxCumulationBufferComponentsAfterInit() throws Exception {
        final HttpObjectAggregator aggr = new HttpObjectAggregator(Integer.MAX_VALUE);
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        aggr.handlerAdded(ctx);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx});
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() {
                aggr.setMaxCumulationBufferComponents(10);
            }
        });
    }

    @Test
    public void testAggregateTransferEncodingChunked() {
        HttpObjectAggregator aggr = new HttpObjectAggregator(0x100000);
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{aggr});
        DefaultHttpRequest message = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "http://localhost");
        message.headers().set(HttpHeadersTestUtils.of("X-Test"), (Object)true);
        message.headers().set(HttpHeadersTestUtils.of("Transfer-Encoding"), (Object)HttpHeadersTestUtils.of("Chunked"));
        DefaultHttpContent chunk1 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII));
        DefaultHttpContent chunk2 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test2", (Charset)CharsetUtil.US_ASCII));
        LastHttpContent chunk3 = LastHttpContent.EMPTY_LAST_CONTENT;
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{message}));
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk1}));
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk2}));
        Assertions.assertTrue((boolean)embedder.writeInbound(new Object[]{chunk3}));
        Assertions.assertTrue((boolean)embedder.finish());
        FullHttpRequest aggregatedMessage = (FullHttpRequest)embedder.readInbound();
        Assertions.assertNotNull((Object)aggregatedMessage);
        Assertions.assertEquals((long)(chunk1.content().readableBytes() + chunk2.content().readableBytes()), (long)HttpUtil.getContentLength((HttpMessage)aggregatedMessage));
        Assertions.assertEquals((Object)Boolean.TRUE.toString(), (Object)aggregatedMessage.headers().get(HttpHeadersTestUtils.of("X-Test")));
        HttpObjectAggregatorTest.checkContentBuffer(aggregatedMessage);
        Assertions.assertNull((Object)embedder.readInbound());
    }

    @Test
    public void testBadRequest() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(), new HttpObjectAggregator(0x100000)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"GET / HTTP/1.0 with extra\r\n", (Charset)CharsetUtil.UTF_8)});
        Object inbound = ch.readInbound();
        Assertions.assertInstanceOf(FullHttpRequest.class, (Object)inbound);
        Assertions.assertTrue((boolean)((DecoderResultProvider)inbound).decoderResult().isFailure());
        Assertions.assertNull((Object)ch.readInbound());
        ch.finish();
    }

    @Test
    public void testBadResponse() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder(), new HttpObjectAggregator(0x100000)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.0 BAD_CODE Bad Server\r\n", (Charset)CharsetUtil.UTF_8)});
        Object inbound = ch.readInbound();
        Assertions.assertInstanceOf(FullHttpResponse.class, (Object)inbound);
        Assertions.assertTrue((boolean)((DecoderResultProvider)inbound).decoderResult().isFailure());
        Assertions.assertNull((Object)ch.readInbound());
        ch.finish();
    }

    @Test
    public void testOversizedRequestWith100Continue() {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpObjectAggregator(8)});
        DefaultHttpRequest message = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "http://localhost");
        HttpUtil.set100ContinueExpected((HttpMessage)message, (boolean)true);
        HttpUtil.setContentLength((HttpMessage)message, (long)16L);
        DefaultHttpContent chunk1 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"some", (Charset)CharsetUtil.US_ASCII));
        DefaultHttpContent chunk2 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII));
        LastHttpContent chunk3 = LastHttpContent.EMPTY_LAST_CONTENT;
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{message}));
        FullHttpResponse response = (FullHttpResponse)embedder.readOutbound();
        Assertions.assertEquals((Object)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, (Object)response.status());
        Assertions.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk1}));
        Assertions.assertTrue((boolean)embedder.isOpen());
        DefaultHttpRequest message2 = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "http://localhost");
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{message2}));
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk2}));
        Assertions.assertTrue((boolean)embedder.writeInbound(new Object[]{chunk3}));
        FullHttpRequest fullMsg = (FullHttpRequest)embedder.readInbound();
        Assertions.assertNotNull((Object)fullMsg);
        Assertions.assertEquals((long)(chunk2.content().readableBytes() + chunk3.content().readableBytes()), (long)HttpUtil.getContentLength((HttpMessage)fullMsg));
        Assertions.assertEquals((long)HttpUtil.getContentLength((HttpMessage)fullMsg), (long)fullMsg.content().readableBytes());
        fullMsg.release();
        Assertions.assertFalse((boolean)embedder.finish());
    }

    @Test
    public void testUnsupportedExpectHeaderExpectation() {
        HttpObjectAggregatorTest.runUnsupportedExceptHeaderExceptionTest(true);
        HttpObjectAggregatorTest.runUnsupportedExceptHeaderExceptionTest(false);
    }

    private static void runUnsupportedExceptHeaderExceptionTest(boolean close) {
        int maxContentLength = 4;
        HttpObjectAggregator aggregator = close ? new HttpObjectAggregator(4, true) : new HttpObjectAggregator(4);
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(), aggregator});
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"GET / HTTP/1.1\r\nExpect: chocolate=yummy\r\nContent-Length: 100\r\n\r\n", (Charset)CharsetUtil.US_ASCII)}));
        Assertions.assertNull((Object)embedder.readInbound());
        FullHttpResponse response = (FullHttpResponse)embedder.readOutbound();
        Assertions.assertEquals((Object)HttpResponseStatus.EXPECTATION_FAILED, (Object)response.status());
        Assertions.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        response.release();
        if (close) {
            Assertions.assertFalse((boolean)embedder.isOpen());
        } else {
            Assertions.assertTrue((boolean)embedder.isOpen());
            Assertions.assertTrue((boolean)embedder.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"GET / HTTP/1.1\r\n\r\n", (Charset)CharsetUtil.US_ASCII)}));
            FullHttpRequest request = (FullHttpRequest)embedder.readInbound();
            Assertions.assertEquals((Object)HttpMethod.GET, (Object)request.method());
            Assertions.assertEquals((Object)"/", (Object)request.uri());
            Assertions.assertEquals((int)0, (int)request.content().readableBytes());
            request.release();
        }
        Assertions.assertFalse((boolean)embedder.finish());
    }

    @Test
    public void testValidRequestWith100ContinueAndDecoder() {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(), new HttpObjectAggregator(100)});
        embedder.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"GET /upload HTTP/1.1\r\nExpect: 100-continue\r\nContent-Length: 0\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        FullHttpResponse response = (FullHttpResponse)embedder.readOutbound();
        Assertions.assertEquals((Object)HttpResponseStatus.CONTINUE, (Object)response.status());
        FullHttpRequest request = (FullHttpRequest)embedder.readInbound();
        Assertions.assertFalse((boolean)request.headers().contains((CharSequence)HttpHeaderNames.EXPECT));
        request.release();
        response.release();
        Assertions.assertFalse((boolean)embedder.finish());
    }

    @Test
    public void testOversizedRequestWith100ContinueAndDecoder() {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(), new HttpObjectAggregator(4)});
        embedder.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"PUT /upload HTTP/1.1\r\nExpect: 100-continue\r\nContent-Length: 100\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        Assertions.assertNull((Object)embedder.readInbound());
        FullHttpResponse response = (FullHttpResponse)embedder.readOutbound();
        Assertions.assertEquals((Object)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, (Object)response.status());
        Assertions.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        Assertions.assertTrue((boolean)embedder.isOpen());
        embedder.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"GET /max-upload-size HTTP/1.1\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        FullHttpRequest request = (FullHttpRequest)embedder.readInbound();
        Assertions.assertEquals((Object)HttpMethod.GET, (Object)request.method());
        Assertions.assertEquals((Object)"/max-upload-size", (Object)request.uri());
        Assertions.assertEquals((int)0, (int)request.content().readableBytes());
        request.release();
        Assertions.assertFalse((boolean)embedder.finish());
    }

    @Test
    public void testOversizedRequestWith100ContinueAndDecoderCloseConnection() {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(), new HttpObjectAggregator(4, true)});
        embedder.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"PUT /upload HTTP/1.1\r\nExpect: 100-continue\r\nContent-Length: 100\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        Assertions.assertNull((Object)embedder.readInbound());
        FullHttpResponse response = (FullHttpResponse)embedder.readOutbound();
        Assertions.assertEquals((Object)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, (Object)response.status());
        Assertions.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        Assertions.assertFalse((boolean)embedder.isOpen());
        Assertions.assertFalse((boolean)embedder.finish());
    }

    @Test
    public void testRequestAfterOversized100ContinueAndDecoder() {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(), new HttpObjectAggregator(15)});
        DefaultHttpRequest message = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "http://localhost");
        HttpUtil.set100ContinueExpected((HttpMessage)message, (boolean)true);
        HttpUtil.setContentLength((HttpMessage)message, (long)16L);
        DefaultHttpContent chunk1 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"some", (Charset)CharsetUtil.US_ASCII));
        DefaultHttpContent chunk2 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII));
        LastHttpContent chunk3 = LastHttpContent.EMPTY_LAST_CONTENT;
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{message}));
        FullHttpResponse response = (FullHttpResponse)embedder.readOutbound();
        Assertions.assertEquals((Object)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, (Object)response.status());
        Assertions.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk1}));
        Assertions.assertTrue((boolean)embedder.isOpen());
        DefaultHttpRequest message2 = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "http://localhost");
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{message2}));
        Assertions.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk2}));
        Assertions.assertTrue((boolean)embedder.writeInbound(new Object[]{chunk3}));
        FullHttpRequest fullMsg = (FullHttpRequest)embedder.readInbound();
        Assertions.assertNotNull((Object)fullMsg);
        Assertions.assertEquals((long)(chunk2.content().readableBytes() + chunk3.content().readableBytes()), (long)HttpUtil.getContentLength((HttpMessage)fullMsg));
        Assertions.assertEquals((long)HttpUtil.getContentLength((HttpMessage)fullMsg), (long)fullMsg.content().readableBytes());
        fullMsg.release();
        Assertions.assertFalse((boolean)embedder.finish());
    }

    @Test
    public void testReplaceAggregatedRequest() {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpObjectAggregator(0x100000)});
        Exception boom = new Exception("boom");
        DefaultHttpRequest req = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http://localhost");
        req.setDecoderResult(DecoderResult.failure((Throwable)boom));
        Assertions.assertTrue((embedder.writeInbound(new Object[]{req}) && embedder.finish() ? 1 : 0) != 0);
        FullHttpRequest aggregatedReq = (FullHttpRequest)embedder.readInbound();
        FullHttpRequest replacedReq = aggregatedReq.replace(Unpooled.EMPTY_BUFFER);
        Assertions.assertEquals((Object)replacedReq.decoderResult(), (Object)aggregatedReq.decoderResult());
        aggregatedReq.release();
        replacedReq.release();
    }

    @Test
    public void testReplaceAggregatedResponse() {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpObjectAggregator(0x100000)});
        Exception boom = new Exception("boom");
        DefaultHttpResponse rep = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        rep.setDecoderResult(DecoderResult.failure((Throwable)boom));
        Assertions.assertTrue((embedder.writeInbound(new Object[]{rep}) && embedder.finish() ? 1 : 0) != 0);
        FullHttpResponse aggregatedRep = (FullHttpResponse)embedder.readInbound();
        FullHttpResponse replacedRep = aggregatedRep.replace(Unpooled.EMPTY_BUFFER);
        Assertions.assertEquals((Object)replacedRep.decoderResult(), (Object)aggregatedRep.decoderResult());
        aggregatedRep.release();
        replacedRep.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectiveRequestAggregation() {
        HttpObjectAggregator myPostAggregator = new HttpObjectAggregator(0x100000){

            protected boolean isStartMessage(HttpObject msg) throws Exception {
                HttpRequest request;
                HttpMethod method;
                return msg instanceof HttpRequest && (method = (request = (HttpRequest)msg).method()).equals((Object)HttpMethod.POST);
            }
        };
        try (EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{myPostAggregator});){
            DefaultHttpRequest request1 = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/");
            DefaultHttpContent content1 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"Hello, World!", (Charset)CharsetUtil.UTF_8));
            request1.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.TEXT_PLAIN);
            Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{request1, content1, LastHttpContent.EMPTY_LAST_CONTENT}));
            Object msg1 = channel.readInbound();
            try {
                Assertions.assertTrue((boolean)(msg1 instanceof FullHttpRequest));
            }
            finally {
                ReferenceCountUtil.release((Object)msg1);
            }
            DefaultHttpRequest request2 = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "/");
            DefaultHttpContent content2 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"Hello, World!", (Charset)CharsetUtil.UTF_8));
            request2.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.TEXT_PLAIN);
            try {
                Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{request2, content2, LastHttpContent.EMPTY_LAST_CONTENT}));
                Assertions.assertSame((Object)request2, (Object)channel.readInbound());
                Assertions.assertSame((Object)content2, (Object)channel.readInbound());
                Assertions.assertSame((Object)LastHttpContent.EMPTY_LAST_CONTENT, (Object)channel.readInbound());
            }
            finally {
                ReferenceCountUtil.release((Object)request2);
                ReferenceCountUtil.release((Object)content2);
            }
            Assertions.assertFalse((boolean)channel.finish());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectiveResponseAggregation() {
        HttpObjectAggregator myTextAggregator = new HttpObjectAggregator(0x100000){

            protected boolean isStartMessage(HttpObject msg) throws Exception {
                HttpResponse response;
                HttpHeaders headers;
                String contentType;
                return msg instanceof HttpResponse && AsciiString.contentEqualsIgnoreCase((CharSequence)(contentType = (headers = (response = (HttpResponse)msg).headers()).get((CharSequence)HttpHeaderNames.CONTENT_TYPE)), (CharSequence)HttpHeaderValues.TEXT_PLAIN);
            }
        };
        try (EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{myTextAggregator});){
            DefaultHttpResponse response1 = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            DefaultHttpContent content1 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"Hello, World!", (Charset)CharsetUtil.UTF_8));
            response1.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.TEXT_PLAIN);
            Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{response1, content1, LastHttpContent.EMPTY_LAST_CONTENT}));
            Object msg1 = channel.readInbound();
            try {
                Assertions.assertTrue((boolean)(msg1 instanceof FullHttpResponse));
            }
            finally {
                ReferenceCountUtil.release((Object)msg1);
            }
            DefaultHttpResponse response2 = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            DefaultHttpContent content2 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"{key: 'value'}", (Charset)CharsetUtil.UTF_8));
            response2.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
            try {
                Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{response2, content2, LastHttpContent.EMPTY_LAST_CONTENT}));
                Assertions.assertSame((Object)response2, (Object)channel.readInbound());
                Assertions.assertSame((Object)content2, (Object)channel.readInbound());
                Assertions.assertSame((Object)LastHttpContent.EMPTY_LAST_CONTENT, (Object)channel.readInbound());
            }
            finally {
                ReferenceCountUtil.release((Object)response2);
                ReferenceCountUtil.release((Object)content2);
            }
            Assertions.assertFalse((boolean)channel.finish());
        }
    }

    @Test
    public void testPrematureClosureWithChunkedEncodingAndAggregator() {
        final EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder(), new HttpObjectAggregator(1024)});
        Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n8\r\n12345678", (Charset)CharsetUtil.US_ASCII)}));
        Assertions.assertThrows(PrematureChannelClosureException.class, (Executable)new Executable(){

            public void execute() {
                ch.finish();
            }
        });
    }
}

