/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class HttpHeadersTest {
    @Test
    public void testRemoveTransferEncodingIgnoreCase() {
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"Chunked");
        Assertions.assertFalse((boolean)message.headers().isEmpty());
        HttpUtil.setTransferEncodingChunked((HttpMessage)message, (boolean)false);
        Assertions.assertTrue((boolean)message.headers().isEmpty());
    }

    @Test
    public void testGetOperations() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        headers.add(HttpHeadersTestUtils.of("Foo"), (Object)HttpHeadersTestUtils.of("1"));
        headers.add(HttpHeadersTestUtils.of("Foo"), (Object)HttpHeadersTestUtils.of("2"));
        Assertions.assertEquals((Object)"1", (Object)headers.get(HttpHeadersTestUtils.of("Foo")));
        List values = headers.getAll(HttpHeadersTestUtils.of("Foo"));
        Assertions.assertEquals((int)2, (int)values.size());
        Assertions.assertEquals((Object)"1", values.get(0));
        Assertions.assertEquals((Object)"2", values.get(1));
    }

    @Test
    public void testEqualsIgnoreCase() {
        Assertions.assertTrue((boolean)AsciiString.contentEqualsIgnoreCase(null, null));
        Assertions.assertFalse((boolean)AsciiString.contentEqualsIgnoreCase(null, (CharSequence)"foo"));
        Assertions.assertFalse((boolean)AsciiString.contentEqualsIgnoreCase((CharSequence)"bar", null));
        Assertions.assertTrue((boolean)AsciiString.contentEqualsIgnoreCase((CharSequence)"FoO", (CharSequence)"fOo"));
    }

    @Test
    public void testSetNullHeaderValueValidate() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders(true);
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable((HttpHeaders)headers){
            final /* synthetic */ HttpHeaders val$headers;
            {
                this.val$headers = httpHeaders;
            }

            public void execute() {
                this.val$headers.set(HttpHeadersTestUtils.of("test"), (Object)null);
            }
        });
    }

    @Test
    public void testSetNullHeaderValueNotValidate() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders(false);
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable((HttpHeaders)headers){
            final /* synthetic */ HttpHeaders val$headers;
            {
                this.val$headers = httpHeaders;
            }

            public void execute() {
                this.val$headers.set(HttpHeadersTestUtils.of("test"), (Object)null);
            }
        });
    }

    @Test
    public void testAddSelf() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders(false);
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable((HttpHeaders)headers){
            final /* synthetic */ HttpHeaders val$headers;
            {
                this.val$headers = httpHeaders;
            }

            public void execute() {
                this.val$headers.add(this.val$headers);
            }
        });
    }

    @Test
    public void testSetSelfIsNoOp() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders(false);
        headers.add("name", (Object)"value");
        headers.set((HttpHeaders)headers);
        Assertions.assertEquals((int)1, (int)headers.size());
    }
}

