/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentEncoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class HttpContentEncoderTest {
    @Test
    public void testSplitContent() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        ch.writeInbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")});
        ch.writeOutbound(new Object[]{new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK)});
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])new byte[3]))});
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])new byte[2]))});
        ch.writeOutbound(new Object[]{new DefaultLastHttpContent(Unpooled.wrappedBuffer((byte[])new byte[1]))});
        HttpContentEncoderTest.assertEncodedResponse(ch);
        HttpContent chunk = (HttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"3", (Object)chunk.content().toString(CharsetUtil.US_ASCII));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"2", (Object)chunk.content().toString(CharsetUtil.US_ASCII));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1", (Object)chunk.content().toString(CharsetUtil.US_ASCII));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)chunk.content().isReadable());
        org.junit.jupiter.api.Assertions.assertInstanceOf(LastHttpContent.class, (Object)chunk);
        chunk.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readOutbound());
    }

    @Test
    public void testChunkedContent() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        ch.writeInbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")});
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        ch.writeOutbound(new Object[]{res});
        HttpContentEncoderTest.assertEncodedResponse(ch);
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])new byte[3]))});
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])new byte[2]))});
        ch.writeOutbound(new Object[]{new DefaultLastHttpContent(Unpooled.wrappedBuffer((byte[])new byte[1]))});
        HttpContent chunk = (HttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"3", (Object)chunk.content().toString(CharsetUtil.US_ASCII));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"2", (Object)chunk.content().toString(CharsetUtil.US_ASCII));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1", (Object)chunk.content().toString(CharsetUtil.US_ASCII));
        org.junit.jupiter.api.Assertions.assertInstanceOf(HttpContent.class, (Object)chunk);
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)chunk.content().isReadable());
        org.junit.jupiter.api.Assertions.assertInstanceOf(LastHttpContent.class, (Object)chunk);
        chunk.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readOutbound());
    }

    @Test
    public void testChunkedContentWithTrailingHeader() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        ch.writeInbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")});
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        ch.writeOutbound(new Object[]{res});
        HttpContentEncoderTest.assertEncodedResponse(ch);
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])new byte[3]))});
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])new byte[2]))});
        DefaultLastHttpContent content = new DefaultLastHttpContent(Unpooled.wrappedBuffer((byte[])new byte[1]));
        content.trailingHeaders().set(HttpHeadersTestUtils.of("X-Test"), (Object)HttpHeadersTestUtils.of("Netty"));
        ch.writeOutbound(new Object[]{content});
        HttpContent chunk = (HttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"3", (Object)chunk.content().toString(CharsetUtil.US_ASCII));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"2", (Object)chunk.content().toString(CharsetUtil.US_ASCII));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1", (Object)chunk.content().toString(CharsetUtil.US_ASCII));
        org.junit.jupiter.api.Assertions.assertInstanceOf(HttpContent.class, (Object)chunk);
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)chunk.content().isReadable());
        org.junit.jupiter.api.Assertions.assertInstanceOf(LastHttpContent.class, (Object)chunk);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Netty", (Object)((LastHttpContent)chunk).trailingHeaders().get(HttpHeadersTestUtils.of("X-Test")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)DecoderResult.SUCCESS, (Object)res.decoderResult());
        chunk.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readOutbound());
    }

    @Test
    public void testFullContentWithContentLength() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        ch.writeInbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")});
        DefaultFullHttpResponse fullRes = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])new byte[42]));
        fullRes.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)42);
        ch.writeOutbound(new Object[]{fullRes});
        HttpResponse res = (HttpResponse)ch.readOutbound();
        Assertions.assertThat((Object)res).isNotInstanceOf(HttpContent.class);
        org.junit.jupiter.api.Assertions.assertNull((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"2", (Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test", (Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING));
        HttpContent c = (HttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)c.content().readableBytes());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"42", (Object)c.content().toString(CharsetUtil.US_ASCII));
        c.release();
        LastHttpContent last = (LastHttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)last.content().readableBytes());
        last.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readOutbound());
    }

    @Test
    public void testFullContent() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        ch.writeInbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")});
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])new byte[42]));
        ch.writeOutbound(new Object[]{res});
        HttpContentEncoderTest.assertEncodedResponse(ch);
        HttpContent c = (HttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)c.content().readableBytes());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"42", (Object)c.content().toString(CharsetUtil.US_ASCII));
        c.release();
        LastHttpContent last = (LastHttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)last.content().readableBytes());
        last.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readOutbound());
    }

    @Test
    public void testEmptySplitContent() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        ch.writeInbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")});
        ch.writeOutbound(new Object[]{new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK)});
        HttpContentEncoderTest.assertEncodedResponse(ch);
        ch.writeOutbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT});
        HttpContent chunk = (HttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"0", (Object)chunk.content().toString(CharsetUtil.US_ASCII));
        org.junit.jupiter.api.Assertions.assertInstanceOf(HttpContent.class, (Object)chunk);
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)chunk.content().isReadable());
        org.junit.jupiter.api.Assertions.assertInstanceOf(LastHttpContent.class, (Object)chunk);
        chunk.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readOutbound());
    }

    @Test
    public void testEmptyFullContent() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        ch.writeInbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")});
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.EMPTY_BUFFER);
        ch.writeOutbound(new Object[]{res});
        Object o = ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertInstanceOf(FullHttpResponse.class, (Object)o);
        res = (FullHttpResponse)o;
        org.junit.jupiter.api.Assertions.assertNull((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING));
        org.junit.jupiter.api.Assertions.assertNull((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)res.content().readableBytes());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)res.content().toString(CharsetUtil.US_ASCII));
        res.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readOutbound());
    }

    @Test
    public void testEmptyFullContentWithTrailer() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        ch.writeInbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")});
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.EMPTY_BUFFER);
        res.trailingHeaders().set(HttpHeadersTestUtils.of("X-Test"), (Object)HttpHeadersTestUtils.of("Netty"));
        ch.writeOutbound(new Object[]{res});
        Object o = ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertInstanceOf(FullHttpResponse.class, (Object)o);
        res = (FullHttpResponse)o;
        org.junit.jupiter.api.Assertions.assertNull((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING));
        org.junit.jupiter.api.Assertions.assertNull((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)res.content().readableBytes());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)res.content().toString(CharsetUtil.US_ASCII));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Netty", (Object)res.trailingHeaders().get(HttpHeadersTestUtils.of("X-Test")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)DecoderResult.SUCCESS, (Object)res.decoderResult());
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readOutbound());
    }

    @Test
    public void testEmptyHeadResponse() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.HEAD, "/");
        ch.writeInbound(new Object[]{req});
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        ch.writeOutbound(new Object[]{res});
        ch.writeOutbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT});
        HttpContentEncoderTest.assertEmptyResponse(ch);
    }

    @Test
    public void testHttp304Response() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
        req.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP);
        ch.writeInbound(new Object[]{req});
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
        res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        ch.writeOutbound(new Object[]{res});
        ch.writeOutbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT});
        HttpContentEncoderTest.assertEmptyResponse(ch);
    }

    @Test
    public void testConnect200Response() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.CONNECT, "google.com:80");
        ch.writeInbound(new Object[]{req});
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        ch.writeOutbound(new Object[]{res});
        ch.writeOutbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT});
        HttpContentEncoderTest.assertEmptyResponse(ch);
    }

    @Test
    public void testConnectFailureResponse() throws Exception {
        String content = "Not allowed by configuration";
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.CONNECT, "google.com:80");
        ch.writeInbound(new Object[]{req});
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED);
        res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        ch.writeOutbound(new Object[]{res});
        ch.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])content.getBytes(CharsetUtil.UTF_8)))});
        ch.writeOutbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT});
        HttpContentEncoderTest.assertEncodedResponse(ch);
        Object o = ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertInstanceOf(HttpContent.class, (Object)o);
        HttpContent chunk = (HttpContent)o;
        org.junit.jupiter.api.Assertions.assertEquals((Object)"28", (Object)chunk.content().toString(CharsetUtil.US_ASCII));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)chunk.content().isReadable());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"0", (Object)chunk.content().toString(CharsetUtil.US_ASCII));
        chunk.release();
        chunk = (HttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertInstanceOf(LastHttpContent.class, (Object)chunk);
        chunk.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readOutbound());
    }

    @Test
    public void testHttp1_0() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new TestEncoder()});
        DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_0, HttpMethod.GET, "/");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{req}));
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_0, HttpResponseStatus.OK);
        res.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)HttpHeaderValues.ZERO);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{res}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.finish());
        FullHttpRequest request = (FullHttpRequest)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)request.release());
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
        HttpResponse response = (HttpResponse)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)res, (Object)response);
        LastHttpContent content = (LastHttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)LastHttpContent.EMPTY_LAST_CONTENT, (Object)content);
        content.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readOutbound());
    }

    @Test
    public void testCleanupThrows() {
        HttpContentEncoder encoder = new HttpContentEncoder(){

            protected HttpContentEncoder.Result beginEncode(HttpResponse httpResponse, String acceptEncoding) throws Exception {
                return new HttpContentEncoder.Result("myencoding", new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        ctx.fireExceptionCaught((Throwable)new EncoderException());
                        ctx.fireChannelInactive();
                    }
                }}));
            }
        };
        final AtomicBoolean channelInactiveCalled = new AtomicBoolean();
        final EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{encoder, new ChannelInboundHandlerAdapter(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)channelInactiveCalled.compareAndSet(false, true));
                super.channelInactive(ctx);
            }
        }});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK)}));
        DefaultHttpContent content = new DefaultHttpContent(Unpooled.buffer().writeZero(10));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{content}));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)content.refCnt());
        org.junit.jupiter.api.Assertions.assertThrows(CodecException.class, (Executable)new Executable(){

            public void execute() {
                channel.finishAndReleaseAll();
            }
        });
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channelInactiveCalled.get());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)content.refCnt());
    }

    private static void assertEmptyResponse(EmbeddedChannel ch) {
        Object o = ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertInstanceOf(HttpResponse.class, (Object)o);
        HttpResponse res = (HttpResponse)o;
        Assertions.assertThat((Object)res).isNotInstanceOf(HttpContent.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"chunked", (Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING));
        org.junit.jupiter.api.Assertions.assertNull((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        HttpContent chunk = (HttpContent)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertInstanceOf(LastHttpContent.class, (Object)chunk);
        chunk.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readOutbound());
    }

    private static void assertEncodedResponse(EmbeddedChannel ch) {
        Object o = ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertInstanceOf(HttpResponse.class, (Object)o);
        HttpResponse res = (HttpResponse)o;
        Assertions.assertThat((Object)res).isNotInstanceOf(HttpContent.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"chunked", (Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING));
        org.junit.jupiter.api.Assertions.assertNull((Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test", (Object)res.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING));
    }

    private static final class TestEncoder
    extends HttpContentEncoder {
        private TestEncoder() {
        }

        protected HttpContentEncoder.Result beginEncode(HttpResponse httpResponse, String acceptEncoding) {
            return new HttpContentEncoder.Result("test", new EmbeddedChannel(new ChannelHandler[]{new MessageToByteEncoder<ByteBuf>(){

                protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
                    out.writeBytes(String.valueOf(in.readableBytes()).getBytes(CharsetUtil.US_ASCII));
                    in.skipBytes(in.readableBytes());
                }
            }}));
        }
    }
}

