/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class HttpClientCodecTest {
    private static final String EMPTY_RESPONSE = "HTTP/1.0 200 OK\r\nContent-Length: 0\r\n\r\n";
    private static final String RESPONSE = "HTTP/1.0 200 OK\r\nDate: Fri, 31 Dec 1999 23:59:59 GMT\r\nContent-Type: text/html\r\nContent-Length: 28\r\n\r\n<html><body></body></html>\r\n";
    private static final String INCOMPLETE_CHUNKED_RESPONSE = "HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nTransfer-Encoding: chunked\r\n\r\n5\r\nfirst\r\n6\r\nsecond\r\n0\r\n";
    private static final String CHUNKED_RESPONSE = "HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nTransfer-Encoding: chunked\r\n\r\n5\r\nfirst\r\n6\r\nsecond\r\n0\r\n\r\n";

    @Test
    public void testConnectWithResponseContent() {
        HttpClientCodec codec = new HttpClientCodec(4096, 8192, 8192, true);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{codec});
        HttpClientCodecTest.sendRequestAndReadResponse(ch, HttpMethod.CONNECT, RESPONSE);
        ch.finish();
    }

    @Test
    public void testFailsNotOnRequestResponseChunked() {
        HttpClientCodec codec = new HttpClientCodec(4096, 8192, 8192, true);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{codec});
        HttpClientCodecTest.sendRequestAndReadResponse(ch, HttpMethod.GET, CHUNKED_RESPONSE);
        ch.finish();
    }

    @Test
    public void testFailsOnMissingResponse() {
        HttpClientCodec codec = new HttpClientCodec(4096, 8192, 8192, true);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{codec});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http://localhost/")}));
        ByteBuf buffer = (ByteBuf)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)buffer);
        buffer.release();
        try {
            ch.finish();
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (CodecException e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(e instanceof PrematureChannelClosureException));
        }
    }

    @Test
    public void testFailsOnIncompleteChunkedResponse() {
        HttpClientCodec codec = new HttpClientCodec(4096, 8192, 8192, true);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{codec});
        ch.writeOutbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http://localhost/")});
        ByteBuf buffer = (ByteBuf)ch.readOutbound();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)buffer);
        buffer.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)INCOMPLETE_CHUNKED_RESPONSE, (Charset)CharsetUtil.ISO_8859_1)});
        org.junit.jupiter.api.Assertions.assertInstanceOf(HttpResponse.class, (Object)ch.readInbound());
        ((HttpContent)ch.readInbound()).release();
        ((HttpContent)ch.readInbound()).release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
        try {
            ch.finish();
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (CodecException e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(e instanceof PrematureChannelClosureException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerCloseSocketInputProvidesData() throws InterruptedException {
        ServerBootstrap sb = new ServerBootstrap();
        Bootstrap cb = new Bootstrap();
        final CountDownLatch serverChannelLatch = new CountDownLatch(1);
        final CountDownLatch responseReceivedLatch = new CountDownLatch(1);
        try {
            sb.group((EventLoopGroup)new MultiThreadIoEventLoopGroup(2, NioIoHandler.newFactory()));
            sb.channel(NioServerSocketChannel.class);
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpRequestDecoder(4096, 8192, 8192, true)});
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(4096)});
                    ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<FullHttpRequest>(){

                        protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) {
                            org.junit.jupiter.api.Assertions.assertTrue((boolean)(ctx.channel() instanceof SocketChannel));
                            final SocketChannel sChannel = (SocketChannel)ctx.channel();
                            sChannel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])"HTTP/1.0 200 OK\r\nDate: Fri, 31 Dec 1999 23:59:59 GMT\r\nContent-Type: text/html\r\n\r\n".getBytes(CharsetUtil.ISO_8859_1))).addListener((GenericFutureListener)new ChannelFutureListener(){

                                public void operationComplete(ChannelFuture future) throws Exception {
                                    org.junit.jupiter.api.Assertions.assertTrue((boolean)future.isSuccess());
                                    sChannel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])"<html><body>hello half closed!</body></html>\r\n".getBytes(CharsetUtil.ISO_8859_1))).addListener((GenericFutureListener)new ChannelFutureListener(){

                                        public void operationComplete(ChannelFuture future) throws Exception {
                                            org.junit.jupiter.api.Assertions.assertTrue((boolean)future.isSuccess());
                                            sChannel.shutdownOutput();
                                        }
                                    });
                                }
                            });
                        }
                    }});
                    serverChannelLatch.countDown();
                }
            });
            cb.group((EventLoopGroup)new MultiThreadIoEventLoopGroup(1, NioIoHandler.newFactory()));
            cb.channel(NioSocketChannel.class);
            cb.option(ChannelOption.ALLOW_HALF_CLOSURE, (Object)true);
            cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec(4096, 8192, 8192, true, true)});
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(4096)});
                    ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<FullHttpResponse>(){

                        protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) {
                            responseReceivedLatch.countDown();
                        }
                    }});
                }
            });
            Channel serverChannel = sb.bind((SocketAddress)new InetSocketAddress(0)).sync().channel();
            int port = ((InetSocketAddress)serverChannel.localAddress()).getPort();
            ChannelFuture ccf = cb.connect((SocketAddress)new InetSocketAddress(NetUtil.LOCALHOST, port));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)ccf.awaitUninterruptibly().isSuccess());
            Channel clientChannel = ccf.channel();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)serverChannelLatch.await(5L, TimeUnit.SECONDS));
            clientChannel.writeAndFlush((Object)new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)responseReceivedLatch.await(5L, TimeUnit.SECONDS));
        }
        finally {
            sb.config().group().shutdownGracefully().syncUninterruptibly();
            sb.config().childGroup().shutdownGracefully().syncUninterruptibly();
            cb.config().group().shutdownGracefully().syncUninterruptibly();
        }
    }

    @Test
    public void testContinueParsingAfterConnect() throws Exception {
        HttpClientCodecTest.testAfterConnect(true);
    }

    @Test
    public void testPassThroughAfterConnect() throws Exception {
        HttpClientCodecTest.testAfterConnect(false);
    }

    private static void testAfterConnect(final boolean parseAfterConnect) throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpClientCodec(4096, 8192, 8192, true, true, parseAfterConnect)});
        Consumer connectResponseConsumer = new Consumer();
        HttpClientCodecTest.sendRequestAndReadResponse(ch, HttpMethod.CONNECT, EMPTY_RESPONSE, connectResponseConsumer);
        org.junit.jupiter.api.Assertions.assertTrue((connectResponseConsumer.getReceivedCount() > 0 ? 1 : 0) != 0, (String)"No connect response messages received.");
        Consumer responseConsumer = new Consumer(){

            @Override
            void accept(Object object) {
                if (parseAfterConnect) {
                    org.junit.jupiter.api.Assertions.assertInstanceOf(HttpObject.class, (Object)object);
                } else {
                    Assertions.assertThat((Object)object).isNotInstanceOf(HttpObject.class);
                }
            }
        };
        HttpClientCodecTest.sendRequestAndReadResponse(ch, HttpMethod.GET, RESPONSE, responseConsumer);
        org.junit.jupiter.api.Assertions.assertTrue((responseConsumer.getReceivedCount() > 0 ? 1 : 0) != 0, (String)"No response messages received.");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.finish(), (String)"Channel finish failed.");
    }

    private static void sendRequestAndReadResponse(EmbeddedChannel ch, HttpMethod httpMethod, String response) {
        HttpClientCodecTest.sendRequestAndReadResponse(ch, httpMethod, response, new Consumer());
    }

    private static void sendRequestAndReadResponse(EmbeddedChannel ch, HttpMethod httpMethod, String response, Consumer responseConsumer) {
        Object msg;
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, httpMethod, "http://localhost/")}), (String)"Channel outbound write failed.");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)response, (Charset)CharsetUtil.ISO_8859_1)}), (String)"Channel inbound write failed.");
        while ((msg = ch.readOutbound()) != null) {
            ReferenceCountUtil.release((Object)msg);
        }
        while ((msg = ch.readInbound()) != null) {
            responseConsumer.onResponse(msg);
            ReferenceCountUtil.release((Object)msg);
        }
    }

    @Test
    public void testDecodesFinalResponseAfterSwitchingProtocols() {
        String SWITCHING_PROTOCOLS_RESPONSE = "HTTP/1.1 101 Switching Protocols\r\nConnection: Upgrade\r\nUpgrade: TLS/1.2, HTTP/1.1\r\n\r\n";
        HttpClientCodec codec = new HttpClientCodec(4096, 8192, 8192, true);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{codec, new HttpObjectAggregator(1024)});
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http://localhost/");
        request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
        request.headers().set((CharSequence)HttpHeaderNames.UPGRADE, (Object)"TLS/1.2");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{request}), (String)"Channel outbound write failed.");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)SWITCHING_PROTOCOLS_RESPONSE, (Charset)CharsetUtil.ISO_8859_1)}), (String)"Channel inbound write failed.");
        Object switchingProtocolsResponse = ch.readInbound();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)switchingProtocolsResponse, (String)"No response received");
        org.junit.jupiter.api.Assertions.assertInstanceOf(FullHttpResponse.class, (Object)switchingProtocolsResponse);
        ((FullHttpResponse)switchingProtocolsResponse).release();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)RESPONSE, (Charset)CharsetUtil.ISO_8859_1)}), (String)"Channel inbound write failed");
        Object finalResponse = ch.readInbound();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)finalResponse, (String)"No response received");
        org.junit.jupiter.api.Assertions.assertInstanceOf(FullHttpResponse.class, (Object)finalResponse);
        ((FullHttpResponse)finalResponse).release();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.finishAndReleaseAll(), (String)"Channel finish failed");
    }

    @Test
    public void testWebSocket00Response() {
        byte[] data = "HTTP/1.1 101 WebSocket Protocol Handshake\r\nUpgrade: WebSocket\r\nConnection: Upgrade\r\nSec-WebSocket-Origin: http://localhost:8080\r\nSec-WebSocket-Location: ws://localhost/some/path\r\n\r\n1234567812345678".getBytes();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpClientCodec()});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])data)}));
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.SWITCHING_PROTOCOLS, (Object)res.status());
        HttpContent content = (HttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)16, (int)content.content().readableBytes());
        content.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.finish());
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testWebDavResponse() {
        byte[] data = "HTTP/1.1 102 Processing\r\nStatus-URI: Status-URI:http://status.com; 404\r\n\r\n1234567812345678".getBytes();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpClientCodec()});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])data)}));
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.PROCESSING, (Object)res.status());
        HttpContent content = (HttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)content.content().readableBytes());
        content.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testInformationalResponseKeepsPairsInSync() {
        byte[] data = "HTTP/1.1 102 Processing\r\nStatus-URI: Status-URI:http://status.com; 404\r\n\r\n".getBytes();
        byte[] data2 = "HTTP/1.1 200 OK\r\nContent-Length: 8\r\n\r\n12345678".getBytes();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpClientCodec()});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.HEAD, "/")}));
        ByteBuf buffer = (ByteBuf)ch.readOutbound();
        buffer.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readOutbound());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])data)}));
        HttpResponse res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.PROCESSING, (Object)res.status());
        HttpContent content = (HttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)content.content().readableBytes());
        org.junit.jupiter.api.Assertions.assertInstanceOf(LastHttpContent.class, (Object)content);
        content.release();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/")}));
        buffer = (ByteBuf)ch.readOutbound();
        buffer.release();
        org.junit.jupiter.api.Assertions.assertNull((Object)ch.readOutbound());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])data2)}));
        res = (HttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertSame((Object)HttpVersion.HTTP_1_1, (Object)res.protocolVersion());
        org.junit.jupiter.api.Assertions.assertEquals((Object)HttpResponseStatus.OK, (Object)res.status());
        content = (HttpContent)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertEquals((int)8, (int)content.content().readableBytes());
        org.junit.jupiter.api.Assertions.assertInstanceOf(LastHttpContent.class, (Object)content);
        content.release();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testMultipleResponses() {
        String response = "HTTP/1.1 200 OK\r\nContent-Length: 0\r\n\r\n";
        HttpClientCodec codec = new HttpClientCodec(4096, 8192, 8192, true);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{codec, new HttpObjectAggregator(1024)});
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http://localhost/");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{request}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)response, (Charset)CharsetUtil.UTF_8)}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)response, (Charset)CharsetUtil.UTF_8)}));
        FullHttpResponse resp = (FullHttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)resp.decoderResult().isSuccess());
        resp.release();
        resp = (FullHttpResponse)ch.readInbound();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)resp.decoderResult().isSuccess());
        resp.release();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.finishAndReleaseAll());
    }

    @Test
    public void testWriteThroughAfterUpgrade() {
        HttpClientCodec codec = new HttpClientCodec();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{codec});
        codec.prepareUpgradeFrom(null);
        ByteBuf buffer = ch.alloc().buffer();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)buffer.refCnt());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.writeOutbound(new Object[]{buffer}));
        org.junit.jupiter.api.Assertions.assertSame((Object)buffer, (Object)ch.readOutbound());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)buffer.refCnt());
        buffer.release();
    }

    private static class Consumer {
        private int receivedCount;

        private Consumer() {
        }

        final void onResponse(Object object) {
            ++this.receivedCount;
            this.accept(object);
        }

        void accept(Object object) {
        }

        int getReceivedCount() {
            return this.receivedCount;
        }
    }
}

