/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.CombinedHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.util.AsciiString;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class CombinedHttpHeadersTest {
    private static final CharSequence HEADER_NAME = "testHeader";

    @Test
    public void addCharSequencesCsv() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void addCharSequencesCsvWithExistingHeader() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.FIVE.subset(4));
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.FIVE);
    }

    @Test
    public void addCombinedHeadersWhenEmpty() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        CombinedHttpHeaders otherHeaders = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        otherHeaders.add(HEADER_NAME, (Object)"a");
        otherHeaders.add(HEADER_NAME, (Object)"b");
        headers.add((HttpHeaders)otherHeaders);
        Assertions.assertEquals((Object)"a,b", (Object)headers.get(HEADER_NAME));
    }

    @Test
    public void addCombinedHeadersWhenNotEmpty() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, (Object)"a");
        CombinedHttpHeaders otherHeaders = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        otherHeaders.add(HEADER_NAME, (Object)"b");
        otherHeaders.add(HEADER_NAME, (Object)"c");
        headers.add((HttpHeaders)otherHeaders);
        Assertions.assertEquals((Object)"a,b,c", (Object)headers.get(HEADER_NAME));
    }

    @Test
    public void dontCombineSetCookieHeaders() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)"a");
        CombinedHttpHeaders otherHeaders = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        otherHeaders.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)"b");
        otherHeaders.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)"c");
        headers.add((HttpHeaders)otherHeaders);
        Assertions.assertEquals((int)3, (int)headers.getAll((CharSequence)HttpHeaderNames.SET_COOKIE).size());
    }

    @Test
    public void dontCombineSetCookieHeadersRegardlessOfCase() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add("Set-Cookie", (Object)"a");
        CombinedHttpHeaders otherHeaders = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        otherHeaders.add("set-cookie", (Object)"b");
        otherHeaders.add("SET-COOKIE", (Object)"c");
        headers.add((HttpHeaders)otherHeaders);
        Assertions.assertEquals((int)3, (int)headers.getAll((CharSequence)HttpHeaderNames.SET_COOKIE).size());
    }

    @Test
    public void setCombinedHeadersWhenNotEmpty() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, (Object)"a");
        CombinedHttpHeaders otherHeaders = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        otherHeaders.add(HEADER_NAME, (Object)"b");
        otherHeaders.add(HEADER_NAME, (Object)"c");
        headers.set((HttpHeaders)otherHeaders);
        Assertions.assertEquals((Object)"b,c", (Object)headers.get(HEADER_NAME));
    }

    @Test
    public void addUncombinedHeaders() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, (Object)"a");
        DefaultHttpHeaders otherHeaders = new DefaultHttpHeaders();
        otherHeaders.add(HEADER_NAME, (Object)"b");
        otherHeaders.add(HEADER_NAME, (Object)"c");
        headers.add((HttpHeaders)otherHeaders);
        Assertions.assertEquals((Object)"a,b,c", (Object)headers.get(HEADER_NAME));
    }

    @Test
    public void setUncombinedHeaders() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, (Object)"a");
        DefaultHttpHeaders otherHeaders = new DefaultHttpHeaders();
        otherHeaders.add(HEADER_NAME, (Object)"b");
        otherHeaders.add(HEADER_NAME, (Object)"c");
        headers.set((HttpHeaders)otherHeaders);
        Assertions.assertEquals((Object)"b,c", (Object)headers.get(HEADER_NAME));
    }

    @Test
    public void addCharSequencesCsvWithValueContainingComma() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.SIX_QUOTED.subset(4));
        Assertions.assertTrue((boolean)AsciiString.contentEquals((CharSequence)HttpHeadersTestUtils.HeaderValue.SIX_QUOTED.subsetAsCsvString(4), (CharSequence)headers.get(HEADER_NAME)));
        Assertions.assertEquals(HttpHeadersTestUtils.HeaderValue.SIX_QUOTED.subset(4), (Object)headers.getAll(HEADER_NAME));
    }

    @Test
    public void addCharSequencesCsvWithValueContainingCommas() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.EIGHT.subset(6));
        Assertions.assertTrue((boolean)AsciiString.contentEquals((CharSequence)HttpHeadersTestUtils.HeaderValue.EIGHT.subsetAsCsvString(6), (CharSequence)headers.get(HEADER_NAME)));
        Assertions.assertEquals(HttpHeadersTestUtils.HeaderValue.EIGHT.subset(6), (Object)headers.getAll(HEADER_NAME));
    }

    @Test
    public void addCharSequencesCsvNullValue() {
        final CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        final String value = null;
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                headers.add(HEADER_NAME, (Object)value);
            }
        });
    }

    @Test
    public void addCharSequencesCsvMultipleTimes() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        for (int i = 0; i < 5; ++i) {
            headers.add(HEADER_NAME, (Object)"value");
        }
        Assertions.assertTrue((boolean)AsciiString.contentEquals((CharSequence)"value,value,value,value,value", (CharSequence)headers.get(HEADER_NAME)));
    }

    @Test
    public void addCharSequenceCsv() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        CombinedHttpHeadersTest.addValues(headers, HttpHeadersTestUtils.HeaderValue.ONE, HttpHeadersTestUtils.HeaderValue.TWO, HttpHeadersTestUtils.HeaderValue.THREE);
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void addCharSequenceCsvSingleValue() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        CombinedHttpHeadersTest.addValues(headers, HttpHeadersTestUtils.HeaderValue.ONE);
        CombinedHttpHeadersTest.assertCsvValue(headers, HttpHeadersTestUtils.HeaderValue.ONE);
    }

    @Test
    public void addIterableCsv() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void addIterableCsvWithExistingHeader() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.FIVE.subset(4));
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.FIVE);
    }

    @Test
    public void addIterableCsvSingleValue() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.ONE.asList());
        CombinedHttpHeadersTest.assertCsvValue(headers, HttpHeadersTestUtils.HeaderValue.ONE);
    }

    @Test
    public void addIterableCsvEmpty() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, Collections.emptyList());
        Assertions.assertEquals(Collections.singletonList(""), (Object)headers.getAll(HEADER_NAME));
    }

    @Test
    public void addObjectCsv() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        CombinedHttpHeadersTest.addObjectValues(headers, HttpHeadersTestUtils.HeaderValue.ONE, HttpHeadersTestUtils.HeaderValue.TWO, HttpHeadersTestUtils.HeaderValue.THREE);
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void addObjectsCsv() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void addObjectsIterableCsv() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void addObjectsCsvWithExistingHeader() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.FIVE.subset(4));
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.FIVE);
    }

    @Test
    public void setCharSequenceCsv() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.set(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void setIterableCsv() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.set(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void setObjectObjectsCsv() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.set(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void setObjectIterableCsv() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.set(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        CombinedHttpHeadersTest.assertCsvValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    private static CombinedHttpHeaders newCombinedHttpHeaders() {
        return new CombinedHttpHeaders(true);
    }

    private static void assertCsvValues(CombinedHttpHeaders headers, HttpHeadersTestUtils.HeaderValue headerValue) {
        Assertions.assertTrue((boolean)AsciiString.contentEquals((CharSequence)headerValue.asCsv(), (CharSequence)headers.get(HEADER_NAME)));
        Assertions.assertEquals(headerValue.asList(), (Object)headers.getAll(HEADER_NAME));
    }

    private static void assertCsvValue(CombinedHttpHeaders headers, HttpHeadersTestUtils.HeaderValue headerValue) {
        Assertions.assertTrue((boolean)AsciiString.contentEquals((CharSequence)headerValue.toString(), (CharSequence)headers.get(HEADER_NAME)));
        Assertions.assertTrue((boolean)AsciiString.contentEquals((CharSequence)headerValue.toString(), (CharSequence)((CharSequence)headers.getAll(HEADER_NAME).get(0))));
    }

    private static void addValues(CombinedHttpHeaders headers, HttpHeadersTestUtils.HeaderValue ... headerValues) {
        for (HttpHeadersTestUtils.HeaderValue v : headerValues) {
            headers.add(HEADER_NAME, (Object)v.toString());
        }
    }

    private static void addObjectValues(CombinedHttpHeaders headers, HttpHeadersTestUtils.HeaderValue ... headerValues) {
        for (HttpHeadersTestUtils.HeaderValue v : headerValues) {
            headers.add(HEADER_NAME, (Object)v.toString());
        }
    }

    @Test
    public void testGetAll() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.set(HEADER_NAME, Arrays.asList("a", "b", "c"));
        Assertions.assertEquals(Arrays.asList("a", "b", "c"), (Object)headers.getAll(HEADER_NAME));
        headers.set(HEADER_NAME, Arrays.asList("a,", "b,", "c,"));
        Assertions.assertEquals(Arrays.asList("a,", "b,", "c,"), (Object)headers.getAll(HEADER_NAME));
        headers.set(HEADER_NAME, Arrays.asList("a\"", "b\"", "c\""));
        Assertions.assertEquals(Arrays.asList("a\"", "b\"", "c\""), (Object)headers.getAll(HEADER_NAME));
        headers.set(HEADER_NAME, Arrays.asList("\"a\"", "\"b\"", "\"c\""));
        Assertions.assertEquals(Arrays.asList("a", "b", "c"), (Object)headers.getAll(HEADER_NAME));
        headers.set(HEADER_NAME, (Object)"a,b,c");
        Assertions.assertEquals(Collections.singletonList("a,b,c"), (Object)headers.getAll(HEADER_NAME));
        headers.set(HEADER_NAME, (Object)"\"a,b,c\"");
        Assertions.assertEquals(Collections.singletonList("a,b,c"), (Object)headers.getAll(HEADER_NAME));
    }

    @Test
    public void getAllDontCombineSetCookie() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)"a");
        headers.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)"b");
        Assertions.assertEquals((int)2, (int)headers.getAll((CharSequence)HttpHeaderNames.SET_COOKIE).size());
        Assertions.assertEquals(Arrays.asList("a", "b"), (Object)headers.getAll((CharSequence)HttpHeaderNames.SET_COOKIE));
    }

    @Test
    public void owsTrimming() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.set(HEADER_NAME, Arrays.asList("\ta", "   ", "  b ", "\t \t"));
        headers.add(HEADER_NAME, (Object)" c, d \t");
        Assertions.assertEquals(Arrays.asList("a", "", "b", "", "c, d"), (Object)headers.getAll(HEADER_NAME));
        Assertions.assertEquals((Object)"a,,b,,\"c, d\"", (Object)headers.get(HEADER_NAME));
        Assertions.assertTrue((boolean)headers.containsValue(HEADER_NAME, (CharSequence)"a", true));
        Assertions.assertTrue((boolean)headers.containsValue(HEADER_NAME, (CharSequence)" a ", true));
        Assertions.assertTrue((boolean)headers.containsValue(HEADER_NAME, (CharSequence)"a", true));
        Assertions.assertFalse((boolean)headers.containsValue(HEADER_NAME, (CharSequence)"a,b", true));
        Assertions.assertFalse((boolean)headers.containsValue(HEADER_NAME, (CharSequence)" c, d ", true));
        Assertions.assertFalse((boolean)headers.containsValue(HEADER_NAME, (CharSequence)"c, d", true));
        Assertions.assertTrue((boolean)headers.containsValue(HEADER_NAME, (CharSequence)" c ", true));
        Assertions.assertTrue((boolean)headers.containsValue(HEADER_NAME, (CharSequence)"d", true));
        Assertions.assertTrue((boolean)headers.containsValue(HEADER_NAME, (CharSequence)"\t", true));
        Assertions.assertTrue((boolean)headers.containsValue(HEADER_NAME, (CharSequence)"", true));
        Assertions.assertFalse((boolean)headers.containsValue(HEADER_NAME, (CharSequence)"e", true));
        HttpHeaders copiedHeaders = CombinedHttpHeadersTest.newCombinedHttpHeaders().add((HttpHeaders)headers);
        Assertions.assertEquals(Arrays.asList("a", "", "b", "", "c, d"), (Object)copiedHeaders.getAll(HEADER_NAME));
    }

    @Test
    public void valueIterator() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.set(HEADER_NAME, Arrays.asList("\ta", "   ", "  b ", "\t \t"));
        headers.add(HEADER_NAME, (Object)" c, d \t");
        Assertions.assertFalse((boolean)headers.valueStringIterator((CharSequence)"foo").hasNext());
        CombinedHttpHeadersTest.assertValueIterator(headers.valueStringIterator(HEADER_NAME));
        Assertions.assertFalse((boolean)headers.valueCharSequenceIterator((CharSequence)"foo").hasNext());
        CombinedHttpHeadersTest.assertValueIterator(headers.valueCharSequenceIterator(HEADER_NAME));
    }

    @Test
    public void nonCombinableHeaderIterator() {
        CombinedHttpHeaders headers = CombinedHttpHeadersTest.newCombinedHttpHeaders();
        headers.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)"c");
        headers.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)"b");
        headers.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)"a");
        Iterator strItr = headers.valueStringIterator((CharSequence)HttpHeaderNames.SET_COOKIE);
        Assertions.assertTrue((boolean)strItr.hasNext());
        Assertions.assertEquals((Object)"a", strItr.next());
        Assertions.assertTrue((boolean)strItr.hasNext());
        Assertions.assertEquals((Object)"b", strItr.next());
        Assertions.assertTrue((boolean)strItr.hasNext());
        Assertions.assertEquals((Object)"c", strItr.next());
    }

    private static void assertValueIterator(Iterator<? extends CharSequence> strItr) {
        Assertions.assertTrue((boolean)strItr.hasNext());
        Assertions.assertEquals((Object)"a", (Object)strItr.next());
        Assertions.assertTrue((boolean)strItr.hasNext());
        Assertions.assertEquals((Object)"", (Object)strItr.next());
        Assertions.assertTrue((boolean)strItr.hasNext());
        Assertions.assertEquals((Object)"b", (Object)strItr.next());
        Assertions.assertTrue((boolean)strItr.hasNext());
        Assertions.assertEquals((Object)"", (Object)strItr.next());
        Assertions.assertTrue((boolean)strItr.hasNext());
        Assertions.assertEquals((Object)"c, d", (Object)strItr.next());
        Assertions.assertFalse((boolean)strItr.hasNext());
    }
}

