/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.compression.AbstractEncoderTest;
import io.netty.handler.codec.compression.Lz4FrameEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.xxhash.XXHashFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class Lz4FrameEncoderTest
extends AbstractEncoderTest {
    private static final int NONALLOCATABLE_SIZE = 1;
    @Mock
    private ChannelHandlerContext ctx;
    @Mock
    private ByteBuf buffer;

    @BeforeEach
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.ctx.alloc()).thenReturn((Object)ByteBufAllocator.DEFAULT);
    }

    @Override
    protected EmbeddedChannel createChannel() {
        return new EmbeddedChannel(new ChannelHandler[]{new Lz4FrameEncoder()});
    }

    @Override
    protected ByteBuf decompress(ByteBuf compressed, int originalLength) throws Exception {
        byte[] decompressed = new byte[originalLength];
        try (LZ4BlockInputStream lz4Is = new LZ4BlockInputStream((InputStream)new ByteBufInputStream(compressed, true));){
            int read;
            for (int remaining = originalLength; remaining > 0 && (read = lz4Is.read(decompressed, originalLength - remaining, remaining)) > 0; remaining -= read) {
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)lz4Is.read());
        }
        return Unpooled.wrappedBuffer((byte[])decompressed);
    }

    @Test
    public void testAllocateDirectBuffer() {
        int blockSize = 100;
        this.testAllocateBuffer(100, 87, true);
        this.testAllocateBuffer(100, 500, true);
        this.testAllocateBuffer(100, 1, true);
    }

    @Test
    public void testAllocateHeapBuffer() {
        int blockSize = 100;
        this.testAllocateBuffer(100, 87, false);
        this.testAllocateBuffer(100, 500, false);
        this.testAllocateBuffer(100, 1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAllocateBuffer(int blockSize, int bufSize, boolean preferDirect) {
        ByteBuf in = ByteBufAllocator.DEFAULT.buffer(bufSize, bufSize);
        in.writerIndex(in.capacity());
        ByteBuf out = null;
        try {
            Lz4FrameEncoder encoder = this.newEncoder(blockSize, Integer.MAX_VALUE);
            out = encoder.allocateBuffer(this.ctx, in, preferDirect);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)out);
            if (1 == bufSize) {
                org.junit.jupiter.api.Assertions.assertFalse((boolean)out.isWritable());
            } else {
                org.junit.jupiter.api.Assertions.assertTrue((out.writableBytes() > 0 ? 1 : 0) != 0);
                if (!preferDirect) {
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)out.isDirect());
                }
            }
        }
        finally {
            in.release();
            if (out != null) {
                out.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllocateDirectBufferExceedMaxEncodeSize() {
        int maxEncodeSize = 1024;
        final Lz4FrameEncoder encoder = this.newEncoder(65536, 1024);
        int inputBufferSize = 10240;
        final ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(inputBufferSize, inputBufferSize);
        try {
            buf.writerIndex(inputBufferSize);
            org.junit.jupiter.api.Assertions.assertThrows(EncoderException.class, (Executable)new Executable(){

                public void execute() {
                    encoder.allocateBuffer(Lz4FrameEncoderTest.this.ctx, buf, false);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    private Lz4FrameEncoder newEncoder(int blockSize, int maxEncodeSize) {
        Checksum checksum = XXHashFactory.fastestInstance().newStreamingHash32(-1756908916).asChecksum();
        Lz4FrameEncoder encoder = new Lz4FrameEncoder(LZ4Factory.fastestInstance(), true, blockSize, checksum, maxEncodeSize);
        encoder.handlerAdded(this.ctx);
        return encoder;
    }

    @Test
    public void testAllocateOnHeapBufferOverflowsOutputSize() {
        int maxEncodeSize = Integer.MAX_VALUE;
        final Lz4FrameEncoder encoder = this.newEncoder(65536, Integer.MAX_VALUE);
        Mockito.when((Object)this.buffer.readableBytes()).thenReturn((Object)Integer.MAX_VALUE);
        this.buffer.writerIndex(Integer.MAX_VALUE);
        org.junit.jupiter.api.Assertions.assertThrows(EncoderException.class, (Executable)new Executable(){

            public void execute() {
                encoder.allocateBuffer(Lz4FrameEncoderTest.this.ctx, Lz4FrameEncoderTest.this.buffer, false);
            }
        });
    }

    @Test
    public void testFlush() {
        Lz4FrameEncoder encoder = new Lz4FrameEncoder();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{encoder});
        int size = 27;
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(size, size);
        buf.writerIndex(size);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)encoder.getBackingBuffer().readableBytes());
        channel.write((Object)buf);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.outboundMessages().isEmpty());
        org.junit.jupiter.api.Assertions.assertEquals((int)size, (int)encoder.getBackingBuffer().readableBytes());
        channel.flush();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.finish());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.releaseOutbound());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.releaseInbound());
    }

    @Test
    public void testAllocatingAroundBlockSize() {
        int blockSize = 100;
        Lz4FrameEncoder encoder = this.newEncoder(blockSize, Integer.MAX_VALUE);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{encoder});
        int size = blockSize - 1;
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(size, size);
        buf.writerIndex(size);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)encoder.getBackingBuffer().readableBytes());
        channel.write((Object)buf);
        org.junit.jupiter.api.Assertions.assertEquals((int)size, (int)encoder.getBackingBuffer().readableBytes());
        int nextSize = size - 1;
        buf = ByteBufAllocator.DEFAULT.buffer(nextSize, nextSize);
        buf.writerIndex(nextSize);
        channel.write((Object)buf);
        org.junit.jupiter.api.Assertions.assertEquals((int)(size + nextSize - blockSize), (int)encoder.getBackingBuffer().readableBytes());
        channel.flush();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)encoder.getBackingBuffer().readableBytes());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.finish());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)channel.releaseOutbound());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)channel.releaseInbound());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void writingAfterClosedChannelDoesNotNPE() throws InterruptedException {
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(2, NioIoHandler.newFactory());
        Channel serverChannel = null;
        Channel clientChannel = null;
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference writeFailCauseRef = new AtomicReference();
        try {
            ServerBootstrap sb = new ServerBootstrap();
            sb.group((EventLoopGroup)group);
            sb.channel(NioServerSocketChannel.class);
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                }
            });
            Bootstrap bs = new Bootstrap();
            bs.group((EventLoopGroup)group);
            bs.channel(NioSocketChannel.class);
            bs.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new Lz4FrameEncoder()});
                }
            });
            serverChannel = sb.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            final Channel finalClientChannel = clientChannel = bs.connect(serverChannel.localAddress()).syncUninterruptibly().channel();
            clientChannel.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    finalClientChannel.close();
                    int size = 27;
                    ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(27, 27);
                    finalClientChannel.writeAndFlush((Object)buf.writerIndex(buf.writerIndex() + 27)).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            try {
                                writeFailCauseRef.set(future.cause());
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    });
                }
            });
            latch.await();
            Throwable writeFailCause = (Throwable)writeFailCauseRef.get();
            org.junit.jupiter.api.Assertions.assertNotNull((Object)writeFailCause);
            Throwable writeFailCauseCause = writeFailCause.getCause();
            if (writeFailCauseCause != null) {
                Assertions.assertThat((Throwable)writeFailCauseCause).isNotInstanceOf(NullPointerException.class);
            }
        }
        finally {
            if (serverChannel != null) {
                serverChannel.close();
            }
            if (clientChannel != null) {
                clientChannel.close();
            }
            group.shutdownGracefully();
        }
    }
}

