/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.AbstractDecoderTest;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.Lz4FrameDecoder;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import net.jpountz.lz4.LZ4BlockOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class Lz4FrameDecoderTest
extends AbstractDecoderTest {
    private static final byte[] DATA = new byte[]{76, 90, 52, 66, 108, 111, 99, 107, 22, 5, 0, 0, 0, 5, 0, 0, 0, -122, -28, 121, 15, 78, 101, 116, 116, 121, 76, 90, 52, 66, 108, 111, 99, 107, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    @Override
    protected EmbeddedChannel createChannel() {
        return new EmbeddedChannel(new ChannelHandler[]{new Lz4FrameDecoder(true)});
    }

    @Test
    public void testUnexpectedBlockIdentifier() {
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[1] = 0;
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                Lz4FrameDecoderTest.this.channel.writeInbound(new Object[]{in});
            }
        }, (String)"unexpected block identifier");
    }

    @Test
    public void testInvalidCompressedLength() {
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[12] = -1;
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                Lz4FrameDecoderTest.this.channel.writeInbound(new Object[]{in});
            }
        }, (String)"invalid compressedLength");
    }

    @Test
    public void testInvalidDecompressedLength() {
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[16] = -1;
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                Lz4FrameDecoderTest.this.channel.writeInbound(new Object[]{in});
            }
        }, (String)"invalid decompressedLength");
    }

    @Test
    public void testDecompressedAndCompressedLengthMismatch() {
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[13] = 1;
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                Lz4FrameDecoderTest.this.channel.writeInbound(new Object[]{in});
            }
        }, (String)"mismatch");
    }

    @Test
    public void testUnexpectedBlockType() {
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[8] = 54;
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                Lz4FrameDecoderTest.this.channel.writeInbound(new Object[]{in});
            }
        }, (String)"unexpected blockType");
    }

    @Test
    public void testMismatchingChecksum() {
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[17] = 1;
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                Lz4FrameDecoderTest.this.channel.writeInbound(new Object[]{in});
            }
        }, (String)"mismatching checksum");
    }

    @Test
    public void testChecksumErrorOfLastBlock() {
        final byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[44] = 1;
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                AbstractDecoderTest.tryDecodeAndCatchBufLeaks(Lz4FrameDecoderTest.this.channel, Unpooled.wrappedBuffer((byte[])data));
            }
        }, (String)"checksum error");
    }

    @Override
    protected byte[] compress(byte[] data) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int size = 0x2000001;
        try (LZ4BlockOutputStream lz4Os = new LZ4BlockOutputStream((OutputStream)os, rand.nextInt(size - 64) + 64);){
            lz4Os.write(data);
        }
        return os.toByteArray();
    }
}

