/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.JdkZlibDecoder;
import io.netty.handler.codec.compression.JdkZlibEncoder;
import io.netty.handler.codec.compression.ZlibDecoder;
import io.netty.handler.codec.compression.ZlibEncoder;
import io.netty.handler.codec.compression.ZlibTest;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class JdkZlibTest
extends ZlibTest {
    @Override
    protected ZlibEncoder createEncoder(ZlibWrapper wrapper) {
        return new JdkZlibEncoder(wrapper);
    }

    @Override
    protected ZlibDecoder createDecoder(ZlibWrapper wrapper, int maxAllocation) {
        return new JdkZlibDecoder(wrapper, maxAllocation);
    }

    @Override
    @Test
    public void testZLIB_OR_NONE3() throws Exception {
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                JdkZlibTest.super.testZLIB_OR_NONE3();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcatenatedStreamsReadFirstOnly() throws IOException {
        EmbeddedChannel chDecoderGZip = new EmbeddedChannel(new ChannelHandler[]{this.createDecoder(ZlibWrapper.GZIP)});
        try (InputStream resourceAsStream = this.getClass().getResourceAsStream("/multiple.gz");){
            byte[] bytes = IOUtils.toByteArray((InputStream)resourceAsStream);
            Assertions.assertTrue((boolean)chDecoderGZip.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])bytes)}));
            Queue messages = chDecoderGZip.inboundMessages();
            Assertions.assertEquals((int)1, (int)messages.size());
            ByteBuf msg = (ByteBuf)messages.poll();
            Assertions.assertEquals((Object)"a", (Object)msg.toString(CharsetUtil.UTF_8));
            ReferenceCountUtil.release((Object)msg);
        }
        finally {
            Assertions.assertFalse((boolean)chDecoderGZip.finish());
            chDecoderGZip.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcatenatedStreamsReadFully() throws IOException {
        EmbeddedChannel chDecoderGZip = new EmbeddedChannel(new ChannelHandler[]{new JdkZlibDecoder(true, 0)});
        try (InputStream resourceAsStream = this.getClass().getResourceAsStream("/multiple.gz");){
            byte[] bytes = IOUtils.toByteArray((InputStream)resourceAsStream);
            Assertions.assertTrue((boolean)chDecoderGZip.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])bytes)}));
            Queue messages = chDecoderGZip.inboundMessages();
            Assertions.assertEquals((int)2, (int)messages.size());
            for (String s : Arrays.asList("a", "b")) {
                ByteBuf msg = (ByteBuf)messages.poll();
                Assertions.assertEquals((Object)s, (Object)msg.toString(CharsetUtil.UTF_8));
                ReferenceCountUtil.release((Object)msg);
            }
        }
        finally {
            Assertions.assertFalse((boolean)chDecoderGZip.finish());
            chDecoderGZip.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcatenatedStreamsReadFullyWhenFragmented() throws IOException {
        EmbeddedChannel chDecoderGZip = new EmbeddedChannel(new ChannelHandler[]{new JdkZlibDecoder(true, 0)});
        try (InputStream resourceAsStream = this.getClass().getResourceAsStream("/multiple.gz");){
            byte[] bytes = IOUtils.toByteArray((InputStream)resourceAsStream);
            ByteBuf buf = Unpooled.copiedBuffer((byte[])bytes);
            boolean written = false;
            while (buf.isReadable()) {
                written |= chDecoderGZip.writeInbound(new Object[]{buf.readRetainedSlice(1)});
            }
            buf.release();
            Assertions.assertTrue((boolean)written);
            Queue messages = chDecoderGZip.inboundMessages();
            Assertions.assertEquals((int)2, (int)messages.size());
            for (String s : Arrays.asList("a", "b")) {
                ByteBuf msg = (ByteBuf)messages.poll();
                Assertions.assertEquals((Object)s, (Object)msg.toString(CharsetUtil.UTF_8));
                ReferenceCountUtil.release((Object)msg);
            }
        }
        finally {
            Assertions.assertFalse((boolean)chDecoderGZip.finish());
            chDecoderGZip.close();
        }
    }

    @Test
    public void testDecodeWithHeaderFollowingFooter() throws Exception {
        byte[] bytes = new byte[1024];
        ThreadLocalRandom.current().nextBytes(bytes);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        GZIPOutputStream out = new GZIPOutputStream(bytesOut);
        out.write(bytes);
        out.close();
        byte[] compressed = bytesOut.toByteArray();
        ByteBuf buffer = Unpooled.buffer().writeBytes(compressed).writeBytes(compressed);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new JdkZlibDecoder(ZlibWrapper.GZIP, true, 0)});
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{buffer.readRetainedSlice(compressed.length - 1)}));
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{buffer}));
        Assertions.assertTrue((boolean)channel.finish());
        ByteBuf uncompressedBuffer = Unpooled.wrappedBuffer((byte[])bytes);
        ByteBuf read = (ByteBuf)channel.readInbound();
        Assertions.assertEquals((Object)uncompressedBuffer, (Object)read);
        read.release();
        read = (ByteBuf)channel.readInbound();
        Assertions.assertEquals((Object)uncompressedBuffer, (Object)read);
        read.release();
        Assertions.assertNull((Object)channel.readInbound());
        uncompressedBuffer.release();
    }

    @Test
    public void testLargeEncode() throws Exception {
        byte[] smallArray = new byte[0x100000];
        byte[][] arrayOfArrays = new byte[128][];
        Arrays.fill((Object[])arrayOfArrays, smallArray);
        ByteBuf bigBuffer = Unpooled.wrappedBuffer((byte[][])arrayOfArrays);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new JdkZlibEncoder(ZlibWrapper.NONE)});
        channel.config().setAllocator((ByteBufAllocator)new LimitedByteBufAllocator(channel.alloc()));
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{bigBuffer}));
        Assertions.assertTrue((boolean)channel.finish());
        channel.checkException();
        Assertions.assertTrue((boolean)channel.releaseOutbound());
    }

    @Test
    void testAllowDefaultCompression() {
        Assertions.assertDoesNotThrow(() -> new JdkZlibEncoder(-1));
    }

    @Test
    public void testGzipFooterValidationSuccess() throws Exception {
        byte[] data = "hello gzip world".getBytes(CharsetUtil.UTF_8);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipOut = new GZIPOutputStream(baos);
        gzipOut.write(data);
        gzipOut.close();
        byte[] compressed = baos.toByteArray();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new JdkZlibDecoder(ZlibWrapper.GZIP, Integer.MAX_VALUE)});
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])compressed)}));
        ByteBuf result = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)Unpooled.wrappedBuffer((byte[])data), (Object)result);
        result.release();
        Assertions.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testGzipFooterCrcMismatchThrows() throws Exception {
        byte[] data = "corrupted gzip".getBytes(CharsetUtil.UTF_8);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipOut = new GZIPOutputStream(baos);
        gzipOut.write(data);
        gzipOut.close();
        byte[] compressed = baos.toByteArray();
        int n = compressed.length - 8;
        compressed[n] = (byte)(compressed[n] ^ 0xFF);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new JdkZlibDecoder(ZlibWrapper.GZIP, Integer.MAX_VALUE)});
        Assertions.assertThrows(DecompressionException.class, () -> ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])compressed)}));
        ch.finishAndReleaseAll();
    }

    @Test
    public void testGzipFooterISizeMismatchThrows() throws Exception {
        byte[] data = "wrong size".getBytes(CharsetUtil.UTF_8);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipOut = new GZIPOutputStream(baos);
        gzipOut.write(data);
        gzipOut.close();
        byte[] compressed = baos.toByteArray();
        int n = compressed.length - 4;
        compressed[n] = (byte)(compressed[n] ^ 0xFF);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new JdkZlibDecoder(ZlibWrapper.GZIP, Integer.MAX_VALUE)});
        Assertions.assertThrows(DecompressionException.class, () -> ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])compressed)}));
        ch.finishAndReleaseAll();
    }

    @Test
    public void testRoundTripCompressionGzipContentMatch() throws Exception {
        ByteBuf part;
        byte[] input = "Hello, Netty gzip roundtrip!".getBytes(CharsetUtil.UTF_8);
        EmbeddedChannel encoder = new EmbeddedChannel(new ChannelHandler[]{new JdkZlibEncoder(ZlibWrapper.GZIP)});
        Assertions.assertTrue((boolean)encoder.writeOutbound(new Object[]{Unpooled.wrappedBuffer((byte[])input)}));
        Assertions.assertTrue((boolean)encoder.finish());
        ByteBuf compressed = Unpooled.buffer();
        while ((part = (ByteBuf)encoder.readOutbound()) != null) {
            compressed.writeBytes(part);
            part.release();
        }
        EmbeddedChannel decoder = new EmbeddedChannel(new ChannelHandler[]{new JdkZlibDecoder(ZlibWrapper.GZIP, Integer.MAX_VALUE)});
        Assertions.assertTrue((boolean)decoder.writeInbound(new Object[]{compressed}));
        ByteBuf result = (ByteBuf)decoder.readInbound();
        Assertions.assertEquals((Object)Unpooled.wrappedBuffer((byte[])input), (Object)result);
        result.release();
        decoder.finish();
    }

    @Test
    public void testFragmentedGzipStreamStillYieldsCorrectContent() throws Exception {
        ByteBuf chunk;
        String text = "Fragmented input stream for GZIP!";
        byte[] input = text.getBytes(CharsetUtil.UTF_8);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipOut = new GZIPOutputStream(baos);
        gzipOut.write(input);
        gzipOut.close();
        byte[] compressed = baos.toByteArray();
        EmbeddedChannel decoder = new EmbeddedChannel(new ChannelHandler[]{new JdkZlibDecoder(ZlibWrapper.GZIP, Integer.MAX_VALUE)});
        for (byte b : compressed) {
            decoder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{b})});
        }
        Assertions.assertTrue((boolean)decoder.finish());
        ByteBuf result = Unpooled.buffer();
        while ((chunk = (ByteBuf)decoder.readInbound()) != null) {
            result.writeBytes(chunk);
            chunk.release();
        }
        Assertions.assertEquals((Object)text, (Object)result.toString(CharsetUtil.UTF_8));
        result.release();
    }

    @Test
    public void testMultipleConcatenatedGzipMessagesDecompressedIndividually() throws Exception {
        String first = "first message";
        String second = "second message";
        byte[] c1 = JdkZlibTest.gzipCompress(first.getBytes(CharsetUtil.UTF_8));
        byte[] c2 = JdkZlibTest.gzipCompress(second.getBytes(CharsetUtil.UTF_8));
        byte[] combined = new byte[c1.length + c2.length];
        System.arraycopy(c1, 0, combined, 0, c1.length);
        System.arraycopy(c2, 0, combined, c1.length, c2.length);
        EmbeddedChannel decoder = new EmbeddedChannel(new ChannelHandler[]{new JdkZlibDecoder(true, 0)});
        Assertions.assertTrue((boolean)decoder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])combined)}));
        ByteBuf m1 = (ByteBuf)decoder.readInbound();
        ByteBuf m2 = (ByteBuf)decoder.readInbound();
        Assertions.assertEquals((Object)first, (Object)m1.toString(CharsetUtil.UTF_8));
        Assertions.assertEquals((Object)second, (Object)m2.toString(CharsetUtil.UTF_8));
        m1.release();
        m2.release();
        decoder.finish();
    }

    private static byte[] gzipCompress(byte[] input) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipOut = new GZIPOutputStream(baos);
        gzipOut.write(input);
        gzipOut.close();
        return baos.toByteArray();
    }

    private static final class LimitedByteBufAllocator
    extends AbstractByteBufAllocator {
        private static final int MAX = 0x100000;
        private final ByteBufAllocator wrapped;

        LimitedByteBufAllocator(ByteBufAllocator wrapped) {
            this.wrapped = wrapped;
        }

        public boolean isDirectBufferPooled() {
            return this.wrapped.isDirectBufferPooled();
        }

        protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
            return this.wrapped.heapBuffer(initialCapacity, Math.min(maxCapacity, 0x100000));
        }

        protected ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
            return this.wrapped.directBuffer(initialCapacity, Math.min(maxCapacity, 0x100000));
        }
    }
}

