/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.AbstractEncoderTest;
import io.netty.handler.codec.compression.Bzip2Encoder;
import java.io.InputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.junit.jupiter.api.Assertions;

public class Bzip2EncoderTest
extends AbstractEncoderTest {
    @Override
    protected EmbeddedChannel createChannel() {
        return new EmbeddedChannel(new ChannelHandler[]{new Bzip2Encoder(1)});
    }

    @Override
    protected ByteBuf decompress(ByteBuf compressed, int originalLength) throws Exception {
        byte[] decompressed = new byte[originalLength];
        try (ByteBufInputStream is = new ByteBufInputStream(compressed, true);
             BZip2CompressorInputStream bzip2Is = new BZip2CompressorInputStream((InputStream)is);){
            int read;
            for (int remaining = originalLength; remaining > 0 && (read = bzip2Is.read(decompressed, originalLength - remaining, remaining)) > 0; remaining -= read) {
            }
            Assertions.assertEquals((int)-1, (int)bzip2Is.read());
        }
        return Unpooled.wrappedBuffer((byte[])decompressed);
    }
}

