/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.AbstractDecoderTest;
import io.netty.handler.codec.compression.Bzip2Decoder;
import io.netty.handler.codec.compression.DecompressionException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class Bzip2DecoderTest
extends AbstractDecoderTest {
    private static final byte[] DATA = new byte[]{66, 90, 104, 55, 49, 65, 89, 38, 83, 89, 119, 123, -54, -64, 0, 0, 0, 5, -128, 0, 1, 2, 0, 4, 32, 32, 0, 48, -51, 52, 25, -90, -119, -103, -59, -36, -111, 78, 20, 36, 29, -34, -14, -80, 0};

    @Override
    protected EmbeddedChannel createChannel() {
        return new EmbeddedChannel(new ChannelHandler[]{new Bzip2Decoder()});
    }

    private void writeInboundDestroyAndExpectDecompressionException(ByteBuf in) {
        try {
            this.channel.writeInbound(new Object[]{in});
        }
        finally {
            try {
                this.destroyChannel();
                Assertions.fail();
            }
            catch (DecompressionException decompressionException) {}
        }
    }

    @Test
    public void testUnexpectedStreamIdentifier() {
        final ByteBuf in = Unpooled.buffer();
        in.writeLong(1823080128301928729L);
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                Bzip2DecoderTest.this.writeInboundDestroyAndExpectDecompressionException(in);
            }
        }, (String)"Unexpected stream identifier contents");
    }

    @Test
    public void testInvalidBlockSize() {
        final ByteBuf in = Unpooled.buffer();
        in.writeMedium(4348520);
        in.writeByte(48);
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                Bzip2DecoderTest.this.channel.writeInbound(new Object[]{in});
            }
        }, (String)"block size is invalid");
    }

    @Test
    public void testBadBlockHeader() {
        final ByteBuf in = Unpooled.buffer();
        in.writeMedium(4348520);
        in.writeByte(49);
        in.writeMedium(11);
        in.writeMedium(11);
        in.writeInt(11111);
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                Bzip2DecoderTest.this.channel.writeInbound(new Object[]{in});
            }
        }, (String)"bad block header");
    }

    @Test
    public void testStreamCrcErrorOfEmptyBlock() {
        final ByteBuf in = Unpooled.buffer();
        in.writeMedium(4348520);
        in.writeByte(49);
        in.writeMedium(1536581);
        in.writeMedium(3690640);
        in.writeInt(1);
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                Bzip2DecoderTest.this.channel.writeInbound(new Object[]{in});
            }
        }, (String)"stream CRC error");
    }

    @Test
    public void testStreamCrcError() {
        final byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[41] = -35;
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                AbstractDecoderTest.tryDecodeAndCatchBufLeaks(Bzip2DecoderTest.this.channel, Unpooled.wrappedBuffer((byte[])data));
            }
        }, (String)"stream CRC error");
    }

    @Test
    public void testIncorrectHuffmanGroupsNumber() {
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[25] = 112;
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                Bzip2DecoderTest.this.channel.writeInbound(new Object[]{in});
            }
        }, (String)"incorrect huffman groups number");
    }

    @Test
    public void testIncorrectSelectorsNumber() {
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[25] = 47;
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                Bzip2DecoderTest.this.channel.writeInbound(new Object[]{in});
            }
        }, (String)"incorrect selectors number");
    }

    @Test
    public void testBlockCrcError() {
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[11] = 119;
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                Bzip2DecoderTest.this.writeInboundDestroyAndExpectDecompressionException(in);
            }
        }, (String)"block CRC error");
    }

    @Test
    public void testStartPointerInvalid() {
        byte[] data = Arrays.copyOf(DATA, DATA.length);
        data[14] = -1;
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])data);
        Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

            public void execute() {
                Bzip2DecoderTest.this.writeInboundDestroyAndExpectDecompressionException(in);
            }
        }, (String)"start pointer invalid");
    }

    @Override
    protected byte[] compress(byte[] data) throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BZip2CompressorOutputStream bZip2Os = new BZip2CompressorOutputStream((OutputStream)os, 1);
        bZip2Os.write(data);
        bZip2Os.close();
        return os.toByteArray();
    }
}

