/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.bytes;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.bytes.ByteArrayEncoder;
import io.netty.util.internal.EmptyArrays;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ByteArrayEncoderTest {
    private EmbeddedChannel ch;

    @BeforeEach
    public void setUp() {
        this.ch = new EmbeddedChannel(new ChannelHandler[]{new ByteArrayEncoder()});
    }

    @AfterEach
    public void tearDown() {
        Assertions.assertFalse((boolean)this.ch.finish());
    }

    @Test
    public void testEncode() {
        byte[] b = new byte[2048];
        new Random().nextBytes(b);
        this.ch.writeOutbound(new Object[]{b});
        ByteBuf encoded = (ByteBuf)this.ch.readOutbound();
        Assertions.assertEquals((Object)Unpooled.wrappedBuffer((byte[])b), (Object)encoded);
        encoded.release();
    }

    @Test
    public void testEncodeEmpty() {
        this.ch.writeOutbound(new Object[]{EmptyArrays.EMPTY_BYTES});
        Assertions.assertSame((Object)Unpooled.EMPTY_BUFFER, (Object)this.ch.readOutbound());
    }

    @Test
    public void testEncodeOtherType() {
        String str = "Meep!";
        this.ch.writeOutbound(new Object[]{str});
        Assertions.assertSame((Object)str, (Object)this.ch.readOutbound());
    }
}

