/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.DateFormatter;
import java.util.Calendar;
import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DateFormatterTest {
    private static final long TIMESTAMP = 784111777000L;
    private static final Date DATE = new Date(784111777000L);

    @Test
    public void testParseWithSingleDigitDay() {
        Assertions.assertEquals((Object)DATE, (Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 6 Nov 1994 08:49:37 GMT"));
    }

    @Test
    public void testParseWithDoubleDigitDay() {
        Assertions.assertEquals((Object)DATE, (Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 06 Nov 1994 08:49:37 GMT"));
    }

    @Test
    public void testParseWithDashSeparatorSingleDigitDay() {
        Assertions.assertEquals((Object)DATE, (Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 6-Nov-94 08:49:37 GMT"));
    }

    @Test
    public void testParseWithDashSeparatorDoubleDigitDay() {
        Assertions.assertEquals((Object)DATE, (Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 06-Nov-94 08:49:37 GMT"));
    }

    @Test
    public void testParseWithoutGMT() {
        Assertions.assertEquals((Object)DATE, (Object)DateFormatter.parseHttpDate((CharSequence)"Sun Nov 06 08:49:37 1994"));
    }

    @Test
    public void testParseWithFunkyTimezone() {
        Assertions.assertEquals((Object)DATE, (Object)DateFormatter.parseHttpDate((CharSequence)"Sun Nov 06 08:49:37 1994 -0000"));
    }

    @Test
    public void testParseWithSingleDigitHourMinutesAndSecond() {
        Assertions.assertEquals((Object)DATE, (Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 06-Nov-94 8:49:37 GMT"));
    }

    @Test
    public void testParseWithSingleDigitTime() {
        Assertions.assertEquals((Object)DATE, (Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 06 Nov 1994 8:49:37 GMT"));
        Date _08_09_37 = new Date(784109377000L);
        Assertions.assertEquals((Object)_08_09_37, (Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 06 Nov 1994 8:9:37 GMT"));
        Assertions.assertEquals((Object)_08_09_37, (Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 06 Nov 1994 8:09:37 GMT"));
        Date _08_09_07 = new Date(784109347000L);
        Assertions.assertEquals((Object)_08_09_07, (Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 06 Nov 1994 8:9:7 GMT"));
        Assertions.assertEquals((Object)_08_09_07, (Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 06 Nov 1994 8:9:07 GMT"));
    }

    @Test
    public void testParseMidnight() {
        Assertions.assertEquals((Object)new Date(784080000000L), (Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 06 Nov 1994 00:00:00 GMT"));
    }

    @Test
    public void testParseInvalidInput() {
        Assertions.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, Nov 1994 08:49:37 GMT"));
        Assertions.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 06 1994 08:49:37 GMT"));
        Assertions.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 06 Nov 08:49:37 GMT"));
        Assertions.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 06 Nov 1994 :49:37 GMT"));
        Assertions.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 06 Nov 1994 49:37 GMT"));
        Assertions.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 06 Nov 1994 08::37 GMT"));
        Assertions.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 06 Nov 1994 08:37 GMT"));
        Assertions.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 06 Nov 1994 08:49: GMT"));
        Assertions.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 06 Nov 1994 08:49 GMT"));
        Assertions.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 06 FOO 1994 08:49:37 GMT"));
        Assertions.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 36 Nov 1994 08:49:37 GMT"));
        Assertions.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 06 Nov 1994 28:49:37 GMT"));
        Assertions.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 06 Nov 1994 08:69:37 GMT"));
        Assertions.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sun, 06 Nov 1994 08:49:67 GMT"));
        Assertions.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 06 Nov 1994 0:0:000 GMT"));
        Assertions.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 06 Nov 1994 0:000:0 GMT"));
        Assertions.assertNull((Object)DateFormatter.parseHttpDate((CharSequence)"Sunday, 06 Nov 1994 000:0:0 GMT"));
    }

    @Test
    public void testFormat() {
        Assertions.assertEquals((Object)"Sun, 06 Nov 1994 08:49:37 GMT", (Object)DateFormatter.format((Date)DATE));
    }

    @Test
    public void testAppend() {
        StringBuilder sb = new StringBuilder();
        DateFormatter.append((Date)DATE, (StringBuilder)sb);
        Assertions.assertEquals((Object)"Sun, 06 Nov 1994 08:49:37 GMT", (Object)sb.toString());
    }

    @Test
    public void testParseAllMonths() {
        Assertions.assertEquals((int)0, (int)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun, 06 Jan 1994 08:49:37 GMT")));
        Assertions.assertEquals((int)1, (int)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun, 06 Feb 1994 08:49:37 GMT")));
        Assertions.assertEquals((int)2, (int)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun, 06 Mar 1994 08:49:37 GMT")));
        Assertions.assertEquals((int)3, (int)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun, 06 Apr 1994 08:49:37 GMT")));
        Assertions.assertEquals((int)4, (int)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun, 06 May 1994 08:49:37 GMT")));
        Assertions.assertEquals((int)5, (int)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun, 06 Jun 1994 08:49:37 GMT")));
        Assertions.assertEquals((int)6, (int)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun, 06 Jul 1994 08:49:37 GMT")));
        Assertions.assertEquals((int)7, (int)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun, 06 Aug 1994 08:49:37 GMT")));
        Assertions.assertEquals((int)8, (int)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun, 06 Sep 1994 08:49:37 GMT")));
        Assertions.assertEquals((int)9, (int)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun Oct 06 08:49:37 1994")));
        Assertions.assertEquals((int)10, (int)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun Nov 06 08:49:37 1994")));
        Assertions.assertEquals((int)11, (int)DateFormatterTest.getMonth(DateFormatter.parseHttpDate((CharSequence)"Sun Dec 06 08:49:37 1994")));
    }

    private static int getMonth(Date referenceDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(referenceDate);
        return cal.get(2);
    }
}

