/*
 * Decompiled with CFR 0.152.
 */
package io.netfall.libargon2;

import com.sun.jna.Native;
import io.netfall.libargon2.Argon2;
import io.netfall.libargon2.jna.Argon2Library;
import io.netfall.libargon2.jna.Uint32_t;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Arrays;

abstract class BaseArgon2
implements Argon2 {
    private static final int DEFAULT_SALT_LENGTH = 16;
    private static final int DEFAULT_HASH_LENGTH = 32;
    private static final String ASCII = "ASCII";
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private final SecureRandom secureRandom = new SecureRandom();
    private final int saltLen;
    private final int hashLen;
    final Argon2Library argon2Library = (Argon2Library)Native.loadLibrary((String)"argon2", Argon2Library.class);

    public BaseArgon2() {
        this(16, 32);
    }

    public BaseArgon2(int saltLen, int hashLen) {
        this.saltLen = saltLen;
        this.hashLen = hashLen;
    }

    protected int getHashLength() {
        return this.hashLen;
    }

    private byte[] generateSalt() {
        byte[] salt = new byte[this.saltLen];
        this.secureRandom.nextBytes(salt);
        return salt;
    }

    @Override
    public String hash(int iterations, int memory, int parallelism, char[] password) {
        return this.hash(iterations, memory, parallelism, password, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hash(int iterations, int memory, int parallelism, char[] password, Charset charset) {
        byte[] pwd = this.toByteArray(password, charset);
        try {
            String string = this.hashBytes(iterations, memory, parallelism, pwd);
            return string;
        }
        finally {
            this.wipeArray(pwd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hash(int iterations, int memory, int parallelism, String password, Charset charset) {
        byte[] pwd = password.getBytes(charset);
        try {
            String string = this.hashBytes(iterations, memory, parallelism, pwd);
            return string;
        }
        finally {
            this.wipeArray(pwd);
        }
    }

    @Override
    public String hash(int iterations, int memory, int parallelism, String password) {
        return this.hash(iterations, memory, parallelism, password, DEFAULT_CHARSET);
    }

    private String hashBytes(int iterations, int memory, int parallelism, byte[] pwd) {
        int len;
        byte[] encoded;
        Uint32_t parallelism_t;
        Uint32_t memory_t;
        Uint32_t iterations_t;
        byte[] salt = this.generateSalt();
        int result = this.callLibraryHash(pwd, salt, iterations_t = new Uint32_t(iterations), memory_t = new Uint32_t(memory), parallelism_t = new Uint32_t(parallelism), encoded = new byte[len = this.argon2Library.argon2_encodedlen(iterations_t, memory_t, parallelism_t, new Uint32_t(salt.length), new Uint32_t(this.hashLen)).intValue()]);
        if (result != 0) {
            String errMsg = this.argon2Library.argon2_error_message(result);
            throw new IllegalStateException(String.format("%s (%d)", errMsg, result));
        }
        return Native.toString((byte[])encoded, (String)ASCII);
    }

    @Override
    public boolean verify(String hash, String password) {
        return this.verify(hash, password, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(String hash, String password, Charset charset) {
        byte[] pwd = password.getBytes(charset);
        try {
            boolean bl = this.verifyBytes(hash, pwd);
            return bl;
        }
        finally {
            this.wipeArray(pwd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(String hash, char[] password, Charset charset) {
        byte[] pwd = this.toByteArray(password, charset);
        try {
            boolean bl = this.verifyBytes(hash, pwd);
            return bl;
        }
        finally {
            this.wipeArray(pwd);
        }
    }

    @Override
    public boolean verify(String hash, char[] password) {
        return this.verify(hash, password, DEFAULT_CHARSET);
    }

    private boolean verifyBytes(String hash, byte[] pwd) {
        byte[] encoded = Native.toByteArray((String)hash, (String)ASCII);
        int result = this.callLibraryVerify(encoded, pwd);
        return result == 0;
    }

    protected abstract int callLibraryHash(byte[] var1, byte[] var2, Uint32_t var3, Uint32_t var4, Uint32_t var5, byte[] var6);

    protected abstract int callLibraryVerify(byte[] var1, byte[] var2);

    private void wipeArray(byte[] array) {
        assert (array != null);
        Arrays.fill(array, (byte)0);
    }

    @Override
    public void wipeArray(char[] array) {
        Arrays.fill(array, '\u0000');
    }

    private byte[] toByteArray(char[] chars, Charset charset) {
        assert (chars != null);
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = charset.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(charBuffer.array(), '\u0000');
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }
}

