package io.netfall.libargon2;

import io.netfall.libargon2.jna.Size_t;
import io.netfall.libargon2.jna.Uint32_t;

/**
 * Argon2i password hashing function.
 */
public class Argon2d extends BaseArgon2 {
    /**
     * Constructor.
     * <p>
     * Uses default salt and hash lengths.
     */
    public Argon2d() {
    }

    /**
     * Constructor.
     *
     * @param saltLen Salt length in bytes.
     * @param hashLen Hash length in bytes.
     */
    public Argon2d(int saltLen, int hashLen) {
        super(saltLen, hashLen);
    }

    @Override
    protected int callLibraryHash(byte[] pwd, byte[] salt, Uint32_t iterations, Uint32_t memory, Uint32_t parallelism, byte[] encoded) {
        return argon2Library.argon2d_hash_encoded(
                iterations, memory, parallelism, pwd, new Size_t(pwd.length),
                salt, new Size_t(salt.length), new Size_t(getHashLength()), encoded, new Size_t(encoded.length)
        );
    }

    @Override
    protected int callLibraryVerify(byte[] encoded, byte[] pwd) {
        return argon2Library.argon2d_verify(encoded, pwd, new Size_t(pwd.length));
    }
}
