/*
 * Decompiled with CFR 0.152.
 */
package io.neba.spring.resourcemodels.registration;

import io.neba.api.annotations.ResourceModel;
import io.neba.api.spi.ResourceModelFactory;
import io.neba.spring.resourcemodels.registration.Annotations;
import io.neba.spring.resourcemodels.registration.SpringBasedModelDefinition;
import io.neba.spring.resourcemodels.registration.SpringResourceModelFactory;
import java.lang.annotation.IncompleteAnnotationException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.stereotype.Service;

@Service
public class SpringModelRegistrar {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<Bundle, ServiceRegistration<?>> bundlesWithModels = new ConcurrentHashMap();

    public void registerModels(BundleContext bundleContext, ConfigurableListableBeanFactory factory) {
        Bundle bundle = bundleContext.getBundle();
        this.logger.info("Discovering resource models in bundle {}  ...", (Object)bundle.getSymbolicName());
        List<SpringBasedModelDefinition> modelDefinitions = Arrays.stream(BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)factory, Object.class)).map(beanName -> {
            Class modelType = factory.getType(beanName);
            if (modelType == null) {
                this.logger.error("The spring application context cannot determine the type of the resource model bean {} in bundle {}. Skipping this model.", beanName, (Object)bundle);
                return null;
            }
            ResourceModel model = this.getResourceModelAnnotation(factory, (String)beanName, modelType);
            if (model == null) {
                return null;
            }
            return new SpringBasedModelDefinition(model, (String)beanName, modelType);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.description", "Provides NEBA resource models from Spring Beans annotated with @" + ResourceModel.class.getSimpleName() + ".");
        properties.put("service.vendor", "neba.io");
        this.bundlesWithModels.put(bundle, bundle.getBundleContext().registerService(ResourceModelFactory.class.getName(), (Object)new SpringResourceModelFactory(modelDefinitions, factory), properties));
    }

    private ResourceModel getResourceModelAnnotation(ConfigurableListableBeanFactory factory, String n, Class<?> beanType) {
        try {
            return (ResourceModel)factory.findAnnotationOnBean(n, ResourceModel.class);
        }
        catch (IncompleteAnnotationException e) {
            return Annotations.annotations(beanType).get(ResourceModel.class);
        }
    }

    public void unregister(Bundle bundle) {
        Optional.ofNullable(this.bundlesWithModels.remove(bundle)).ifPresent(ServiceRegistration::unregister);
    }

    @PreDestroy
    protected void shutdown() {
        this.bundlesWithModels.forEach((b, s) -> {
            try {
                s.unregister();
            }
            catch (IllegalStateException e) {
                this.logger.trace("Cannot unregister the resource model factory service. The service may already have been unregistered.", (Throwable)e);
            }
        });
    }
}

