/*
 * Decompiled with CFR 0.152.
 */
package io.neba.spring.mvc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.request.RequestParameter;
import org.springframework.web.multipart.MultipartFile;

public class SlingMultipartFile
implements MultipartFile {
    private final RequestParameter source;
    private final String name;

    SlingMultipartFile(String paramName, RequestParameter requestParameter) {
        this.source = requestParameter;
        this.name = paramName;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.source.getFileName();
    }

    public String getContentType() {
        return this.source.getContentType();
    }

    public boolean isEmpty() {
        return this.source.getSize() == 0L;
    }

    public long getSize() {
        return this.source.getSize();
    }

    @Nonnull
    public byte[] getBytes() {
        return this.source.get();
    }

    public InputStream getInputStream() throws IOException {
        return this.source.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferTo(File dest) throws IOException, IllegalStateException {
        if (dest.exists() && !dest.delete()) {
            throw new IOException("Destination file [" + dest.getAbsolutePath() + "] already exists and could not be deleted");
        }
        InputStream in = this.getInputStream();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
            ((OutputStream)out).flush();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

