/*
 * Decompiled with CFR 0.152.
 */
package io.neba.spring.mvc;

import io.neba.spring.mvc.BundleSpecificDispatcherServlet;
import io.neba.spring.mvc.SlingMvcServletRequest;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.context.ServletConfigAware;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.support.ServletContextAwareProcessor;

@Service
public class MvcServlet
extends SlingAllMethodsServlet {
    private final Map<Bundle, BundleSpecificDispatcherServlet> mvcCapableBundles = new ConcurrentHashMap<Bundle, BundleSpecificDispatcherServlet>();
    private final Logger logger = LoggerFactory.getLogger((String)"mvc");
    @Autowired
    private ServletContext servletContext;
    @Autowired
    private ServletResolver servletResolver;

    public void enableMvc(ConfigurableListableBeanFactory factory, BundleContext context) {
        if (factory == null) {
            throw new IllegalArgumentException("Method argument factory must not be null.");
        }
        if (context == null) {
            throw new IllegalArgumentException("Method argument context must not be null.");
        }
        BundleAwareServletConfig servletConfig = new BundleAwareServletConfig(context);
        factory.addBeanPostProcessor((BeanPostProcessor)new ServletContextAwareProcessor(this.servletContext, (ServletConfig)servletConfig));
        factory.ignoreDependencyInterface(ServletContextAware.class);
        factory.ignoreDependencyInterface(ServletConfigAware.class);
        BundleSpecificDispatcherServlet dispatcherServlet = this.createBundleSpecificDispatcherServlet(factory, servletConfig);
        factory.registerSingleton(this.generateNameFor(BundleSpecificDispatcherServlet.class), (Object)dispatcherServlet);
        this.mvcCapableBundles.put(context.getBundle(), dispatcherServlet);
    }

    public void disableMvc(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Method argument bundle must not be null.");
        }
        this.mvcCapableBundles.remove(bundle);
    }

    BundleSpecificDispatcherServlet createBundleSpecificDispatcherServlet(ConfigurableListableBeanFactory factory, ServletConfig config) {
        return new BundleSpecificDispatcherServlet(config, this.servletResolver, factory);
    }

    protected boolean mayService(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException, IOException {
        if (super.mayService(request, response)) {
            return true;
        }
        if ("PATCH".equals(request.getMethod())) {
            this.doPatch(request, response);
            return true;
        }
        return false;
    }

    private void doPatch(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    protected void doPut(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    protected void doDelete(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    protected void doHead(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    protected void doOptions(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    protected void doTrace(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    private void handle(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        SlingMvcServletRequest slingRequest = new SlingMvcServletRequest(request);
        for (BundleSpecificDispatcherServlet context : this.mvcCapableBundles.values()) {
            if (!context.hasHandlerFor((HttpServletRequest)slingRequest)) continue;
            context.service((ServletRequest)slingRequest, (ServletResponse)response);
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("No handler found for request {}.", (Object)request);
        }
        response.sendError(404);
    }

    private String generateNameFor(Class<?> type) {
        return type.getSimpleName() + "#" + "0";
    }

    private class BundleAwareServletConfig
    implements ServletConfig {
        private final BundleContext context;

        BundleAwareServletConfig(BundleContext context) {
            this.context = context;
        }

        public String getServletName() {
            return BundleSpecificDispatcherServlet.class.getSimpleName() + " for bundle " + this.context.getBundle().getSymbolicName();
        }

        public ServletContext getServletContext() {
            return MvcServlet.this.servletContext;
        }

        public String getInitParameter(String s) {
            return null;
        }

        public Enumeration<String> getInitParameterNames() {
            return new Hashtable().keys();
        }
    }
}

