/*
 * Decompiled with CFR 0.152.
 */
package io.neba.spring.resourcemodels.registration;

import io.neba.api.annotations.ResourceModel;
import io.neba.api.spi.ResourceModelFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.stereotype.Service;

@Service
public class SpringModelRegistrar {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<Bundle, ServiceRegistration> bundlesWithModels = new ConcurrentHashMap<Bundle, ServiceRegistration>();

    public void registerModels(BundleContext bundleContext, final ConfigurableListableBeanFactory factory) {
        Bundle bundle = bundleContext.getBundle();
        this.logger.info("Discovering resource models in bundle {}  ...", (Object)bundle.getSymbolicName());
        final List modelDefinitions = Arrays.stream(BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)factory, Object.class)).map(n -> {
            final ResourceModel model = (ResourceModel)factory.findAnnotationOnBean(n, ResourceModel.class);
            if (model == null) {
                return null;
            }
            return new ResourceModelFactory.ModelDefinition((String)n, factory){
                final /* synthetic */ String val$n;
                final /* synthetic */ ConfigurableListableBeanFactory val$factory;
                {
                    this.val$n = string;
                    this.val$factory = configurableListableBeanFactory;
                }

                @Nonnull
                public ResourceModel getResourceModel() {
                    return model;
                }

                @Nonnull
                public String getName() {
                    return this.val$n;
                }

                @Nonnull
                public Class<?> getType() {
                    return this.val$factory.getType(this.val$n);
                }
            };
        }).filter(Objects::nonNull).collect(Collectors.toList());
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.description", "Provides NEBA resource models from Spring Beans annotated with @" + ResourceModel.class.getSimpleName() + ".");
        properties.put("service.vendor", "neba.io");
        this.bundlesWithModels.put(bundle, bundle.getBundleContext().registerService(ResourceModelFactory.class.getName(), (Object)new ResourceModelFactory(){

            @Nonnull
            public Collection<ResourceModelFactory.ModelDefinition> getModelDefinitions() {
                return modelDefinitions;
            }

            @Nonnull
            public Object getModel(@Nonnull ResourceModelFactory.ModelDefinition modelDefinition) {
                return factory.getBean(modelDefinition.getName());
            }
        }, properties));
    }

    public void unregister(Bundle bundle) {
        Optional.ofNullable(this.bundlesWithModels.remove(bundle)).ifPresent(ServiceRegistration::unregister);
    }

    @PreDestroy
    protected void shutdown() {
        this.bundlesWithModels.forEach((b, s) -> {
            try {
                s.unregister();
            }
            catch (IllegalStateException e) {
                this.logger.trace("Cannot unregister the resource model factory service. The service may already have been unregistered.", (Throwable)e);
            }
        });
    }
}

