/*
 * Decompiled with CFR 0.152.
 */
package io.neba.spring.mvc;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.springframework.web.servlet.View;

public class SlingServletView
implements View {
    private final String resourceType;
    private final Servlet servlet;

    public SlingServletView(String resourceType, Servlet servlet) {
        if (resourceType == null) {
            throw new IllegalArgumentException("Method argument resourceType must not be null.");
        }
        if (servlet == null) {
            throw new IllegalArgumentException("Method argument servlet must not be null.");
        }
        this.resourceType = resourceType;
        this.servlet = servlet;
    }

    public String getContentType() {
        return null;
    }

    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        ResourceResolver resourceResolver = slingRequest.getResourceResolver();
        String resourcePath = request.getPathInfo();
        SpringControllerModelResource resource = new SpringControllerModelResource(resourceResolver, resourcePath, this.resourceType, model);
        MvcResourceRequest wrapped = new MvcResourceRequest(slingRequest, (Resource)resource);
        if (model != null) {
            for (Map.Entry<String, ?> entry : model.entrySet()) {
                wrapped.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        this.servlet.service((ServletRequest)wrapped, (ServletResponse)response);
    }

    private static class SpringControllerModelResource
    extends SyntheticResource {
        private final Map<String, ?> model;

        SpringControllerModelResource(ResourceResolver resourceResolver, String resourcePath, String resourceType, Map<String, ?> model) {
            super(resourceResolver, resourcePath, resourceType);
            this.model = model;
        }

        public ValueMap getValueMap() {
            ValueMapDecorator properties = new ValueMapDecorator(new HashMap());
            if (this.model != null) {
                properties.putAll(this.model);
            }
            return properties;
        }

        public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
            if (type.isAssignableFrom(ValueMap.class)) {
                return (AdapterType)this.getValueMap();
            }
            return (AdapterType)super.adaptTo(type);
        }
    }

    static class MvcResourceRequest
    extends SlingHttpServletRequestWrapper {
        private final Resource resource;

        MvcResourceRequest(SlingHttpServletRequest slingRequest, Resource resource) {
            super(slingRequest);
            this.resource = resource;
        }

        public Resource getResource() {
            return this.resource;
        }
    }
}

