/*
 * Decompiled with CFR 0.152.
 */
package io.namastack.outbox.retry;

import io.namastack.outbox.OutboxProperties;
import io.namastack.outbox.retry.ExponentialBackoffRetryPolicy;
import io.namastack.outbox.retry.FixedDelayRetryPolicy;
import io.namastack.outbox.retry.JitteredRetryPolicy;
import io.namastack.outbox.retry.OutboxRetryPolicy;
import java.time.Duration;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lio/namastack/outbox/retry/OutboxRetryPolicyFactory;", "", "<init>", "()V", "create", "Lio/namastack/outbox/retry/OutboxRetryPolicy;", "name", "", "retryProperties", "Lio/namastack/outbox/OutboxProperties$Retry;", "namastack-outbox-core"})
public final class OutboxRetryPolicyFactory {
    @NotNull
    public static final OutboxRetryPolicyFactory INSTANCE = new OutboxRetryPolicyFactory();

    private OutboxRetryPolicyFactory() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final OutboxRetryPolicy create(@NotNull String name, @NotNull OutboxProperties.Retry retryProperties) {
        OutboxRetryPolicy outboxRetryPolicy;
        block7: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)retryProperties, (String)"retryProperties");
            String string = name.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String string2 = string;
            switch (string2.hashCode()) {
                case -1765414587: {
                    if (string2.equals("exponential")) break;
                    throw new IllegalStateException(("Unsupported retry-policy: " + name).toString());
                }
                case -2110827893: {
                    if (!string2.equals("jittered")) {
                        throw new IllegalStateException(("Unsupported retry-policy: " + name).toString());
                    }
                    break block7;
                }
                case 97445748: {
                    if (!string2.equals("fixed")) throw new IllegalStateException(("Unsupported retry-policy: " + name).toString());
                    Duration duration = Duration.ofMillis(retryProperties.getFixed().getDelay());
                    Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
                    outboxRetryPolicy = new FixedDelayRetryPolicy(duration);
                    return outboxRetryPolicy;
                }
            }
            Duration duration = Duration.ofMillis(retryProperties.getExponential().getInitialDelay());
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
            Duration duration2 = Duration.ofMillis(retryProperties.getExponential().getMaxDelay());
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofMillis(...)");
            outboxRetryPolicy = new ExponentialBackoffRetryPolicy(duration, duration2, retryProperties.getExponential().getMultiplier());
            return outboxRetryPolicy;
        }
        String basePolicy = retryProperties.getJittered().getBasePolicy();
        String string = basePolicy.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)string, (Object)"jittered")) {
            throw new IllegalStateException("Cannot create a jittered policy with jittered base policy.".toString());
        }
        OutboxRetryPolicy outboxRetryPolicy2 = this.create(basePolicy, retryProperties);
        Duration duration = Duration.ofMillis(retryProperties.getJittered().getJitter());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        outboxRetryPolicy = new JitteredRetryPolicy(outboxRetryPolicy2, duration);
        return outboxRetryPolicy;
        throw new IllegalStateException(("Unsupported retry-policy: " + name).toString());
    }
}

