/*
 * Decompiled with CFR 0.152.
 */
package io.namastack.outbox.retry;

import io.namastack.outbox.retry.OutboxRetryPolicy;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/namastack/outbox/retry/JitteredRetryPolicy;", "Lio/namastack/outbox/retry/OutboxRetryPolicy;", "basePolicy", "jitter", "Ljava/time/Duration;", "<init>", "(Lio/namastack/outbox/retry/OutboxRetryPolicy;Ljava/time/Duration;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "shouldRetry", "", "exception", "", "nextDelay", "retryCount", "", "namastack-outbox-core"})
public final class JitteredRetryPolicy
implements OutboxRetryPolicy {
    @NotNull
    private final OutboxRetryPolicy basePolicy;
    @NotNull
    private final Duration jitter;
    private final Logger log;

    public JitteredRetryPolicy(@NotNull OutboxRetryPolicy basePolicy, @NotNull Duration jitter) {
        Intrinsics.checkNotNullParameter((Object)basePolicy, (String)"basePolicy");
        Intrinsics.checkNotNullParameter((Object)jitter, (String)"jitter");
        this.basePolicy = basePolicy;
        this.jitter = jitter;
        this.log = LoggerFactory.getLogger(JitteredRetryPolicy.class);
    }

    @Override
    public boolean shouldRetry(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        return this.basePolicy.shouldRetry(exception);
    }

    @Override
    @NotNull
    public Duration nextDelay(int retryCount) {
        Duration baseDelay = this.basePolicy.nextDelay(retryCount);
        long jitterMillis = (long)(Math.random() * (double)this.jitter.toMillis());
        Duration finalDelay = baseDelay.plusMillis(jitterMillis);
        Object[] objectArray = new Object[]{retryCount, baseDelay.toMillis(), this.basePolicy.getClass().getSimpleName(), jitterMillis, this.jitter.toMillis(), finalDelay.toMillis()};
        this.log.debug("\ud83c\udfb2 Jittered retry delay calculation: retry #{} -> base delay: {}ms (from {}), jitter: +{}ms (max: {}ms), final delay: {}ms", objectArray);
        Intrinsics.checkNotNull((Object)finalDelay);
        return finalDelay;
    }
}

