/*
 * Decompiled with CFR 0.152.
 */
package io.namastack.outbox.retry;

import io.namastack.outbox.retry.OutboxRetryPolicy;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/namastack/outbox/retry/ExponentialBackoffRetryPolicy;", "Lio/namastack/outbox/retry/OutboxRetryPolicy;", "initialDelay", "Ljava/time/Duration;", "maxDelay", "backoffMultiplier", "", "<init>", "(Ljava/time/Duration;Ljava/time/Duration;D)V", "shouldRetry", "", "exception", "", "nextDelay", "retryCount", "", "namastack-outbox-core"})
public final class ExponentialBackoffRetryPolicy
implements OutboxRetryPolicy {
    @NotNull
    private final Duration initialDelay;
    @NotNull
    private final Duration maxDelay;
    private final double backoffMultiplier;

    public ExponentialBackoffRetryPolicy(@NotNull Duration initialDelay, @NotNull Duration maxDelay, double backoffMultiplier) {
        Intrinsics.checkNotNullParameter((Object)initialDelay, (String)"initialDelay");
        Intrinsics.checkNotNullParameter((Object)maxDelay, (String)"maxDelay");
        this.initialDelay = initialDelay;
        this.maxDelay = maxDelay;
        this.backoffMultiplier = backoffMultiplier;
    }

    @Override
    public boolean shouldRetry(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        return true;
    }

    @Override
    @NotNull
    public Duration nextDelay(int retryCount) {
        long delayMillis = (long)((double)this.initialDelay.toMillis() * Math.pow(this.backoffMultiplier, retryCount));
        Duration duration = Duration.ofMillis(Math.min(delayMillis, this.maxDelay.toMillis()));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        return duration;
    }
}

