/*
 * Decompiled with CFR 0.152.
 */
package io.namastack.outbox.partition;

import io.namastack.outbox.OutboxInstanceRegistry;
import io.namastack.outbox.partition.PartitionStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\u0011\u001a\u00020\fJ\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u000bJ\b\u0010\u0016\u001a\u00020\u0017H\u0007J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\u0016\u0010\u0019\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0002J\"\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0002J0\u0010\u001d\u001a\u00020\u00172\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u00132\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0013H\u0002J(\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000b0\u00132\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0013H\u0002J\u0006\u0010\"\u001a\u00020#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/namastack/outbox/partition/PartitionCoordinator;", "", "instanceRegistry", "Lio/namastack/outbox/OutboxInstanceRegistry;", "<init>", "(Lio/namastack/outbox/OutboxInstanceRegistry;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "partitionAssignments", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "lastKnownInstances", "", "getAssignedPartitions", "", "instanceId", "getCurrentAssignments", "", "getInstanceForPartition", "partition", "checkForRebalancing", "", "ensurePartitionsAssigned", "rebalancePartitions", "instances", "calculatePartitionAssignments", "sortedInstances", "logPartitionChanges", "oldAssignments", "newAssignments", "calculateInstanceStats", "assignments", "getPartitionStats", "Lio/namastack/outbox/partition/PartitionStats;", "namastack-outbox-core"})
@SourceDebugExtension(value={"SMAP\nPartitionCoordinator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartitionCoordinator.kt\nio/namastack/outbox/partition/PartitionCoordinator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,217:1\n774#2:218\n865#2,2:219\n1563#2:221\n1634#2,3:222\n1550#2:229\n216#3,2:225\n216#3,2:227\n*S KotlinDebug\n*F\n+ 1 PartitionCoordinator.kt\nio/namastack/outbox/partition/PartitionCoordinator\n*L\n38#1:218\n38#1:219,2\n39#1:221\n39#1:222,3\n189#1:229\n159#1:225,2\n177#1:227,2\n*E\n"})
public final class PartitionCoordinator {
    @NotNull
    private final OutboxInstanceRegistry instanceRegistry;
    private final Logger log;
    @NotNull
    private final ConcurrentHashMap<Integer, String> partitionAssignments;
    @NotNull
    private Set<String> lastKnownInstances;

    public PartitionCoordinator(@NotNull OutboxInstanceRegistry instanceRegistry) {
        Intrinsics.checkNotNullParameter((Object)instanceRegistry, (String)"instanceRegistry");
        this.instanceRegistry = instanceRegistry;
        this.log = LoggerFactory.getLogger(PartitionCoordinator.class);
        this.partitionAssignments = new ConcurrentHashMap();
        this.lastKnownInstances = SetsKt.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> getAssignedPartitions(@NotNull String instanceId) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
        this.ensurePartitionsAssigned();
        Set<Map.Entry<Integer, String>> set = this.partitionAssignments.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getValue(), (Object)instanceId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Integer)it.getKey());
        }
        return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final Map<Integer, String> getCurrentAssignments() {
        this.ensurePartitionsAssigned();
        return new HashMap(this.partitionAssignments);
    }

    @Nullable
    public final String getInstanceForPartition(int partition) {
        this.ensurePartitionsAssigned();
        return this.partitionAssignments.get(partition);
    }

    @Scheduled(fixedRate=15000L)
    public final void checkForRebalancing() {
        try {
            Set<String> currentInstances = this.instanceRegistry.getActiveInstanceIds();
            if (!Intrinsics.areEqual(currentInstances, this.lastKnownInstances)) {
                this.log.info("\ud83d\udd04 Instance change detected: {} -> {}", this.lastKnownInstances, currentInstances);
                this.rebalancePartitions(currentInstances);
                this.lastKnownInstances = currentInstances;
            }
        }
        catch (Exception ex) {
            this.log.error("Error during partition rebalancing check", (Throwable)ex);
        }
    }

    private final void ensurePartitionsAssigned() {
        Set<String> currentInstances;
        if (this.partitionAssignments.isEmpty() && !((Collection)(currentInstances = this.instanceRegistry.getActiveInstanceIds())).isEmpty()) {
            this.rebalancePartitions(currentInstances);
        }
    }

    private final void rebalancePartitions(Set<String> instances) {
        if (instances.isEmpty()) {
            this.log.warn("\u26a0\ufe0f No active instances available for partition assignment");
            this.partitionAssignments.clear();
            return;
        }
        List sortedInstances = CollectionsKt.sorted((Iterable)instances);
        HashMap oldAssignments = new HashMap(this.partitionAssignments);
        this.log.info("\ud83c\udfaf Rebalancing {} partitions across {} instances", (Object)256, (Object)instances.size());
        Map<Integer, String> newAssignments = this.calculatePartitionAssignments(sortedInstances);
        this.logPartitionChanges(oldAssignments, newAssignments);
        this.partitionAssignments.clear();
        this.partitionAssignments.putAll(newAssignments);
        this.log.info("\u2705 Partition rebalancing completed");
    }

    private final Map<Integer, String> calculatePartitionAssignments(List<String> sortedInstances) {
        Map assignments = new LinkedHashMap();
        for (int partition = 0; partition < 256; ++partition) {
            int instanceIndex = partition % sortedInstances.size();
            assignments.put(partition, sortedInstances.get(instanceIndex));
        }
        return assignments;
    }

    private final void logPartitionChanges(Map<Integer, String> oldAssignments, Map<Integer, String> newAssignments) {
        Map<String, Integer> instanceStats;
        int transferred = 0;
        int newPartitions = 0;
        Map<Integer, String> $this$forEach$iv = newAssignments;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, String> element$iv;
            Map.Entry<Integer, String> entry = element$iv = iterator.next();
            boolean bl = false;
            int partition = ((Number)entry.getKey()).intValue();
            String newInstance = entry.getValue();
            String oldInstance = oldAssignments.get(partition);
            if (oldInstance == null) {
                ++newPartitions;
                continue;
            }
            if (Intrinsics.areEqual((Object)oldInstance, (Object)newInstance)) continue;
            ++transferred;
        }
        if (transferred > 0 || newPartitions > 0) {
            this.log.info("\ud83d\udcca Partition changes: {} transferred, {} new assignments", (Object)transferred, (Object)newPartitions);
        }
        Map<String, Integer> $this$forEach$iv2 = instanceStats = this.calculateInstanceStats(newAssignments);
        boolean $i$f$forEach2 = false;
        Iterator<Map.Entry<String, Integer>> iterator2 = $this$forEach$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, Integer> element$iv;
            Map.Entry<String, Integer> entry = element$iv = iterator2.next();
            boolean bl = false;
            String instanceId = entry.getKey();
            int count = ((Number)entry.getValue()).intValue();
            this.log.info("\ud83d\udccb Instance {} assigned {} partitions", (Object)instanceId, (Object)count);
        }
    }

    private final Map<String, Integer> calculateInstanceStats(Map<Integer, String> assignments) {
        Iterable $this$groupingBy$iv = assignments.values();
        boolean $i$f$groupingBy = false;
        return GroupingKt.eachCount((Grouping)((Grouping)new Grouping<String, String>($this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            public Iterator<String> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                String it = (String)element;
                boolean bl = false;
                return var2_2;
            }
        }));
    }

    @NotNull
    public final PartitionStats getPartitionStats() {
        this.ensurePartitionsAssigned();
        Map<String, Integer> instanceStats = this.calculateInstanceStats((Map<Integer, String>)this.partitionAssignments);
        int totalPartitions = this.partitionAssignments.size();
        int totalInstances = instanceStats.size();
        double avgPartitionsPerInstance = totalInstances > 0 ? (double)totalPartitions / (double)totalInstances : 0.0;
        return new PartitionStats(totalPartitions, totalInstances, avgPartitionsPerInstance, instanceStats);
    }
}

